#ifndef THUDLINE_H
#define THUDLINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qslider.h>

#include <btoolbutton.h>
#include <togglepixmap.h>
#include <togglecolor.h>
#include <thudconstants.h>

class SampleName : public QFrame
{
	Q_OBJECT
public:
	SampleName( QWidget *parent );

	void paintEvent( QPaintEvent *pev );
	void setName( QString newname );

private:
	QString *namestring;
};

class ThudLine : public QWidget
{
	Q_OBJECT
public:
	ThudLine( int songchannel, QWidget *parent = 0 );
	void updateNotePointers();

private:

	// Widgets
	SampleName *namebox;
	BToolButton *load;
	ToggleColor *mute;
	ToggleColor *solo;
	WatcherTogglePixmap *button[ THUD_NUM_BEATS ];
	QSlider *volumeSelect;
	QSlider *panSelect;

	// Data
	int channel;

private slots:
	void loadSamplePressed();
	void mutePressed( bool newmute );
	void soloPressed( bool newsolo );
	void setVolume( int newvolume );
	void setPan( int newpan );
};

#endif // THUDLINE_H
