#ifndef DSPCONTROL_H_INCLUDED
#define DSPCONTROL_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/time.h>
#include <qlist.h>

#include <constants.h>
#include <globals.h>
#include <dspout.h>
#include <thread.h>

class dspcontrol : public thread
{
private:
	// we keep this around for doing selects on.
	bool isthreaded;
	bool isadeviceactive;

	unsigned int pos[ MAX_DSP_DEVICES ]; // current frame in current beat

	virtual void thread_main(void);
	void watchDevices();
	void doSelect( bool block );

	void clearBuffer( DSPDeviceClass *curdev );
	void fillBuffer( DSPDeviceClass *curdev );
	void checkRequests();

public:
	dspcontrol();
	~dspcontrol();

	bool run(void) { return thread::run(); }

	void timerTick();
};

#endif // DSPCONTROL_H_INCLUDED
