#ifndef BSPINBOX_H_INCLUDED
#define BSPINBOX_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qframe.h>
#include <qpushbutton.h>
#include <qlcdnumber.h>
#include <qtimer.h>

class RapidButton : public QPushButton
{
	Q_OBJECT
private:
	QTimer *push_timer;
	unsigned int *value;
	bool going_up;
	bool modified;

public:
	RapidButton( bool up, unsigned int *val, QWidget *parent );
	void mousePressEvent( QMouseEvent *mev );
	void mouseReleaseEvent( QMouseEvent *mev );

public slots:
	void valueIncr();

signals:
	void valueModified();
};

class BSpinbox : public QFrame
{
	Q_OBJECT
private:
	QLCDNumber *lcd;
	RapidButton *up;
	RapidButton *down;
	unsigned int value, min_value, max_value;

public:
	BSpinbox( unsigned int initial, unsigned int min, unsigned int max, unsigned int digits, QWidget * parent );

	void resize(int w, int h);
	void setValue(unsigned int v);
	inline int getValue() { return value; };

public slots:
	void updateNumber();

signals:
	void valueChanged(int);
};

#endif
