#ifndef BBPMSELECT_H_INCLUDED
#define BBPMSELECT_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <btoolbutton.h>

class setBPMWidget : public QWidget
{
	Q_OBJECT
private:
	QLabel *label;
	QLineEdit *setbpm;
	QPushButton *okay;
	QPushButton *cancel;
private slots:
	void _pushedOkay();
	void _pushedCancel();

public:
	setBPMWidget( QWidget *parent );
	void setText( const char *newtext );

signals:
	void newValue( int );
};

class BBPMSelect : public QWidget
{
	Q_OBJECT
private:
	QLabel *note;
	QLabel *equals;
	BToolButton *changebpm;
	setBPMWidget *setbpm;
private slots:
	void changingBPM();

public:
	BBPMSelect( QWidget *parent );
	void resetBPM();

public slots:
	void setBPM( int newbpm );

signals:
	void bpmChanged( int );
};

#endif
