/***************************************************************************
                          mp3entrypropertiesdlgimpl.cpp  -  description
                             -------------------
    begin                : Mon Feb 26 2001
    copyright            : (C) 2001 by Edwin Schepers
    email                : zeus@castel.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <errno.h>

#include <kmessagebox.h>
#include <qlineedit.h>
#include <qstring.h>

#include "mp3entrypropertiesdlgimpl.h"
#include "dbhandling.h"
#include "mp3layer.h"

MP3EntryPropertiesDlgImpl::MP3EntryPropertiesDlgImpl(QString filename, QString artist, QString title,
																											QString album, QString year):
							MP3EntryPropertiesDlg(0, 0, true){

	char tmpmsg[120];
	QString Qtmpmsg;
	FILE *fileptr;
  Layer layer;
  unsigned int lengte;

//	MP3Database = mp3database;	

 if ( (fileptr = fopen(filename.latin1(), "rb")) == NULL) {
        Qtmpmsg += "unable to open ";
				Qtmpmsg += filename.latin1();
				Qtmpmsg += " : ";
				Qtmpmsg += strerror(errno);
				KMessageBox::error(0, tmpmsg);
 }

 layer.setFileName(filename.latin1());
 layer.scan(fileptr);
 lengte = (unsigned int)layer.length();
 //printf("bitrate=%u, freq=%u, length=%ld, layername=%s\n", layer.bitrate(), layer.sfreq(), layer.length(),
//        layer.layer_name());
 fclose(fileptr);


 ArtistLineEdit->setText(artist);
 TitleLineEdit->setText(title);
 AlbumLineEdit->setText(album);
 YearLineEdit->setText(year);

 sprintf(tmpmsg, "%u kbps", layer.bitrate());
 BitrateLineEdit->setText(tmpmsg);

 sprintf(tmpmsg, "%u Hz", layer.sfreq());
 SampleFreqLineEdit->setText(tmpmsg);

 sprintf(tmpmsg, "%ld:%02ld min.", layer.length()/60, layer.length()%60);
 DurationLineEdit->setText(tmpmsg);

}

MP3EntryPropertiesDlgImpl::~MP3EntryPropertiesDlgImpl(){
}


void MP3EntryPropertiesDlgImpl::slotApply(void) {

// DBHandling db(mp3Database);

// db.changeEntry("/home/edwin/mp3.db", (char*)ArtistLineEdit->text(), (char*)TitleLineEdit->text(),
//								(char*)AlbumLineEdit->text(), (char*)YearLineEdit->text());

 //accept();
}
