/***************************************************************************
                          kmp3db.h  -  description                              
                             -------------------                                         
    begin                : Thu May 27 1999                                           
    copyright            : (C) 1999 by Edwin Schepers                         
    email                : zeus@castel.nl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef _KMP3DB_H_
#define _KMP3DB_H_


#include <qlistview.h>
#include <qevent.h>

#include <kfm.h>
#include <kapp.h>
#include <ksconfig.h>
#include <ktopwidget.h>
#include <kpopmenu.h>
#include <kconfig.h>

#include "mp3listview.h"
#include "dbhandling.h"
#include "mpqlistviewitem.h"
#include "scqlineedit.h"

#define ARTIST_COL	0
#define TITLE_COL		1
#define ALBUM_COL		2
#define YEAR_COL		3
#define FN_COL			4
#define HDCD_COL		5

class CDList {

 public:
 CDList(char *name) { strcpy(CDname, name); };
 char CDname[100+1];
};


//class TopLevel : public KTopLevelWidget
class TopLevel : public KTMainWindow
{
  Q_OBJECT

 	public:
    TopLevel( QWidget *parent=0, const char *name=0 );
    ~TopLevel();
    QPopupMenu *file,*configmenu, *help, *commands;
    DBhandling *dbhandling;
 	protected:
 		void setupMenuBar();
    virtual bool eventFilter(QObject *, QEvent * );
    virtual void resizeEvent(QResizeEvent *re);

  public slots:
   // menu items
   void close(void);
   void configure(void);
   void about(void);
   void contents(void);
   void add_mp3(void);
   void search(void);
   void save_settings(void);
   void menu_play_mp3(void);
   void read_settings(void);
   void play_mp3(QListViewItem *item);
   void add_mp3_to_playlist(QListViewItem *item);
   void menu_add_mp3_to_playlist(void);
   void show_menu(QListViewItem *item, const QPoint &pos, int i);
   void play_from_menu(void);
   void add_to_playlist_from_menu(void);
   void delete_from_menu(void);
   void update_statusbar(QListViewItem *item);

	private:
		 KMenuBar *menubar;
     QGroupBox *outerframe;
     QLineEdit *filnamecmd;
     QCheckBox *chkboxfilename;
     QCheckBox *chkboxArtist;
     QCheckBox *chkboxTitle;
     QCheckBox *chkboxAlbum;
     QCheckBox *chkboxCD;

     QCheckBox *chkboxfilename_cs; // case sensitive checkboxes
     QCheckBox *chkboxArtist_cs;
     QCheckBox *chkboxTitle_cs;
     QCheckBox *chkboxAlbum_cs;

     QLineEdit *artistcmd;
     QListView *mp3list;
     QLineEdit *titlecmd;
     QLineEdit *albumcmd;
     QComboBox *CDcombo;
     KStatusBar *statusbar;
     KPopupMenu *popup_menu;
     KConfig *config;
     void fillCDDropDown(void);
     void buildCDList(void);
     QList<CDList> *cdlist;
};


#endif



































































