/***************************************************************************
                          adddlg.h  -  description                              
                             -------------------                                         
    begin                : Mon May 31 1999                                           
    copyright            : (C) 1999 by Edwin Schepers                         
    email                : zeus@castel.nl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef __ADDDLG_H__
#define __ADDDLG_H__

#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <qstring.h>
#include <qlabel.h>
#include <qgrpbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qdialog.h>

#include "general.h"
#include "fnameinfodlg.h"

#define	CD	1
#define	HD	2

class NameCDDlg : public QDialog {
    Q_OBJECT
  public:
    NameCDDlg(QWidget *parent, const char *name = 0);
    NameCDDlg::~NameCDDlg(void);
    const char *getCDname();

  private:
    QLineEdit *cdname;

};

class AddDlg : public QDialog
{
    Q_OBJECT

 public:
  AddDlg( QWidget *parent = 0, const char *name=0);
  ~AddDlg(void);

  QRadioButton *chkboxIsCD;
  QRadioButton *chkboxIsHD;
  QCheckBox  *chkboxInfoFromFname;
  QLineEdit  *startpathcmd;
  QCheckBox  *chkboxReread;
  QCheckBox  *chkboxRecursive;
  QPushButton *set;
  QPushButton *dirbrowse;
  QString CDName;

 private:
   QPushButton *ok, *cancel;
   int searchMP3(char *path, bool recursive);
   int findTAG(FILE *fileptr);
   void del_trail_spc(char *name);
   int checkFilename(char *fname);
   int saveToDatabase(char *filename, char *Artist, char *Title, char *Album, char *Year);
   int medium;
   NameCDDlg *CDNameDlg;
   void deleteHDentries(char *path, bool recursive);
   char separator[10];
   bool forceFname;
   int AlbumPos;
   int ArtistPos;
   FnameInfoDlg *fnameinfodlg;

 public slots:
  void start_search(void);
  void setMatchProperties(void);
  void dirBrowse(void);
};


#endif

























































