    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "kbuttonbox.h"
#include "guiinstmap.h"
#include "qframe.h"
#include "qbitmap.h"
#include "kiconloader.h"
#include "qpaintdevice.h"
#include "guiinstdlg.h"
#include <kapp.h>
#include "sequenceutils.h"

Gui_INSTRUMENT_MAPPER::Gui_INSTRUMENT_MAPPER()
{
	printf("constructor\n");
	ParentWidget = 0;
	listview = 0;
	proxy = new GuiInstrumentMapperProxy(this);
}

Gui_INSTRUMENT_MAPPER::~Gui_INSTRUMENT_MAPPER()
{
	if(listview) delete listview;
	delete proxy;
}

void Gui_INSTRUMENT_MAPPER::widgetDestroyed(QWidget *widget)
{
	assert(widget == listview);
	listview = 0;
}

void Gui_INSTRUMENT_MAPPER::publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker)
{
	Arts::ModuleInfo info;

	info.name = CORBA::string_dup("Gui_INSTRUMENT_MAPPER");
	info.isInterface = false;
	info.isStructure = false;

	addPort(info,"parent",Arts::input,Arts::audio_data,Arts::stream);

	Broker->publishModule(Server, info);
}

void *Gui_INSTRUMENT_MAPPER::Creator()
{
	Gui_INSTRUMENT_MAPPER *result = new Gui_INSTRUMENT_MAPPER;
	return (GuiModule *)result;
}

ModuleClient MC_Gui_INSTRUMENT_MAPPER(GuiModule::get_MS,"Gui_INSTRUMENT_MAPPER",Gui_INSTRUMENT_MAPPER::Creator);

void Gui_INSTRUMENT_MAPPER::applyParameters(Arts::ModuleDesc *desc)
{
	KIconLoader iconloader;

	if(!listview)
	{
		listview = new QListView;
	}
	setupParent(desc,"parent");
}

void Gui_INSTRUMENT_MAPPER::setParent(QWidget *parent, QBoxLayout *layout)
{
/************************************************************************
 * I am still not sure wether this kind of putting yourself into a parent
 * widget (with own layout etc.) is a good idea (there may not even be
 * a singe call to setParent, because there is no parent).
 *
 * But the "how to write aRts widgets"-stuff will need some experiments,
 * so lets try that method...
 ************************************************************************/

	QVBoxLayout *mainlayout = new QVBoxLayout(parent);
	/*QHBoxLayout *contentslayout = new QHBoxLayout;*/

// list

	listview->recreate(parent,0,QPoint(0,0));

	listview->addColumn(i18n("Channel"),70);
	listview->addColumn(i18n("Instrument"),155);
	listview->addColumn(i18n("Destination"),75);

	listview->setMinimumSize(300,100);

	watchWidget(listview);

	mainlayout->addWidget(listview);
// hruler

	mainlayout->addSpacing(5);
	QFrame *ruler2 = new QFrame(parent);
	ruler2->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	ruler2->setMinimumSize(50,2);
	mainlayout->addWidget(ruler2);

// buttons

	QHBoxLayout *buttonlayout = new QHBoxLayout;
	mainlayout->addSpacing(5);
	mainlayout->addLayout(buttonlayout);
	mainlayout->addSpacing(5);

	buttonlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(parent);

	bbox->addStretch(1);
	QButton *add = bbox->addButton(i18n("Add"));
	QObject::connect(add,SIGNAL( clicked() ), proxy, SLOT( add() ));

/*
	QButton *edit = bbox->addButton(i18n("Edit"));
	QObject::connect(edit,SIGNAL( clicked() ), proxy, SLOT( edit() ));
*/

	QButton *remove = bbox->addButton(i18n("Remove"));
	QObject::connect(remove,SIGNAL( clicked() ), proxy, SLOT( remove() ));

/*
	QButton *cancelbutton = bbox->addButton(i18n("Cancel"));
	connect( cancelbutton, SIGNAL( clicked() ), SLOT(reject() ) );
*/
	bbox->layout();
	//min_size(bbox);

	buttonlayout->addWidget(bbox);
	buttonlayout->addSpacing(5);

	mainlayout->activate();
	//mainlayout->freeze();
	ParentWidget = parent;
}

void Gui_INSTRUMENT_MAPPER::finalize()
{
}

void Gui_INSTRUMENT_MAPPER::start()
{
	//Widget->show();
}

void Gui_INSTRUMENT_MAPPER::add()
{
	if(listview)
	{
		GuiInstDlg *gd = new GuiInstDlg(ParentWidget,Synthesizer);
		if(gd->exec())
		{
			(void)gd->create(listview);
		}
		delete gd;
	}

	//
}

void Gui_INSTRUMENT_MAPPER::edit()
{
	//
}

void Gui_INSTRUMENT_MAPPER::remove()
{
	if(listview)
	{
		InstListViewItem *current = (InstListViewItem *)listview->currentItem();
		if(current)
			delete current;
	}
}

Arts::StringSeq *Gui_INSTRUMENT_MAPPER::saveSessionParameters(list<long>& IDs)
{
	Arts::StringSeq *result = new Arts::StringSeq;
	if(!listview) return result;

    InstListViewItem *instrument = (InstListViewItem *)listview->firstChild();
	while( instrument )
	{
		Arts::StringSeq *saveinst = instrument->saveSessionParameters(IDs);

		sqprintf(result,"instrument");
		addSubStringSeq(result,saveinst);
		instrument = (InstListViewItem *)instrument->nextSibling();
	}
	return result;
}

void Gui_INSTRUMENT_MAPPER::restoreSessionParameters(const Arts::StringSeq&
																		params)
{
	Arts::ModuleBroker_var mbroker=Synthesizer->moduleBroker();
	unsigned long i;

   	char *cmd,*param;
   	for(i=0;i<params.length();i++)
   	{
   		if(parse_line(params[i],cmd,param))   // otherwise: empty or comment
   		{
   			if(strcmp(cmd,"instrument") == 0) {
				if(listview)
				{
					Arts::StringSeq_var instdata = getSubStringSeq(&params,i);

					(void)new InstListViewItem(Synthesizer,mbroker,listview,
						*instdata,restoreID);
				}
			}
		}
   	}
}


GuiInstrumentMapperProxy::GuiInstrumentMapperProxy(Gui_INSTRUMENT_MAPPER *gim)
{
	this->gim = gim;
}

void GuiInstrumentMapperProxy::add()
{
	gim->add();
}

void GuiInstrumentMapperProxy::edit()
{
	gim->edit();
}

void GuiInstrumentMapperProxy::remove()
{
	gim->remove();
}
