    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "sequenceutils.h"
#include <stdarg.h>

void sqprintf(Arts::StringSeq *list, const char *fmt, ...)
{
	char p[1024];
	va_list ap;
	va_start(ap, fmt);
	(void) vsnprintf(p, 1024, fmt, ap);
	va_end(ap);

	unsigned long len = list->length();
	list->length(len+1);
	(*list)[len] = CORBA::string_dup(p);
}

int parse_line(const char *in, char *& cmd, char *& param)
{
	int i,cmdlen=0,paramlen=0;
	static char static_cmd[1000], static_param[1000];

	cmd = static_cmd;
	param = static_param;
	i = 0;

	while(in[i] == ' ' || in[i] == '\t') i++;

	if(in[i] == 0) return(0);

	while(in[i] != '=' && in[i] != 0) cmd[cmdlen++] = in[i++];
	if(in[i] != 0) i++;
	while(in[i] != 0) param[paramlen++] = in[i++];

	cmd[cmdlen] = 0;
	param[paramlen] = 0;

	if(paramlen) return(2);
	if(cmdlen) return(1);
	return(0);
}

void addSubStringSeq(Arts::StringSeq *target, Arts::StringSeq *source)
{
	unsigned long i;

	sqprintf(target,"{");
	for(i=0;i<source->length();i++)
	{
		unsigned long len = target->length();
		target->length(len+1);
		string srcstring = string("  ") + string((*source)[i]);
		(*target)[len] = CORBA::string_dup(srcstring.c_str());
	}
	sqprintf(target,"}");
}

void appendStringSeq(Arts::StringSeq *target, Arts::StringSeq *source)
{
	unsigned long i;

	for(i=0;i<source->length();i++)
	{
		unsigned long len = target->length();
		target->length(len+1);
		(*target)[len] = CORBA::string_dup((*source)[i]);
	}
}

Arts::StringSeq *getSubStringSeq(const Arts::StringSeq *seq,unsigned long& i)
{
	Arts::StringSeq *result = new Arts::StringSeq;
	char *cmd = "",*param;


	while(strcmp(cmd,"{") && i<seq->length())
		parse_line((*seq)[i++],cmd,param);

	int brackets = 1;
	
	while(i<seq->length())
	{
		parse_line((*seq)[i],cmd,param);
		if(strcmp(cmd,"{") == 0) brackets++;
		if(strcmp(cmd,"}") == 0) brackets--;
		if(brackets == 0) return(result);

		unsigned long len = result->length();
		result->length(len+1);
		(*result)[len] = CORBA::string_dup((*seq)[i]);
		i++;
	}
	return(result);
}
