/***************************************************************************
                          dirview.cpp  -  description
                             -------------------
    begin                : Mon Feb 21 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavski
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/****************************************************************************
** $Id: dirview.cpp,v 1.9 1998/06/16 11:39:32 warwick Exp $
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
#include "quanta.h"
#include "resource.h"

#include "dirview.h"
#include <qdir.h>
#include <kdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qpixmap.h>
#include <qheader.h>

#include "pics/folder.xpm"
#include "pics/folder_open.xpm"
#include "pics/folder_locked.xpm"
#include "pics/html.xpm"
#include "pics/image.xpm"
// #include "pics/txt.xpm"

Directory::Directory( Directory * parent, const char * filename )
    : QListViewItem( parent ), f(filename )
{
    p = parent;
    dir = filename;
    readable = true;
    opened = false;
}


Directory::Directory( QListView * parent, const char * name, const char *_dir )
    : QListViewItem( parent ), f(name), dir(_dir)
{
    p = 0;
    readable = true;
}


void Directory::setOpen( bool o )
{
  QListViewItem *item;
  /** html filter*/
  QString htmlFilter = HTML_MASK;
	/** text filter*/
	QString textFilter = TEXT_MASK;
	/** image filter*/
	QString imageFilter = IMAGE_MASK;
	/** bacup filter*/
	QString backupFilter = BACKUP_MASK;

  QString s( fullName() );
	QDir thisDir( s );
	QStrList dirList;

  if ( !thisDir.isReadable() ) {
	  readable = false;
	  setPixmap( 0, QPixmap((const char**)folder_locked_xpm) );
	  setExpandable( false );
	  return;
	}

  if ( o && !childCount() )
  {
		thisDir.setSorting( QDir::Name);
		thisDir.setFilter ( QDir::Dirs);
		
		dirList = *( thisDir.entryList() );
		
		if (!thisDir.exists()) {
			return;
		}
		
		dirList.first();
		dirList.remove();
		dirList.remove();
		dirList.last();
		
		QStrList fileList;
		thisDir.setFilter( QDir::Files);
		fileList = *( thisDir.entryList() );
		
		fileList.last();
		
		while ( fileList.current()) {
		  QString name = fileList.current();

			if ( KDir::match( imageFilter, name) ) {
				item = new QListViewItem( this, name );
				item->setPixmap( 0, QPixmap((const char**)image_xpm) );
			}
			
			fileList.prev();
		}
		
		fileList.last();
/*		
		while ( fileList.current()) {
		  QString name = fileList.current();
		
		  if ( KDir::match( textFilter, name) ) {
				item = new QListViewItem( this, name );
				item->setPixmap( 0, QPixmap((const char**)txt_xpm) );
			}
			
			fileList.prev();
		}
		
		fileList.last();
*/		
		while ( fileList.current()) {
		  QString name = fileList.current();
		
		  if ( KDir::match( htmlFilter, name)) {
				item = new QListViewItem( this, name );
				item->setPixmap( 0, QPixmap((const char**)html_xpm) );
			}
			
			fileList.prev();
		}

		while( dirList.current()) {
			Directory *ditem = new Directory( this, dirList.current() );
			ditem->setPixmap( 0, QPixmap((const char**)folder_xpm) );
			ditem->setOpen(false);
			
			dirList.prev();
		}
  }
  QListViewItem::setOpen( o );
  if (p) {
  	if (o)
  		setPixmap( 0, QPixmap((const char**)folder_open_xpm) );
  	else
  		setPixmap( 0, QPixmap((const char**)folder_xpm) );
  }
  opened = o;
}


void Directory::setup()
{
    setExpandable( TRUE );
    QListViewItem::setup();
}


QString Directory::fullName()
{
	QString s;
  if ( p ) {
		s = p->fullName();
		s.append( f.name() );
		s.append( "/" );
  } else {
		s = dir;
  }
  return s;
}


const char * Directory::text( int column ) const
{
  if ( column == 0 )
		return f.name();
  else if ( readable )
		return "Directory";
  else
		return "Unreadable Directory";
}
