/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "srcedit.h"
#include "srcedit.moc"

const char *appName = "\" VisKProg \" source editor";
const char *appLabel = "VK SourceEdit - ";

KSrcEdit::KSrcEdit( const char *openFileName )
	: KTopLevelWidget()
{

	createMenuBar();
	createToolBar();
	createStatusBar();

	hlman = new HlManager();
	doc = new KWriteDoc( hlman ); //, path ???
	view = new KWrite( doc, this );

	view->setHl(1);

	setView( view, false ); // FALSE ???
	view->show(); // ???

	setCaption( QString(appLabel) + "[Unnamed]" );


	if ( openFileName != 0L )
		open( QString(openFileName) );


} //constructor


KSrcEdit::~KSrcEdit()
{
	delete fileMenu;
	delete editMenu;
	delete helpMenu;

} //destructor

void KSrcEdit::open( const char *s )
{
	if( !view->loadFile( s ) )
		KMsgBox::message( 0L, "Error",
			QString("Can't open file \"") +s +("\".") );

	view->setFileName(s);
}

void KSrcEdit::createMenuBar()
{
	//File menu
	fileMenu = new QPopupMenu;

	fileMenu->insertItem( "&New", IDC_FILE_NEW );
	fileMenu->setAccel( CTRL + Key_N, IDC_FILE_NEW );

	fileMenu->insertItem( "&Open ...", IDC_FILE_OPEN );
	fileMenu->setAccel( CTRL + Key_O, IDC_FILE_OPEN );

	fileMenu->insertItem( "&Save", IDC_FILE_SAVE );
	fileMenu->setAccel( CTRL + Key_S, IDC_FILE_SAVE );

	fileMenu->insertItem( "Save &as ...", IDC_FILE_SAVE_AS );

	fileMenu->insertItem( "New &View", IDC_FILE_NEW_VIEW );

	fileMenu->insertSeparator();

	fileMenu->insertItem( "&Print ...", IDC_FILE_PRINT );
	fileMenu->setAccel( CTRL + Key_P, IDC_FILE_PRINT );

	fileMenu->insertSeparator();

	fileMenu->insertItem( "&Quit", IDC_QUIT );
	fileMenu->setAccel( CTRL + Key_Q, IDC_QUIT );
    

	//Edit menu
	editMenu = new QPopupMenu;

	editMenu->insertItem( "&Undo", IDC_EDIT_UNDO );
	editMenu->setAccel( CTRL + Key_Z, IDC_EDIT_UNDO );

	editMenu->insertItem( "&Redo", IDC_EDIT_REDO );
	editMenu->setAccel( CTRL + Key_R, IDC_EDIT_REDO );

	editMenu->insertSeparator();

	editMenu->insertItem( "Cu&t", IDC_EDIT_CUT );
	editMenu->setAccel( CTRL + Key_X, IDC_EDIT_CUT );

	editMenu->insertItem( "&Copy", IDC_EDIT_COPY );
	editMenu->setAccel( CTRL + Key_C, IDC_EDIT_COPY );

	editMenu->insertItem( "&Paste", IDC_EDIT_PASTE );
	editMenu->setAccel( CTRL + Key_V, IDC_EDIT_PASTE );

	editMenu->insertSeparator();

	editMenu->insertItem( "R&eload *.vkc file", IDC_EDIT_RELOADVKC );


	//Help menu
	helpMenu = new QPopupMenu;

	helpMenu->insertItem( "&Contents", IDC_HELP );
	helpMenu->setAccel( Key_F1, IDC_HELP );

	helpMenu->insertSeparator();
	helpMenu->insertItem( "&About...", IDC_ABOUT );

	//Menu bar
	mainMenu = new KMenuBar( this, "mainMenu" );

	mainMenu->insertItem( "&File", fileMenu );
	mainMenu->insertItem( "&Edit", editMenu );
	mainMenu->insertSeparator();
	mainMenu->insertItem( "&Help", helpMenu );

	setMenu( mainMenu );

	//Connect
	connect( mainMenu, SIGNAL( activated( int ) ), this, 
		SLOT( dispatchCommand( int ) ) );

} //createMenuBar()


void KSrcEdit::createToolBar()
{
KIconLoader icon;

/* Icon names:

	"filenew2.xpm"
	"fileopen.xpm"
	"filefloppy.xpm"
	"editcopy.xpm"
	"editpaste.xpm"
	"editcut.xpm"
	"fileprint.xpm"
*/

	//Toolbar Initialization

	//Main toolbar
	mainToolbar = new KToolBar( this );

	mainToolbar->insertButton( icon.loadIcon( "filenew.xpm" ),
		IDC_FILE_NEW, TRUE, "New file" ); 

	mainToolbar->insertButton( icon.loadIcon( "fileopen.xpm" ),
		IDC_FILE_OPEN, TRUE, "Open file" ); 

	mainToolbar->insertButton( icon.loadIcon( "filefloppy.xpm" ),
		IDC_FILE_SAVE, TRUE, "Save file" ); 

	mainToolbar->insertSeparator();


	mainToolbar->insertButton( icon.loadIcon( "editcopy.xpm" ),
		IDC_EDIT_COPY, TRUE,
		"Copy selection to clipboard" ); 

	mainToolbar->insertButton( icon.loadIcon( "editcut.xpm" ),
		IDC_EDIT_CUT, TRUE, "Cut selection to clipboard" );


	mainToolbar->insertButton( icon.loadIcon( "editpaste.xpm" ),
		IDC_EDIT_PASTE, TRUE, "Paste text from the clipboard" );

	mainToolbar->insertSeparator();


	mainToolbar->insertButton( icon.loadIcon( "fileprint.xpm" ),
		IDC_FILE_PRINT, TRUE, "Print file" ); 

	mainToolbar->insertSeparator();

	//Connect toolbar:
	connect( mainToolbar, SIGNAL( clicked( int ) ), this,
		SLOT( dispatchCommand( int ) ) );

	addToolBar( mainToolbar );

} //createToolBar()


void KSrcEdit::dispatchCommand( int id )
{
	switch( id )
	{
		case IDC_QUIT:
			fileQuit();
			break;

		case IDC_ABOUT:
			about();
			break;

		case IDC_HELP:
			//...
			break;

		case IDC_FILE_NEW:
			view->newDoc();
			break;

		case IDC_FILE_OPEN:
			view->open();
			break;

		case IDC_FILE_NEW_VIEW:
			view->newDoc();
			break;

		case IDC_FILE_SAVE:
			view->save();
			break;

		case IDC_FILE_SAVE_AS:
			view->saveAs();
			break;

		case IDC_FILE_PRINT:
			filePrint();
			break;

		case IDC_EDIT_UNDO:
			view->undo();
			break;

		case IDC_EDIT_REDO:
			view->redo();
			break;

		case IDC_EDIT_CUT:
			view->cut();
			break;

		case IDC_EDIT_COPY:
			view->copy();
			break;

		case IDC_EDIT_PASTE:
			view->paste();
			break;

		case IDC_EDIT_RELOADVKC:
			editReloadVkc();
			break;

	} //switch(id)

} //dispatchCommand(...)


void KSrcEdit::createStatusBar()
{
	//Status Bar Initialization:

	statusBar = new KStatusBar( this );
	statusBar->insertItem( "Line:000000 Col: 000", ID_LINECOL );
	statusBar->insertItem( "XXX", ID_CAPSLOCK );
	statusBar->insertItem( "XXX", ID_INSMODE );
	statusBar->insertItem( "", ID_CONTEXT_UI );

	statusBar->changeItem( "INS", ID_INSMODE );

	statusBar->setInsertOrder( KStatusBar::RightToLeft );
	statusBar->setAlignment( ID_CAPSLOCK, AlignCenter );
	statusBar->setAlignment( ID_INSMODE, AlignCenter );

	setStatusBar( statusBar );
	statusBar->show();

} //create statusBar()


void KSrcEdit::fileNewView()
{
}


void KSrcEdit::fileQuit()
{
	KApplication::getKApplication()->quit();

} //fileQuit()


void KSrcEdit::filePrint()
{
	// Print file (...)

	warning( "Print file: Not implemented, yet" );
}

void KSrcEdit::editReloadVkc()
{
/*char *vkcText;

	vkcd = new vkcDialog( "win.vkc" );

	if( vkcd->result() == vkcDialog::Accepted )
	{
		QFile vkc( vkcd->text() );

		if( !vkc.open( IO_ReadOnly ) )
		{
			KMsgBox::message( 0, "Can't read", "Couldn't read this file.\nAre you sure, that it exists?" );
			return;
		}

		vkcText = new( char[vkc.size()+1] );

		vkc.readBlock( vkcText, vkc.size() );

		vkcText[vkc.size()] = 0L;

		vkc.close();

		doc->setVkcInfo( vkcText );
	}

	delete vkcd;*/
}

void KSrcEdit::about()
{
	QString mb;
	mb = QString("      The \"VisKProg\" source editor\n")
		+("====================================\n")
		+("     VisKProg (c) 1999 Christoph Pinkel\n")
		+("             <de_cp@yahoo.com>   \n\n")
		+("This is just a modificated version of\n")
		+("KDevelop's \"KWrite\", (c) Jochen Wilhelmy");

	KMsgBox::message( 0, appName, mb );
}
