#ifndef __WORM_H_INCLUDED__
#define __WORM_H_INCLUDED__

#include <qlist.h>
#include <qpoint.h>
#include <qobject.h>
#include <qpainter.h>
#include <qqueue.h>

#include "wormpoint.h"

typedef QList<WPoint> CPointList;
typedef QListIterator<WPoint> CPointListIterator;

// Constants: global CWorm
#define WormUp 1
#define WormRight 2
#define WormDown 3
#define WormLeft 4
#define DirUndef 5
#define DirTeleport 6

class CWormPlayground;

class CWorm : public QObject
{
 Q_OBJECT

 // Data
 public:
	CWorm(CWormPlayground* pg);
	virtual ~CWorm();
	CWormPlayground* playground() { return _playground; }
	WPoint head() { return _head; }
	void setHead(WPoint h) { _head = h; }
	WPoint tail() { return _tail; }
	char dir() { return _head._dir; }
	WPoint* covers(QPoint field); // returns point BEFORE which field is
	bool isActive(); 
	bool isTeleporting() { if(head() == *_points->getLast()) 
		ASSERT(_points->getLast()->d() == DirTeleport);
        	return head() == *_points->getLast(); }

 protected:
	CPointList* _points;
	WPoint _head;
	WPoint _tail;
	CWormPlayground* _playground;
       	int _length;
	int _reqLength;

 // Implementation
 signals:
	void sigAccessField(int,int); // Must be emitted BEFORE _head is changed
	void sigUpdate(const QRect&);
	void sigSpecialUpdate(QRect);

 public slots:
	void slotStart();
	void slotNewDir(char d);
        void slotDie(char reason);
	void slotTimer(long c);
	void slotEatBall(char s);

 public:
	void draw(QPainter* pt);
	void drawAt(QPoint field,QPaintDevice* dst,QPoint dstPoint);
	void newPoint(WPoint pt) { _points->append(new WPoint(pt)); }
	void newPoint(QPoint pt,char d) { _points->append(new WPoint(pt,d)); }

 protected:
	void redrawHead(QPoint prevHead);
	void redrawTail(QPoint prevTail);
	QPoint LPtoDP(QPoint pt);
	QRect LPtoDP(QRect rct);
	QPoint DPtoLP(QPoint pt);
	QRect DPtoLP(QRect rct);
	void addDir(char dir);
	void getDir();
	void shorten();

 private:
	QQueue<char> *_dirList;
	char _lastDir; // Last directory enqueued

};

#endif // !__WORM_H_INCLUDED__
