#include "options.h"
#include <qpushbutton.h>
#include <qvalidator.h>
#include <kapp.h>
#include <qbuttongroup.h>
#include <qdir.h>

OptionsDialog::OptionsDialog(BoardOptionsStruct *o, QWidget *parent, const char *name)
	: QDialog(parent,name,true)
{
	QButtonGroup	*geom = new QButtonGroup(i18n("Game options"),this);
	QButtonGroup	*back = new QButtonGroup(i18n("Background options"),this);

	QLabel	*Player1Label = new QLabel(i18n("Player 1"),this);
	QLabel	*Player2Label = new QLabel(i18n("Player 2"),this);
	QLabel	*LevelLabel = new QLabel(i18n("Level"),this);
	QLabel	*ColsLabel = new QLabel(i18n("Columns"),this);
	QLabel	*RowsLabel = new QLabel(i18n("Rows"),this);
	QLabel	*PuisLabel = new QLabel(i18n("Puissance"),this);

	Player1 = new QComboBox(this);
	Player1->insertItem(i18n("Human"));
	Player1->insertItem(i18n("Computer"));

	Player2 = new QComboBox(this);
	Player2->insertItem(i18n("Human"));
	Player2->insertItem(i18n("Computer"));

	Level = new QComboBox(this);
	Level->insertItem(i18n("Easy"));
	Level->insertItem(i18n("Medium"));
	Level->insertItem(i18n("Hard"));

	NumCols = new QLineEdit(this);
	NumRows = new QLineEdit(this);
	NumPuis = new QLineEdit(this);
	QIntValidator	*validator = new QIntValidator(this);
	validator->setRange(1,20);
	NumCols->setValidator(validator);
	NumRows->setValidator(validator);
	NumPuis->setValidator(validator);

	QPushButton	*ok = new QPushButton(i18n("Ok"),this);
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	ok->setDefault(true);
	QPushButton	*cancel = new QPushButton(i18n("Cancel"),this);
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));

	QLabel	*ColorLabel = new QLabel(i18n("Background color"),this);
	BackgroundColor = new KColorButton(this);
	UsePixmap = new QCheckBox(i18n("Use background pixmap"),this);
	Pixmap = new QComboBox(this);
	connect(Pixmap,SIGNAL(activated(int)),SLOT(pixmapChanged(int)));
	PixmapPreview = new QLabel(this);

	// Geometry settings
	geom->setGeometry(5,5,310,200);
	back->setGeometry(5,215,310,100);
	Player1Label->setGeometry(15,20,150,25);
	Player1->setGeometry(15,45,150,25);
	Player2Label->setGeometry(15,80,150,25);
	Player2->setGeometry(15,105,150,25);
	LevelLabel->setGeometry(15,140,150,25);
	Level->setGeometry(15,165,150,25);
	ColsLabel->setGeometry(195,20,100,25);
	NumCols->setGeometry(195,45,100,25);
	RowsLabel->setGeometry(195,80,100,25);
	NumRows->setGeometry(195,105,100,25);
	PuisLabel->setGeometry(195,140,100,25);
	NumPuis->setGeometry(195,165,100,25);
	ok->setGeometry(140,320,80,30);
	cancel->setGeometry(235,320,80,30);
	UsePixmap->setGeometry(15,230,160,25);
	ColorLabel->setGeometry(15,255,100,25);
	BackgroundColor->setGeometry(15,280,50,25);
	Pixmap->setGeometry(180,230,125,25);
	PixmapPreview->setGeometry(180,255,125,50);

	PixmapList.setAutoDelete(true);

	resize(320,355);
	setMinimumSize(320,355);
	setMaximumSize(320,355);

	loadOptions(o);

	setCaption(i18n("Options"));
}

void OptionsDialog::loadOptions(BoardOptionsStruct *o)
{
	QDir	wallPaperDir(KApplication::kde_wallpaperdir().data());
	QFileInfoList	*list = wallPaperDir.entryInfoList("*.jpg",QDir::Files,QDir::Name);
	QFileInfoListIterator	it(*list);
	for (;it.current();++it) {
		Pixmap->insertItem(it.current()->fileName().data());
		PixmapList.append(it.current()->fileName().data());
	}

	Player1->setCurrentItem((o->Player1 == 0 ? 1 : 0));
	Player2->setCurrentItem((o->Player2 == 0 ? 1 : 0));
	Level->setCurrentItem(o->Level);
	QString		txt;
	txt.sprintf("%d",o->NumCols);
	NumCols->setText(txt.data());
	txt.sprintf("%d",o->NumRows);
	NumRows->setText(txt.data());
	txt.sprintf("%d",o->NumPuis);
	NumPuis->setText(txt.data());
	UsePixmap->setChecked(o->UseBackgroundPixmap);
	BackgroundColor->setColor(o->BackgroundColor);
	QString		pixmap = o->BackgroundPixmap.right(o->BackgroundPixmap.length()-o->BackgroundPixmap.findRev('/')-1);
	int		index = PixmapList.find(pixmap.data());
	Pixmap->setCurrentItem(index);
	pixmapChanged(index);
}

void OptionsDialog::readOptions(BoardOptionsStruct *o)
{
	o->Player1 = (Player1->currentItem() == 0 ? 1 : 0);
	o->Player2 = (Player2->currentItem() == 0 ? 2 : 0);
	o->Level = Level->currentItem();
	QString		num;
	num = NumCols->text();
	o->NumCols = num.toInt();
	num = NumRows->text();
	o->NumRows = num.toInt();
	num = NumPuis->text();
	o->NumPuis = num.toInt();
	o->UseBackgroundPixmap = UsePixmap->isChecked();
	o->BackgroundColor = BackgroundColor->color();
	o->BackgroundPixmap = KApplication::kde_wallpaperdir() + "/" + Pixmap->currentText();
}

void OptionsDialog::pixmapChanged(int item)
{
	QString		fileName = KApplication::kde_wallpaperdir() + "/" + PixmapList.at(item);
	QPixmap		pix(fileName.data());
	PixmapPreview->setPixmap(pix);
}
