#ifndef _BOARD_H_
#define _BOARD_H_

#include <qwidget.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qevent.h>
#include <qtimer.h>
#include "intpuis.h"
#include "casewidget.h"

#define	Event_NextTurn		1001
class NextTurnEvent : public QEvent
{
public:
	NextTurnEvent() : QEvent(Event_NextTurn) {}
};

struct BoardOptionsStruct;

class BoardWidget : public QWidget
{
	Q_OBJECT;

public:
	BoardWidget(BoardOptionsStruct *o, QWidget *parent, const char *name = 0);
	~BoardWidget();

	void save(const char *filename);
	void load(const char *filename);
	void restart();
	void undo();
	void hint();

signals:
	void message(const char *text);

protected:
	BoardOptionsStruct	*BoardOptions;
	QButtonGroup		*ButtonGroup;
	InternalPuissance	*Table;
	QPushButton		*Buttons[20];
	CaseWidget		*Cases;
	QPixmap			Pix[4];
	int			CurrentPlayer;	// 0 -> Player1, 1 ->Player2
	int			Players[2];
	int			Total;
	bool			Busy;
	QArray<int>		Winner;
	QTimer			WinTimer;

protected:
	void resizeEvent(QResizeEvent *e);
	void dropInColumn(int col, int maxInd, int state);
	void nextTurn();
	bool eventFilter(QObject *o, QEvent *e);
	void initDisplay();
	void clearDisplay();
	void reloadIcons(int size);

protected slots:
	void columnPressed(int);
	void slotTimer();
};

#endif
