#include <kpacman.h>
#include <kpacman.moc>

#include <qkeycode.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpopmenu.h>
#include <qmsgbox.h>

#include <kcolordlg.h>

KPacman::KPacman(QWidget *, const char *name)
	: KTopLevelWidget()
{
    setCaption("Pacman");
    setIcon("Pacman");

    conf = kapp->getConfig();
    if(conf == NULL) {
	printf(i18n("KConfig error ??\n"));
	kapp->quit();
    }

    menu();
 
    view = new KPacmanWidget(this, name, conf, conf->readNumEntry("Scheme", -1));

    setFixedSize(view->width(), view->height());

    view->referee->setFocus();

    connect(view->referee, SIGNAL(setScore(int, int)), view->score, SLOT(setScore(int, int)));
    connect(view->referee, SIGNAL(setPoints(int)), view->score, SLOT(set(int)));
    connect(view->referee, SIGNAL(setLifes(int)), view->status, SLOT(setLifes(int)));
    connect(view->referee, SIGNAL(setLevel(int)), view->status, SLOT(setLevel(int)));
    connect(view->referee, SIGNAL(forcedHallOfFame(bool)), this, SLOT(forcedHallOfFame(bool)));
    connect(view->referee, SIGNAL(togglePaused()), this, SLOT(togglePaused()));
    connect(view->referee, SIGNAL(toggleNew()), this, SLOT(toggleNew()));

    connect(view->score, SIGNAL(toggleNew()), this, SLOT(toggleNew()));
    connect(view->score, SIGNAL(forcedHallOfFame(bool)), this, SLOT(forcedHallOfFame(bool)));

    menuBar->show();
    setMenu(menuBar);
    view->show();
    setView(view);
}

KPacman::~KPacman()
{
    delete menuBar;
}

void KPacman::menu()
{

    game = new QPopupMenu();
    CHECK_PTR( game );
    newID = game->insertItem(i18n("&New"), this, SLOT(newKPacman()),Key_F2);
    pauseID = game->insertItem(i18n("&Pause"), this , SLOT(pauseKPacman()), Key_F3);
    hofID = game->insertItem(i18n("&Hall of fame"), this, SLOT(toggleHallOfFame()), Key_F4);
    game->insertSeparator();
    game->insertItem( i18n("&Quit"),  this, SLOT(quitKPacman()), CTRL+Key_Q );
    game->setCheckable( TRUE );

    options = new QPopupMenu();
    CHECK_PTR( options );

    if (lookupSchemes() > 0) {
	options->insertItem(i18n("&Select graphic scheme"),  schemes);
	options->insertSeparator();
    }

    options->insertItem(i18n("Change &keys..."), this, SLOT(confKeys()));

    options->setCheckable( TRUE );

    QString msg = i18n("@PACKAGE@ - @VERSION@\n\n"
		       "Joerg Thoennissen (joe@dsite.de)\n\n"
                       "A pacman game for the KDE Desktop\n\n"
		       "The program based on the source of ksnake\n"
		       "by Michel Filippi (mfilippi@sade.rhein-main.de).\n"
		       "The design was strongly influenced by the pacman\n"
		       "(c) 1980 MIDWAY MFG.CO.\n\n"
		       "I like to thank my girlfriend Elke Krueers for\n"
		       "the last 10 years of her friendship.\n");
    msg.replace(QRegExp("@PACKAGE@"), PACKAGE);
    msg.replace(QRegExp("@VERSION@"), VERSION);
    QPopupMenu *help = kapp->getHelpMenu(FALSE, msg);	

    menuBar = new KMenuBar( this );
    CHECK_PTR( menuBar );
    menuBar->insertItem(i18n("&Game"), game );
    menuBar->insertItem(i18n("&Options"), options );
    menuBar->insertSeparator();
    menuBar->insertItem(i18n("&Help"), help);
}


int KPacman::lookupSchemes()
{
    int SchemeCount = conf->readNumEntry("SchemeCount");
    int Scheme = conf->readNumEntry("Scheme", -1);

    if (SchemeCount == 0 || Scheme == -1) {
	QMessageBox::information(this, i18n("Configuration Error"),
				 i18n("There are no schemes defined,\n"
				 "or no scheme is selected."));
        return 0;
    }

    schemes = new QPopupMenu;
    schemes->setCheckable(TRUE);
    connect(schemes, SIGNAL(activated(int)), this, SLOT(schemeChecked(int)));
    schemeID.resize(SchemeCount);

    QString SchemeGroup;
    QString SchemeName;

    for (int i = 0; i < SchemeCount; i++) {
	SchemeGroup.sprintf("Scheme %d", i);
	
	KConfigGroupSaver *group = new KConfigGroupSaver(conf, SchemeGroup);
	SchemeName = conf->readEntry("Description");
	delete (group);

        schemeID[i] = schemes->insertItem(SchemeName);
    }
    schemes->setItemChecked(schemeID[Scheme], TRUE);

    return SchemeCount;
}

void KPacman::quitKPacman()
{
    kapp->quit();
}

void KPacman::newKPacman()
{
    if (!game->isItemEnabled(hofID))
        game->setItemEnabled(hofID, TRUE);

    if (game->isItemChecked(hofID))
        toggleHallOfFame();

    if (game->isItemChecked(pauseID))
        pauseKPacman();

    view->referee->play();
}

void KPacman::pauseKPacman()
{
    view->referee->pause();
    view->score->pause();
}

void KPacman::toggleHallOfFame()
{
    game->setItemChecked(hofID, !game->isItemChecked(hofID));
    view->referee->toggleHallOfFame();

    if (game->isItemChecked(hofID)) {
        view->referee->lower();
        view->status->lower();
    } else {
        view->status->raise();
        view->referee->raise();
        view->referee->setFocus();
    }
}

/*
 * Disable or enable the "Hall of fame"-menuitem if the referee says so.
 * This is done, to disable turning off the "hall of fame"-display, in the automated sequence of
 * displaying the introduction, the demonstration (or playing) and the hall of fame.
 * If on == TRUE then also lower the referee and the status widgets.
 */
void KPacman::forcedHallOfFame(bool on)
{
    if (!on && !game->isItemChecked(hofID))
        return;

    game->setItemEnabled(hofID, !on);
    game->setItemChecked(hofID, on);

    view->referee->toggleHallOfFame();
    if (on) {
        view->referee->lower();
        view->status->lower();
    } else {
        view->status->raise();
        view->referee->raise();
        view->referee->setFocus();
        view->referee->intro();
    }
}

void KPacman::togglePaused()
{
    static bool checked = FALSE;
    checked = !checked;
    game->setItemChecked( pauseID, checked );
}

/*
 * This disables the "New Game" menuitem to prevent interruptions of the current play.
 */
void KPacman::toggleNew()
{
    game->setItemEnabled(newID, !game->isItemEnabled(newID));
}

void KPacman::confKeys()
{
    Keys *keys = new Keys();
    if (keys->exec() == QDialog::Accepted)
	view->referee->initKeys();
	view->score->initKeys();
    delete keys;
}

void KPacman::schemeChecked(int id)
{
    for (uint i = 0; i < schemeID.size(); i++) {
    	schemes->setItemChecked( schemeID[i], schemeID[i] == id);
	if (schemeID[i] == id) {
	    conf->writeEntry("Scheme", i);
	    view->setScheme(conf, i);
	    show();
	}
    }
}
