/***************************************************************************
                          kmessage.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jul 27 1999                                           
    copyright            : (C) 1999 by pradu                         
    email                : pradu@geocities.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kmessage.h"
#include <qregexp.h>

const char * SEPARATOR = "|";

KMessage::KMessage()
{
}

KMessage::~KMessage()
{
}

/**
* builds a message based upon a
* string
*/
KMessage::KMessage(const char * buf)
{
	parseBuf(buf);
}


/** sets the type of  message */
void KMessage::setType(int _type)
{
	type = _type;
}


/** adds a field to the message */
void KMessage::addField(const char * name, const char * content)
{
//  char * buf = 0;
//  QString s = content;

//  s.replace(QRegExp(" "),"_");
//  buf = new char[s.length() + 1];
//  strcpy(buf,content);
//	cerr << name << " " << content << endl;
	fields.insert(name,new QString(content));
}

/** returns the type of the message */
int KMessage::getType()
{
	return type;
}

ostream& operator <<(ostream& o, KMessage *mes)
{
  ostrstream s;

	s << mes->type;
	QDictIterator<QString> iter(mes->fields);
	while (iter.current())
		{
			s << SEPARATOR << iter.currentKey() << SEPARATOR << *iter.current();
			++iter;
		}
	s << '\0';
	QString str(s.str());
	str.replace(QRegExp(" "),"_");
	o << str << endl;
	delete s.str();
	return o;
}

istream& operator >>(istream& i, KMessage *mes)
{
	char * buf = new char[255];

	//i.read(buf,255);
	
	i >> buf;

	mes->parseBuf(buf);	
	delete[] buf;

	return i;	
}

/**  */
void KMessage::parseBuf(const char * buf)
{
	QString s = "";
	QString name = "";
	QString * content = 0;
	char * pName = 0;
//	char * pContent = 0;
	int pos = 0;
  int cur = 0;
	int max;

	s = buf;
 	max = s.length();

	
	cur = s.find(SEPARATOR,pos);
//	cerr << "posizione del separatore :" << cur << endl;
	type = s.mid(pos,cur).toInt();
//	cerr << "mid: " << s.mid(pos,cur) << endl;
//	cerr << "Type: "  << type << endl;
	pos = cur;

//	cerr << "parsing buf: " << buf << endl;
	
	while (pos != -1)
		{
			pos++;
			cur = s.find(SEPARATOR,pos);
//			cerr << "cur: " << cur << endl;
			name = s.mid(pos,cur - pos);
//			cerr << "name: " << name << endl;
			pName = new char[s.length() + 1];
			strcpy(pName,(const char *)name);
			pos = cur + 1;
			cur = s.find(SEPARATOR,pos);
//			cerr << "cur: " << cur << endl;
      content = new QString;
			*content = (s.mid(pos,(cur==-1?max:cur) - pos));
			content->replace(QRegExp("_")," ");
//			cerr << "content: " << * content << endl;
//			pContent = new char[s.length() + 1];
//			strcpy(pContent,(const char *)content);
//			fields.insert(pNaame,pContent);       	
			
			fields.insert(pName,content);       	
			pos = cur;
		}
}

/** returns a field, null if the field does not exists */
const QString & KMessage::getField(const char * name) const
{
//	cerr << "buf: " << buf << " name: " << name << endl;
	return *fields[name];
}


/**  */
void KMessage::addField(const char * name, const QString & content)
{
	QString * s = new QString;
	*s = content;
	fields.insert(name,s);
}

/**  */
void KMessage::addField(const char * name, int content)
{
	QString s ;
	s.setNum(content);
	addField(name,s);	
}


/**  */
void KMessage::clear()
{
	type = 0;
	fields.clear();
}
