/***************************************************************************
                          cstartserver.cpp  -  description
                             -------------------
    begin                : Sun Dec 12 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>

#include "cstartserver.h"


CStartServer::CStartServer(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	initConnections();
	
	KConfig *conf = kapp->getConfig();
	txtFleetName->setText(conf->readEntry("fleetname"," "));
}

CStartServer::~CStartServer(){
}

/**  */
void CStartServer::slotOkClicked()
{
	KConfig *conf = kapp->getConfig();
	conf->writeEntry("fleetname",txtFleetName->text());	
	done(IDOK);
}
/**
 */
void CStartServer::slotCancelClicked()
{
	done(IDCANCEL);
}

/**  */
void CStartServer::initConnections()
{
  connect (cmdOk, SIGNAL (clicked ()), SLOT (slotOkClicked ()));
  connect (cmdCancel, SIGNAL (clicked ()), SLOT (slotCancelClicked ()));
}

/**  */
QString CStartServer::getFleetName() const
{
	return txtFleetName->text();
}
