/***************************************************************************
                       QueryDlg.h  -  dialog when in random query mode
                             -------------------
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef Query_Dlg_H
#define Query_Dlg_H

#include "QueryDlgData.h"

/* Library Includes */

#include <qdialog.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qlineedit.h>

class QueryDlg : public QueryDlgData
{
  Q_OBJECT

public:
	QueryDlg(QString org,
                 QString trans,
                 int entry,
                 int orgcol,
                 int transcol,
                 int query_cycle,
                 int query_num,
                 int query_startnum,
                 kvoctrainExpr *exp,
                 kvoctrainApp  *kv_app,
                 kvoctrainDoc  *,
                 int mtime,
                 QWidget *parent=0,
                 char *name=0);

	virtual void setQuery(QString org,
                      QString trans,
                      int entry,
                      int orgcol,
                      int transcol,
                      int query_cycle,
                      int query_num,
                      int query_startnum,
                      kvoctrainExpr *exp,
                      kvoctrainApp  *kv_app,
                      kvoctrainDoc  *,
                      int mtime);

public slots:
    virtual void initFocus() const;

protected:
        void keyPressEvent( QKeyEvent *e );

public slots:
        virtual void verifyClicked();
        virtual void showMoreClicked();
        virtual void showAllClicked();
        virtual void knowItClicked();
        virtual void dontKnowClicked();
        virtual void stopItClicked();
        virtual void optionsClicked();
        virtual void timeoutReached();
        virtual void editOrgClicked();
        virtual void editTransClicked();
        virtual void slotTransChanged(EA_QTSTR);

};

#endif
