/***************************************************************************
            LangPropPage.h  -  language properties dialog page
                         -------------------
    begin                : Wed Oct 13 18:37:13 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef LangPropPage_included
#define LangPropPage_included

#include "LangPropPageData.h"
#include "GrammerManager.h"

class kvoctrainDoc;

class LangPropPage : public LangPropPageData
{
    Q_OBJECT

public:

    LangPropPage
    (
        kvoctrainDoc      *doc,
        QString            curr_lang,
        const Conjugation &conjugations,
        const Article     &article,
        QWidget           *parent = NULL,
        const char        *name = NULL
    );

    Conjugation getConjugation();
    Article getArticle() const { return articles; }

    virtual ~LangPropPage();

protected:
    void keyPressEvent( QKeyEvent * );

public slots:
    virtual void initFocus() const;

protected slots:

    virtual void secondPluralChanged(EA_QTSTR );
    virtual void secondSingularChanged(EA_QTSTR );
    virtual void thirdNSingularChanged(EA_QTSTR );
    virtual void thirdFPluralChanged(EA_QTSTR );
    virtual void thirdMSingularChanged(EA_QTSTR );
    virtual void thirdFSingularChanged(EA_QTSTR );
    virtual void thirdMPluralChanged(EA_QTSTR );
    virtual void thirdNPluralChanged(EA_QTSTR );
    virtual void firstPluralChanged(EA_QTSTR );
    virtual void firstSingularChanged(EA_QTSTR );
    virtual void slotThirdSCommonToggled(bool);
    virtual void slotThirdPCommonToggled(bool);

    virtual void defNaturalChanged(EA_QTSTR );
    virtual void indefMaleChanged(EA_QTSTR );
    virtual void indefNaturalChanged(EA_QTSTR );
    virtual void defFemaleChanged(EA_QTSTR );
    virtual void indefFemaleChanged(EA_QTSTR );
    virtual void defMaleChanged(EA_QTSTR );

 protected:

   kvoctrainDoc *doc;
   Conjugation   conjugations;
   Article       articles;
};

#endif // LangPropPage_included
