/***************************************************************************
                          listedit.h  -  description
                             -------------------
    begin                : Fri Sep 24 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LISTEDIT_H
#define LISTEDIT_H

#include <qwidget.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qkeycode.h>
#include <qheader.h>
#include <qfont.h>
#include <qlist.h>

#define ToLeft  -1
#define ToRight  1


/**implements a editable listview
  *@author Friedrich W. H. Kossebau
  */

struct VFontEntry
{
  QFont *Font;  
};  

class ListEditItem;
  
class ListEdit : public QListView  {
   
  Q_OBJECT
  
  friend class ListEditItem;
  
  public: 
  	ListEdit(QWidget *parent=0, const char *name=0);
  	~ListEdit();
    /**  */
    virtual bool eventFilter( QObject * o, QEvent * e );
    /** */
    virtual void resize( int w, int h );
    /** clears list and resets all edit data */
    virtual void clear();
  
    /** returns the Editmode */
    const bool &isEditMode() { return EditMode; };
    /** sets the mode to or from Editing who would have guessed ;-) */
    void setEditMode( const bool Editing = true );
    /** sets the Edited Column */
    void setEditedColumn( const int NewColumn );
    /** returns edited column */
    const int editedColumn() { return EditedColumn; }
    /** returns last item else 0*/
    QListViewItem *lastItem();    
    
    /** returns the font of column Column */
    const QFont &columnFont( int Column );
    /** sets the font of column Column */
    void setColumnFont( int Column, const QFont & f );
    /** sets the standard font for all columns */
    virtual void setFont ( const QFont & f );
    /** */
    virtual int addColumn ( const char * label, int width = -1 );

  public slots:
    /** passes text to list */
    void setText( const char * );
    /** sets EditField to new position */
    void slotSortingChanged( int column );
    
  protected: // Protected methods
    /**  */
    virtual void mousePressEvent ( QMouseEvent *e );
    /** handles the pressing of Return,  Enter and Tab */
    virtual bool handleEnterPress( const QKeyEvent *k );
    /** finds the next editable column, direction is +1 or -1, returns FALSE if nothing found */
    bool changeColumn ( const int Direction, const int NewCursorPos = -1 );
    /** sets the EditField to the next line in the column Column */
  	bool goNextLine ( const int Direction = 1, const int NewCursorPos = -1, const int Column = 0 );
    /** sets the new cursor position */
    void setCursorPos( const int NewCursorPos = -1 );
    /** returns cursor position */
    const int cursorPos() {	return CursorPos; }
    /** creates the EditField */
    void initEditField();
    /** check if new font is higher than the one used */
    void checkFontMetricHeight( const QFont &Font );
  
  protected slots:
    /** sets the new coordinates */
    virtual void updateEditField();
  
  protected: // Protected attributes
  	/** the field for enabling direct editing in the list */
  	QLineEdit *EditField;
    /** needed for signaling of size changes */
    QHeader *Header;
  	/** the column in which is actually edited */
  	int EditedColumn;
    /** holds the information about the state of the list */
    bool EditMode;
    /** used to set the position of the cursor */
    int CursorPos;
    /** is set true if item is just changing to prevent sending of justModified */
    bool ItemIsChanging;
    /** */
    uint FontMetricsHeight;
    /** */
    QList<VFontEntry> FontList;

  
  signals: // Signals
    /** is emmited if any change was made to the list */
    void justModified();
};




/**special type of QListViewItem
that supports the editing facility of ListEdit
  *@author Friedrich W. H. Kossebau
  */

class ListEditItem : public QListViewItem  {
public: 
	ListEditItem( QListView * parent, const char * = 0, const char * = 0 );
	ListEditItem( QListView * parent, QListViewItem * after, const char * = 0, const char * = 0 );
	~ListEditItem();
  
  /** draws the text with individuell fonts*/
   void paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align );
  /** Performs setup. */
  void setup();
};


#endif
