/***************************************************************************
                          vtypedit.h  -  description
                             -------------------
    begin                : Thu Mar 23 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VTYPEDIT_H
#define VTYPEDIT_H

#include <qgroupbox.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qlabel.h>

#include <kbuttonbox.h>

#include "../vtyplist.h"

/**
  *@author Friedrich W. H. Kossebau
  */
  
class VTypListEdit : public QGroupBox  
{
   Q_OBJECT
   
  public: 
  	VTypListEdit( VTypInfoList *GivenList = 0, QWidget *parent=0, const char *name=0 );
  	~VTypListEdit();
    
    void setList( VTypInfoList *GivenList );
    virtual void setEnabled ( bool Enable );
  protected:
    void setLayout();
    void fillBox();
    
  protected slots:
    void refreshLocalName( const char *Text );
    void refreshSymbol( const char *Text );
    void createTyp();
    void deleteTyp();
    void selected( int Index );
    
  protected:
    QVBoxLayout Layout;
    QHBoxLayout TypLayout;
    QListBox TypListBox;
    
    QVBoxLayout LeftLayout;
    KButtonBox TypControl;
    QPushButton *New;
    QPushButton *Delete;    
    
    // edit
    QLineEdit NameEdit;
    QLabel NameLabel;
    QLineEdit LocalNameEdit;
    QLabel LocalNameLabel;
    QLineEdit SymbolEdit;
    QLabel SymbolLabel;
    
    VTypInfoList *List;
    VTypInfo *TypInfo;
};
  
#endif
