/***************************************************************************
                          languageedit.cpp  -  description
                             -------------------
    begin                : Tue Mar 21 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kpixmap.h>
#include <kfontdialog.h>
#include <kmsgbox.h>

#include "veditdialog.h"
#include "vlangdialog.h"

VLanguagesDialog::VLanguagesDialog(QWidget *parent, const char *name )
  : VDialog(parent,name),
    
    // the language select row    
    LanguageLayout(),
    LanguageControl( this ),
    LanguageBox( 0, this ),
    
    // the general block
    General( this ),
    GeneralLayout( &General, 10 ),
    NameEdit( &General ),
    NameLabel( &NameEdit, i18n("&Name"), &General ),
    ShortEdit( &General ),
    ShortLabel( &ShortEdit, i18n("&Short"), &General ),
    FontLayout(),
    FontSelect( &General ),
    FontEdit( &General ),
    FontLabel( &FontEdit, i18n("&Font"), &General ),
    
    TypListEdit( 0, this )
{
  setLayout();
  
  List = new VLanguageList( false );
  LanguageBox.fill( List );
  
  LanguageBox.setCurrentItem( 0 );
  selected( 0 );
  
  connect( &LanguageBox, SIGNAL(activated(int)), SLOT(selected(int)) );
  connect( &NameEdit, SIGNAL(textChanged(const char*)), SLOT(refreshBox(const char*)) );
  
  connect( &FontSelect, SIGNAL(clicked()), SLOT(selectFont()) );
  
  connect( New, SIGNAL(clicked()), SLOT(createLanguage()) );
  connect( Delete, SIGNAL(clicked()), SLOT(deleteLanguage()) );
}



VLanguagesDialog::~VLanguagesDialog()
{
}


/**  */
void VLanguagesDialog::edit()
{
  if( exec() )
  {
     List->write();
  }
}


/**  */
void VLanguagesDialog::setLayout()
{  
  setCaption( i18n("Languages") );
  
  // the global layout
  Layout.addLayout( &LanguageLayout );
  Layout.addWidget( &General );
  Layout.addWidget( &TypListEdit );
  
  // the language box
  LanguageLayout.addWidget( &LanguageControl );
  LanguageLayout.addWidget( &LanguageBox, 1  );

	New = LanguageControl.addButton( i18n("&New") );
	Delete = LanguageControl.addButton( i18n("&Delete") );
	LanguageControl.layout();
    
  // the general box
  General.setTitle( i18n( "General" ) );
  
  GeneralLayout.addSpacing( fontMetrics().height() );
  GeneralLayout.addWidget( &ShortLabel, 0, AlignLeft );
  GeneralLayout.addWidget( &ShortEdit );
  GeneralLayout.addWidget( &NameLabel, 0, AlignLeft );
  GeneralLayout.addWidget( &NameEdit );
  GeneralLayout.addWidget( &FontLabel, 0, AlignLeft );
  GeneralLayout.addLayout( &FontLayout );
  FontLayout.addWidget( &FontSelect );
  FontLayout.addWidget( &FontEdit, 1 );
  
    // the name edit
    NameLabel.setFixedSize( NameLabel.sizeHint() );
    NameEdit.setFixedHeight( NameEdit.sizeHint().height() );
    NameEdit.setMinimumWidth( NameEdit.sizeHint().width() );

    // the short edit
    ShortLabel.setFixedSize( ShortLabel.sizeHint() );
    ShortEdit.setFixedHeight( ShortEdit.sizeHint().height() );
    ShortEdit.setMinimumWidth( ShortEdit.sizeHint().width() );
    ShortEdit.setFocusPolicy( QWidget::NoFocus );
    ShortEdit.setCursor( arrowCursor );

    // the font edit
    FontLabel.setFixedSize( FontLabel.sizeHint() );
    FontEdit.setFixedHeight( FontEdit.sizeHint().height() );
    FontEdit.setMinimumWidth( FontEdit.sizeHint().width() );
  	KPixmap Pix;
  	Pix.load( KApplication::kde_toolbardir() + "/text.xpm" );
  	FontSelect.setPixmap( Pix );
  	FontSelect.setMinimumHeight( FontEdit.sizeHint().height() );
    FontSelect.setMinimumWidth( Pix.width()+4 );

  finishLayout();
}


/**  */
void VLanguagesDialog::refreshBox( const char* Name )
{
  LanguageBox.changeItem( Name, LanguageBox.currentItem() );
  LanguageBox.update();

  VLanguage *Language = List->at( LanguageBox.currentItem() );
  if( Language )
    Language->Name = Name;
}



/**  */
void VLanguagesDialog::selected( int Index )
{   
  if( List->isEmpty() )
    Index = -1;
  
  bool Enable = (Index != -1);
  if( General.isEnabled() != Enable )
  {
    General.setEnabled( Enable );
    ShortEdit.setEnabled( Enable );
    NameEdit.setEnabled( Enable );
    FontEdit.setEnabled( Enable );
    ShortLabel.setEnabled( Enable );
    NameLabel.setEnabled( Enable );
    FontLabel.setEnabled( Enable );
    FontSelect.setEnabled( Enable );
    Delete->setEnabled( Enable );
    LanguageBox.setEnabled( Enable );
    TypListEdit.setEnabled( Enable );
  }
  fill( Index );
}


/**  */
void VLanguagesDialog::fill( int Index )
{
  if( Index == -1 )
  {
    ShortEdit.setText( "" );
    NameEdit.setText( "" );
    FontEdit.setText( "" );
    TypListEdit.setList( 0 );
  }
  else
  {
    VLanguage *Language = List->at( Index );
     
    ShortEdit.setText( Language->Short );
    NameEdit.setText( Language->Name );
    displayFont( Language->Font );
    TypListEdit.setList( &Language->TypInfoList );
  }
}


void VLanguagesDialog::selectFont()
{
  int Index = LanguageBox.currentItem();
  VLanguage *Language = List->at( Index );
  
  QFont Font = Language->Font;
  if( KFontDialog::getFont( Font ) )
  {
    displayFont( Font );
    Language->Font = Font;
  }
}


void VLanguagesDialog::createLanguage()
{
  QString Short = "";
  if( !VEditDialog::edit( Short,i18n("Short"),this,0) )
    return;

  if( Short.isEmpty() )  
  {
    KMsgBox::message( this, i18n("Sorry"), i18n("An empty Code is not possible."), KMsgBox::STOP );
    return;
  }
  
  LanguageBox.appendNew( Short );
}



void VLanguagesDialog::deleteLanguage()
{
  QString Question = NameEdit.text();
  Question = i18n("Are you sure that you want\nto delete the language ") + Question + "?";
  
  if( KMsgBox::yesNo( 0L, i18n("Resurance"), Question, KMsgBox::QUESTION ) == 2 )
    return;
  
  LanguageBox.deleteCurrent();  
}



void VLanguagesDialog::displayFont( QFont &Font )
{
  QString Text; 
  QString Size;
  if( Font.bold() )
    Text = i18n("-Bold");
  if( Font.italic() )
    Text = i18n("-Italic") + Text;
  else
    Text = i18n("-Roman") + Text;
    
  // charset
  QString CharSet;
  switch( Font.charSet() ) 
  {
    case QFont::AnyCharSet:	CharSet = "*";
  	                        break;
    case QFont::Latin1: CharSet = "ISO8859-1";
  	                    break;
    case QFont::Latin2: CharSet = "ISO8859-2";
  	                    break;
    case QFont::Latin3: CharSet = "ISO8859-3";
  	                    break;
    case QFont::Latin4: CharSet = "ISO8859-4";
  	                    break;
    case QFont::Latin5: CharSet = "ISO8859-5";
  	                    break;
    case QFont::Latin6: CharSet = "ISO8859-6";
  	                    break;
    case QFont::Latin7: CharSet = "ISO8859-7";
  	                    break;
    case QFont::Latin8: CharSet = "ISO8859-8";
  	                    break;
    case QFont::Latin9: CharSet = "ISO8859-9";
  	                    break;
    case QFont::KOI8R:  CharSet = "KOI8-R";
  	                    break;
    default:            CharSet = "*";
  }
  
  Text = Font.family() + Text+", " + Size.setNum( Font.pointSize() ) + ", " + CharSet;
  Text[0] = Text.left(1).upper().at(0);
  
  FontEdit.setText( Text );
  FontEdit.setFont( Font );   
  FontEdit.setFixedHeight( FontEdit.sizeHint().height() );
	FontSelect.setMinimumHeight( FontEdit.sizeHint().height() );
}