#include <kapp.h>
#include <qmsgbox.h>
#include "deltabledlg.h"
#include "mysqlw.h"

#ifndef rcsid
static const char rcsid[]="$Id: deltabledlg.cpp,v 2.4 1999/07/31 00:51:57 ral Exp $";
const char*deltabledlg_rcs(){return rcsid;}
#endif

#define Inherited CDeleteTableDlgData

CDeleteTableDlg::CDeleteTableDlg(QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    setCaption( "Delete Table" );
    db_list = NULL;
    if (sql_server) {
	db_list = sql_server->get_db_list("%");
	if (db_list) {
	    for (stringlist::iterator iter=db_list->begin();iter!=db_list->end();++iter) {
		DBList->insertItem(iter->c_str());
	    }
	    delete db_list;
	    db_list = 0;
	}
	if (DBList->count()>0) {
	    DBList->setSelected(0,TRUE);
	} else {
	    DelTableButton->setEnabled(FALSE);
	}
    }
}

CDeleteTableDlg::~CDeleteTableDlg()
{
}

void CDeleteTableDlg::HilightDB(int item)
{
    QString item_name;
    item_name = DBList->text(item);
    stringlist*table_list;
    TableList->clear();
    TableList->repaint();
    table_list = sql_server->get_table_list("%",item_name);
    if (!table_list || table_list->empty()) {
	if (table_list) {
	    delete table_list;
	    table_list = 0;
	}
	DelTableButton->setEnabled(FALSE);
	return;
    }
    for (stringlist::iterator iter = table_list->begin();iter!=table_list->end();++iter) {
	TableList->insertItem(iter->c_str());
    }
    TableList->setSelected(0,TRUE);
    DelTableButton->setEnabled(TRUE);
    delete table_list;
    table_list = 0;
}

void CDeleteTableDlg::DelTable()
{
    int i;
    int item;
    QString table, db;
    QString msg;
    item = TableList->currentItem();
    if (item < 0)
	return;
    table = TableList->text(item);
    i = DBList->currentItem();
    if (i < 0)
	return;
    db = DBList->text(i);
    if (db == "mysql") {
	QMessageBox::critical(this,i18n("Error deleting table"),
			   i18n("With this soft you can not delete\na table of the systemdatabse")
			       );
	return;
    }
    msg = i18n("Do you realy want to delete the table ");
    msg+= db;
    msg+=".";
    msg+=table;
    msg+="?\n";
    msg+=i18n("Realy all data will be lost!\n");
    i = QMessageBox::warning( this, i18n("Deleting table"),
                              msg,
                              i18n("Of course"), i18n("Never!"),
                              0, 1 );
    if (i == 1) {
        return;
    }
    i = sql_server->delete_table(db,table);
    if (i < 0) {
	QMessageBox::critical(this,i18n("Error deleting table"),
			   i18n("Please look in the logwindow, whats going wrong")
			      );
	return;
    }
    TableList->removeItem(item);
    i = DBList->currentItem();
    HilightDB(i);
}

