/***************************************************************************
                          swordapi.h  -  description                              
                             -------------------                                         
    begin                : Thu Jun 24 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/swordapi.h,v 1.4 1999/10/19 12:24:11 uhl Exp $ */
/* $Revision: 1.4 $ */

#ifndef SWORDAPI_H
#define SWORDAPI_H

//include files for Qt
#include <qcolor.h>
#include <qstring.h>

//include files for KDE
#include <kapp.h>
#include <kconfig.h>

//SWORD includes
#include <swmgr.h>

//own includes
#include "bibletime.h"

class BibleTimeMgr : public SWMgr
{
	SWFilter *gbftohtml;
	SWFilter *rwptohtml;
	SWFilter *plaintohtml;
	
protected:
	virtual void AddRenderFilters(SWModule *module, ConfigEntMap &section);
	
public:
	BibleTimeMgr();
	virtual ~BibleTimeMgr();
};


// Display classes to receive text from the module, render it
// and send it away
class HTMLEntryDisplay : public SWDisplay
{
public:
	HTMLEntryDisplay(BibleTimeDoc *doc);
	virtual ~HTMLEntryDisplay();
	
	virtual char Display(SWModule &imodule);
	
	QString verseColor;
	QString verseNumberColor;

public slots:
	void slotChangeColors();
		
protected:
	BibleTimeDoc *doc;
};

class HTMLChapterDisplay : public HTMLEntryDisplay
{

public:
	HTMLChapterDisplay(BibleTimeDoc *doc) : HTMLEntryDisplay(doc) {};
	virtual ~HTMLChapterDisplay();
	
	virtual char Display(SWModule &imodule);
};
// End of Display Classes

#endif // SWORDAPI_H



