/***************************************************************************
                          cchartwidget.cpp  -  description
                             -------------------
    begin                : Thu Sep 2 1999
    copyright            : (C) 1999 by Torsten Uhlmann
    email                : TUhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cchartwidget.h"
#include <qwmatrix.h>

CChartWidget::CChartWidget(QWidget *parent, const char *name) : QWidget(parent,name)
{
	painter.begin(this);
	barCount=0;
	unit=1;
}

CChartWidget::~CChartWidget()
{
	painter.end();
}

void CChartWidget::addBar(int value, QString text)
{
	valueList.append( (int*) value );
	textList.append( text );
	barCount++;
}

void CChartWidget::paintBar(int x, int y, int value)
{
	//check if the book is in the new testament
	if ( x > (AXES_SPACE+(BAR_WIDTH+BAR_SPACE)*38) )
		painter.setBrush(blue);		//paint books in new testament in red	
	else
		painter.setBrush(red); 	//paint books in old testament in red			
	
	painter.drawRect( x,y, BAR_WIDTH, value );
}


void CChartWidget::paintEvent(QPaintEvent *event)
{
	for(int n=0; n < barCount; n++)
		paintBar( AXES_SPACE+(BAR_WIDTH+BAR_SPACE)*n, this->height()-AXES_SPACE, -((uint)valueList.at(n) * unit *0.96) );

	paintText();
	paintAxes();
}


void CChartWidget::paintAxes()
{
//the Y axe
	painter.drawLine(AXES_SPACE, AXES_SPACE, AXES_SPACE, this->height() - AXES_SPACE);

//the X axe
	painter.drawLine(AXES_SPACE, this->height()-AXES_SPACE, BOOKS*BAR_WIDTH+BOOKS*BAR_SPACE+AXES_SPACE, this->height()-AXES_SPACE);
}

void CChartWidget::paintText()
{
	//compute the final text of each book description
	QString finalText;	
	
	painter.save();	
 	painter.setPen(black);
	
	for(int n=0; n < barCount; n++)
	{
		painter.save();			
		finalText = (QString) textList.at(n) + ": "	+ finalText.setNum( (int)valueList.at(n) );
  	painter.translate( AXES_SPACE+(BAR_WIDTH+BAR_SPACE)*n+5, this->height()-AXES_SPACE-15-painter.fontMetrics().width( finalText ) );
  	painter.rotate(90);				
		painter.drawText(0,0,finalText);
	 	painter.restore();
  };
 	
 	painter.restore();
}


void CChartWidget::setMaxCount( int value )
{
	maxCount = value;
	resizeEvent(0);	
}

void CChartWidget::resizeEvent( QResizeEvent *event )
{
	QWidget::resizeEvent(event);
	
	if (maxCount!=0)
		unit =	double(parentWidget()->height()) / double(maxCount);
	if ( unit==0 )
		unit=1;
	
	this->resize(AXES_SPACE + BOOKS*(BAR_WIDTH+BAR_SPACE)+10, maxCount*unit + AXES_SPACE);
}
