/*
    File: texttoolbar.h
    Version: 0.2.4
    Date: 31-DEC-1998
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    The TextToolBar shows the total amount of received and
    transmitted data and the time spend online.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#ifndef TEXTTOOLBAR_H
#define TEXTTOOLBAR_H

#include <ktoolbar.h>
#include <qlabel.h>
#include <qdatetm.h>
#include "smif.h"



// 1K and 1M edge

#define CHTXRX1K 1000
#define CHTXRX1M 1000000



// class definition

class TextToolBar : public KToolBar {

  // TextToolBar is a qobject
  Q_OBJECT

public:

  // constructor
  TextToolBar(smif* serialmon,QWidget* parent=0);

private:

  // smif to refer to
  smif* serialmon;

  // labels for tx/rx-count & online-timer
  QLabel* txtext;
  QLabel* rxtext;
  QLabel* tmtext;

  // online timer
  QTime online;

private slots:

  // update items in Text-Toolbar (TX/RX-count & online-time)
  void updateRX(float);
  void updateTX(float);
  void updateTime();

  void DCDchanged(bool);
};



#endif


