/*

    File: pref.h
    Version: 0.3.1
    Date: 31-DEC-1998
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    This is part of "ksermon". The preference widget provides a
    GUI to select input device, maximum display rate
    and update interval.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#ifndef PREF_H
#define PREF_H



#include <qframe.h>
#include <qcombo.h>
#include <qslider.h>



class pref : public QFrame {

  Q_OBJECT

public:

  pref(QWidget* parent=0,char* name="");

private:

  QComboBox* deviceCombo;

  QComboBox* rateCombo;
  QSlider* rateSlider;
  QString rateSliderText;

  QComboBox* intervalCombo;
  QSlider* intervalSlider;
  QString intervalSliderText;

  QComboBox* tauCombo;
  QSlider* tauSlider;
  QString tauSliderText;

signals:

  void deviceChanged(const char*);
  void rateChanged(float);
  void intervalChanged(int);
  void tauChanged(int);
  void doSave();
  void doOk();

private slots:

  void deviceChangedIn(const char*);
  void rateChangedIn(float);
  void intervalChangedIn(int);
  void tauChangedIn(int);

  void deviceComboAktivated(const char*);
  void rateComboAktivated(const char*);
  void intervalComboAktivated(const char*);
  void tauComboAktivated(const char*);
  void rateSliderValueChanged(int);
  void intervalSliderValueChanged(int);
  void tauSliderValueChanged(int);
  void savePressed();
  void okPressed();

};



#endif
