/***************************************************************************
                          main.cpp - Main Entrance to Karam/KInstall
                             -------------------                                         
    begin                : Sun May  2 14:35:31 WEST 1999
                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "argHandler.h"
#include "karaMainWidget.h"
#include "kinstall/ki.h"
#include <kcontrol.h>

class karamApplication : public KControlApplication
{
public:
	karamApplication( int argc, char * argv[], const char* name);
	~karamApplication();
public slots:
	void init();
	void apply();
	void help();
	void defaultValues();
private:
	karamMainWidget *karam;
};

karamApplication::karamApplication( int argc, char * argv[], const char *name ):KControlApplication( argc,argv,name )
{
  karam = 0;

  if (runGUI())
    {
      if (!pages || pages->contains("Add/Remove Programs"))
        addPage(karam = new karamMainWidget(dialog), i18n("Add/Remove Programs"), "index.html");

      if (karam)
        dialog->show();
      else
        {
				printf(i18n("Error while adding the KARAM's Main Widget!\nTerminated\n"));kapp->quit();exit(0);
        }
    }
}
karamApplication::~karamApplication(){}
void karamApplication::init(){}
void karamApplication::apply(){}
void karamApplication::help(){KApplication::getKApplication()->invokeHTMLHelp ("","");}
void karamApplication::defaultValues(){}

int main(int argc, char ** argv) {
	argHandler ah( argc, argv );

	if (ah.contains("-v")||ah.contains("--version")){
		printf("KDE Add/Remove Applications Module (Karam) version %s\n",VERSION);exit(0);}
	else if (ah.contains("-h")||ah.contains("--help")){
		printf("KDE Add/Remove Applications Module (Karam) usage:\n   karam [options]\nOptions:\n  -init    Makes part of the configuration modules (Do nothing in Karam)\n  -i, --install  Launches KInstall\n  -v, --version  Prints Karma's version and exits\n  -h, --help     What you are seing :-)\n");exit(0);}
	else if (ah.contains("-i")||ah.contains("--install")){
		KApplication a_ki( argc, argv, "kinstall" );
		KI *ki = new KI();
		a_ki.setMainWidget(ki);
		ki->show();
		return a_ki.exec();
	}
	
	karamApplication a( argc, argv, "karam" );
	a.setTitle(i18n("KDE Add/Remove Applications Module"));
	
	if (a.runGUI()) return a.exec(); else return 0;
}













