/*
    Copyright (C) 2018 Luca Beltrame <lbeltrame@kde.org>

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU Library General Public License as published by
    the Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/


#ifndef KITINERARY_ORGANIZATION_H
#define KITINERARY_ORGANIZATION_H

#include "kitinerary_export.h"

#include "datatypes.h"
#include "place.h"

class QUrl;

namespace KItinerary {

class OrganizationPrivate;

/** An organization.
 *
 *  This slightly deviates from the schema.org definition and also includes
 *  properties of Place that its sub-classes need. This is a simplification
 *  to avoid having to use multi-inheritance.
 *
 *  @see https://schema.org/Organization
 */

class KITINERARY_EXPORT Organization
{
    KITINERARY_BASE_GADGET(Organization)
    KITINERARY_PROPERTY(QString, name, setName)
    KITINERARY_PROPERTY(QString, description, setDescription)
    KITINERARY_PROPERTY(QUrl, image, setImage)
    KITINERARY_PROPERTY(QString, email, setEmail)
    KITINERARY_PROPERTY(QString, telephone, setTelephone)
    KITINERARY_PROPERTY(QUrl, url, setUrl)
    KITINERARY_PROPERTY(KItinerary::PostalAddress, address, setAddress)
    KITINERARY_PROPERTY(KItinerary::GeoCoordinates, geo, setGeo)
    KITINERARY_PROPERTY(QVariantList, potentialAction, setPotentialAction)
protected:
    ///@cond internal
    QExplicitlySharedDataPointer<OrganizationPrivate> d;
    ///@endcond
};

class AirlinePrivate;

/** An airline.
 *  @see https://schema.org/Airline
 */
class KITINERARY_EXPORT Airline : public Organization
{
    KITINERARY_GADGET(Airline)
    KITINERARY_PROPERTY(QString, iataCode, setIataCode)
};

/** Hotel.
 *  @see https://schema.org/LodgingBusiness
 */
class KITINERARY_EXPORT LodgingBusiness: public Organization
{
    KITINERARY_GADGET(LodgingBusiness)
};

/** Food-related business (such as a restaurant, or a bakery).
 * @see https://schema.org/FoodEstablishment
 */
class KITINERARY_EXPORT FoodEstablishment: public Organization
{
    KITINERARY_GADGET(FoodEstablishment)
};

} // namespace KItinerary

Q_DECLARE_METATYPE(KItinerary::Organization)
Q_DECLARE_METATYPE(KItinerary::Airline)
Q_DECLARE_METATYPE(KItinerary::FoodEstablishment)
Q_DECLARE_METATYPE(KItinerary::LodgingBusiness)

#endif // KITINERARY_ORGANIZATION_H
