/*
  Copyright (c) 2013 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef SENDLATERJOB_H
#define SENDLATERJOB_H

#include <QObject>

#include "sendlatermanager.h"

#include <Akonadi/ItemFetchScope>
#include <Akonadi/Item>

class SendLaterInfo;
class KJob;
class SendLaterJob : public QObject
{
    Q_OBJECT
public:
    explicit SendLaterJob(SendLaterManager *manager, SendLaterInfo *info, QObject *parent = 0);
    ~SendLaterJob();
    void start();

private Q_SLOTS:
    void sendDone();
    void sendError(const QString &error, SendLaterManager::ErrorType type);
    void slotMessageTransfered(const Akonadi::Item::List& );
    void slotJobFinished(KJob*);

Q_SIGNALS:
    void error(const QString &err);
    void done();

private:
    Akonadi::ItemFetchScope mFetchScope;
    SendLaterManager *mManager;
    SendLaterInfo *mInfo;
    Akonadi::Item mItem;
};

#endif // SENDLATERJOB_H
