/*  GNU moe - My Own Editor
    Copyright (C) 2005-2017 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Buffer_handle
  {
  Buffer * bufferp_;	// handled buffer

public:
  Point top_left;	// buffer coordinates of window top-left corner
  Point cursor;		// buffer virtual coordinates of window cursor
  Point pointer;	// current buffer character (index in buffer[])
  Point pcursor;	// buffer coordinates of current buffer character

  explicit Buffer_handle( Buffer & buf, const int line = 0, const int col = 0 )
    : bufferp_( &buf ), top_left( 0, 0 ), cursor( line, col )
    { pointer = buf.to_pointer( cursor, pcursor ); }

  Buffer & buffer() { return *bufferp_; }
  const Buffer & buffer() const { return *bufferp_; }
  };


// Bufhandle_vector is the main data structure of the editor.
// It contains the handles for all the buffers being edited.
// Bufhandle_vector is a circular buffer of Buffer_handles
//
namespace Bufhandle_vector {

void init();
const char * save_all_named();
const char * show_status();

int absolute_index( const int i );
int circular_index( const int ai );
Buffer_handle & handle( const int i );
int handles();
int handles( const Buffer & buffer );
int last_visited( const int i );
void next();
void prev();
void set_first( const int ai );

int find_or_add_handle( const std::string * const namep = 0,
                        int i = -1, const int line = 0, const int col = 0,
                        const bool read_only = false );
void add_handle_if_pending_input_or_empty( const int line, const int col );
void duplicate_handle( int i );
bool delete_handle( int i );

} // end namespace Bufhandle_vector
