/*  GNU moe - My Own Editor
    Copyright (C) 2005-2019 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Window
  {
  Buffer_handle * bhp;
  int top_line_, height_;	// top line and height of window on screen

  Point relative_cursor() const;	// cursor position on window

public:
  enum { min_height = 4 };
  Window( Buffer_handle & bh, const int tl, const int h, const bool center );

  Buffer & buffer() const { return bhp->buffer(); }
  Buffer_handle & buffer_handle() const { return *bhp; }
  Point & pointer() const { return bhp->pointer; }

  Point clock_position() const;
  Point absolute_cursor() const;	// cursor position on screen
  int height() const { return height_; }
  int top_line() const { return top_line_; }

  void center_cursor();
  void goto_bof();
  void goto_eof();
  void goto_home();
  void goto_eol();
  const char * goto_begin_of_block();
  const char * goto_end_of_block();
  const char * goto_line();
  const char * goto_column();
  const char * goto_offset();
  const char * goto_mark( const int i );
  const char * goto_matching_delimiter( const bool forward = true );
  void goto_pnext();
  void goto_pprev();
  void move_page( const bool down, const bool scroll = false );
  void move_vertical( const int lines );
  void scroll_horizontal( const int cols );
  void scroll_vertical( const int lines );

  const char * extend_marks();
  const char * set_mark( const int i );

  void repaint() const;
  const char * show_character_info() const;
  const char * show_multichar_value( const int size, const bool big_endian ) const;
  const char * show_utf8_code();
  void show_status_line( const char * const prefix = 0 ) const;

  enum From { from_top_left, from_cursor, from_pointer };
  void update_points( const Point & to, const bool show = true,
                      bool center = false, const From from = from_pointer );
  };
