/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CompileFile {
    public static final Compilation read(String string, SourceMessages sourceMessages) throws IOException, SyntaxException {
        try {
            InPort inPort = InPort.openFile(string);
            Compilation compilation = CompileFile.read(inPort, sourceMessages);
            inPort.close();
            return compilation;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WrappedException("compile-file: file not found: " + string, fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new WrappedException("compile-file: read-error: " + string, iOException);
        }
    }

    public static final Compilation read(InPort inPort, SourceMessages sourceMessages) throws IOException, SyntaxException {
        return Language.getDefaultLanguage().parse(inPort, sourceMessages, 0);
    }

    public static void compile_to_files(String string, String string2, String string3, String string4, SourceMessages sourceMessages) {
        Object object2;
        if (string4 == null) {
            object2 = new File(string);
            String string5 = ((File)object2).getName();
            int n = string5.lastIndexOf(46);
            if (n > 0) {
                string5 = string5.substring(0, n);
            }
            string4 = string5 = Compilation.mangleNameIfNeeded(string5);
            if (string3 != null) {
                string4 = string3 + string5;
            }
        }
        try {
            object2 = CompileFile.read(string, sourceMessages);
            if (sourceMessages.seenErrors()) {
                return;
            }
            try {
                ((Compilation)object2).compileToFiles(((Compilation)object2).getModule(), string4, string2, string3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                System.exit(-1);
            }
            if (sourceMessages.seenErrors()) {
                return;
            }
        }
        catch (SyntaxException syntaxException) {
            if (syntaxException.getMessages() != sourceMessages) {
                throw new RuntimeException("confussing syntax error: " + syntaxException);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }
}

