/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.NameLookup;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;

public class ResolveNames
extends ExpWalker {
    NameLookup lookup;

    public static void resolveNames(Expression expression, NameLookup nameLookup) {
        ResolveNames resolveNames = new ResolveNames();
        resolveNames.lookup = nameLookup;
        resolveNames.walk(expression);
    }

    protected Expression walkScopeExp(ScopeExp scopeExp) {
        this.lookup.push(scopeExp);
        scopeExp.walkChildren(this);
        this.lookup.pop(scopeExp);
        return scopeExp;
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        Declaration declaration = referenceExp.getBinding();
        if (declaration == null && (declaration = this.lookup.lookup(referenceExp.getSymbol(), referenceExp.isProcedureName())) != null) {
            referenceExp.setBinding(declaration);
        }
        return referenceExp;
    }

    protected Expression walkSetExp(SetExp setExp) {
        Declaration declaration = setExp.binding;
        if (declaration == null && (declaration = this.lookup.lookup(setExp.getSymbol(), setExp.isFuncDef())) != null) {
            setExp.binding = declaration;
        }
        return super.walkSetExp(setExp);
    }
}

