/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.bytecode.ZipLoader;
import gnu.expr.Compilation;
import gnu.expr.CompiledModule;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.lists.AbstractFormat;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongArguments;
import gnu.text.FilePath;
import gnu.text.Path;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;

public class Shell {
    public static ThreadLocal currentLoadPath = new ThreadLocal();
    private static Class[] noClasses = new Class[0];
    private static Class[] boolClasses = new Class[]{Boolean.TYPE};
    private static Class[] xmlPrinterClasses = new Class[]{OutPort.class, Object.class};
    private static Class[] httpPrinterClasses = new Class[]{OutPort.class};
    private static Object portArg = "(port)";
    static Object[][] formats = new Object[][]{{"scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.FALSE}, {"readable-scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.TRUE}, {"elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.FALSE}, {"readable-elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.TRUE}, {"clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"xml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, null}, {"html", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "html"}, {"xhtml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "xhtml"}, {"cgi", "gnu.kawa.xml.HttpPrinter", "make", httpPrinterClasses, portArg}, {"ignore", "gnu.lists.VoidConsumer", "getInstance", noClasses}, {null}};
    public static String defaultFormatName;
    public static Object[] defaultFormatInfo;
    public static Method defaultFormatMethod;

    public static void setDefaultFormat(String name) {
        defaultFormatName = name = name.intern();
        int i = 0;
        while (true) {
            Object[] info;
            Object iname;
            if ((iname = (info = formats[i])[0]) == null) {
                System.err.println("kawa: unknown output format '" + name + "'");
                System.exit(-1);
            } else if (iname == name) {
                defaultFormatInfo = info;
                try {
                    Class<?> formatClass = Class.forName((String)info[1]);
                    defaultFormatMethod = formatClass.getMethod((String)info[2], (Class[])info[3]);
                }
                catch (Throwable ex) {
                    System.err.println("kawa:  caught " + ex + " while looking for format '" + name + "'");
                    System.exit(-1);
                }
                break;
            }
            ++i;
        }
        if (!defaultFormatInfo[1].equals("gnu.lists.VoidConsumer")) {
            ModuleBody.setMainPrintValues(true);
        }
    }

    public static Consumer getOutputConsumer(OutPort out) {
        Object[] info = defaultFormatInfo;
        if (out == null) {
            return VoidConsumer.getInstance();
        }
        if (info == null) {
            return Language.getDefaultLanguage().getOutputConsumer(out);
        }
        try {
            Object[] args = new Object[info.length - 4];
            System.arraycopy(info, 4, args, 0, args.length);
            int i = args.length;
            while (--i >= 0) {
                if (args[i] != portArg) continue;
                args[i] = out;
            }
            Object format = defaultFormatMethod.invoke(null, args);
            if (format instanceof AbstractFormat) {
                out.objectFormat = (AbstractFormat)format;
                return out;
            }
            return (Consumer)format;
        }
        catch (Throwable ex) {
            throw new RuntimeException("cannot get output-format '" + defaultFormatName + "' - caught " + ex);
        }
    }

    public static boolean run(Language language, Environment env) {
        OutPort perr;
        InPort inp = InPort.inDefault();
        SourceMessages messages = new SourceMessages();
        if (inp instanceof TtyInPort) {
            Procedure prompter = language.getPrompter();
            if (prompter != null) {
                ((TtyInPort)inp).setPrompter(prompter);
            }
            perr = OutPort.errDefault();
        } else {
            perr = null;
        }
        Throwable ex = Shell.run(language, env, inp, OutPort.outDefault(), perr, messages);
        if (ex == null) {
            return true;
        }
        Shell.printError(ex, messages, OutPort.errDefault());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable run(Language language, Environment env, InPort inp, OutPort pout, OutPort perr, SourceMessages messages) {
        AbstractFormat saveFormat = null;
        if (pout != null) {
            saveFormat = pout.objectFormat;
        }
        Consumer out = Shell.getOutputConsumer(pout);
        try {
            Throwable throwable = Shell.run(language, env, inp, out, perr, null, messages);
            return throwable;
        }
        finally {
            if (pout != null) {
                pout.objectFormat = saveFormat;
            }
        }
    }

    public static boolean run(Language language, Environment env, InPort inp, Consumer out, OutPort perr, URL url) {
        SourceMessages messages = new SourceMessages();
        Throwable ex = Shell.run(language, env, inp, out, perr, url, messages);
        if (ex != null) {
            Shell.printError(ex, messages, perr);
        }
        return ex == null;
    }

    /*
     * Exception decompiling
     */
    public static Throwable run(Language language, Environment env, InPort inp, Consumer out, OutPort perr, URL url, SourceMessages messages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void printError(Throwable ex, SourceMessages messages, OutPort perr) {
        SyntaxException se;
        if (ex instanceof WrongArguments) {
            WrongArguments e = (WrongArguments)ex;
            messages.printAll(perr, 20);
            if (e.usage != null) {
                perr.println("usage: " + e.usage);
            }
            e.printStackTrace(perr);
        } else if (ex instanceof SyntaxException && (se = (SyntaxException)ex).getMessages() == messages) {
            se.printAll(perr, 20);
            se.clear();
        } else {
            messages.printAll(perr, 20);
            ex.printStackTrace(perr);
        }
    }

    public static final CompiledModule checkCompiledZip(InputStream fs, Path path, Environment env, Language language) throws IOException {
        try {
            fs.mark(5);
            boolean isZip = fs.read() == 80 && fs.read() == 75 && fs.read() == 3 && fs.read() == 4;
            fs.reset();
            if (!isZip) {
                return null;
            }
        }
        catch (IOException ex) {
            return null;
        }
        fs.close();
        Environment orig_env = Environment.getCurrent();
        String name = path.toString();
        try {
            if (env != orig_env) {
                Environment.setCurrent(env);
            }
            if (!(path instanceof FilePath)) {
                throw new RuntimeException("load: " + name + " - not a file path");
            }
            File zfile = ((FilePath)path).toFile();
            if (!zfile.exists()) {
                throw new RuntimeException("load: " + name + " - not found");
            }
            if (!zfile.canRead()) {
                throw new RuntimeException("load: " + name + " - not readable");
            }
            ZipLoader loader = new ZipLoader(name);
            Class clas = loader.loadAllClasses();
            CompiledModule compiledModule = CompiledModule.make(clas, language);
            return compiledModule;
        }
        catch (IOException ex) {
            throw new WrappedException("load: " + name + " - " + ex.toString(), ex);
        }
        finally {
            if (env != orig_env) {
                Environment.setCurrent(orig_env);
            }
        }
    }

    public static boolean runFileOrClass(String fname, boolean lineByLine, int skipLines) {
        Language language = Language.getDefaultLanguage();
        try {
            InputStream fs;
            Path path;
            if (fname.equals("-")) {
                path = Path.valueOf("/dev/stdin");
                fs = System.in;
            } else {
                path = Path.valueOf(fname);
                fs = path.openInputStream();
            }
            try {
                Environment env = Environment.getCurrent();
                return Shell.runFile(fs, path, env, lineByLine, skipLines);
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                return false;
            }
        }
        catch (Throwable e) {
            Class<?> clas;
            try {
                clas = Class.forName(fname);
            }
            catch (Throwable ex) {
                System.err.println("Cannot read file " + e.getMessage());
                return false;
            }
            try {
                Shell.runClass(clas, Environment.getCurrent());
                return true;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }

    public static void runClass(Class clas, Environment env) throws Throwable {
        CompiledModule cmodule = CompiledModule.make(clas, Language.getDefaultLanguage());
        cmodule.evalModule(env, OutPort.outDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean runFile(InputStream fs, Path path, Environment env, boolean lineByLine, int skipLines) throws Throwable {
        if (!(fs instanceof BufferedInputStream)) {
            fs = new BufferedInputStream(fs);
        }
        Language language = Language.getDefaultLanguage();
        Path savePath = (Path)currentLoadPath.get();
        try {
            currentLoadPath.set(path);
            CompiledModule cmodule = Shell.checkCompiledZip(fs, path, env, language);
            if (cmodule == null) {
                InPort src = InPort.openFile(fs, path);
                while (--skipLines >= 0) {
                    src.skipRestOfLine();
                }
                try {
                    SourceMessages messages = new SourceMessages();
                    URL url = path.toURL();
                    OutPort perr = OutPort.errDefault();
                    if (lineByLine) {
                        boolean print = ModuleBody.getMainPrintValues();
                        Consumer out = print ? Shell.getOutputConsumer(OutPort.outDefault()) : new VoidConsumer();
                        Throwable ex = Shell.run(language, env, src, out, perr, url, messages);
                        if (ex != null) {
                            throw ex;
                        }
                    } else {
                        cmodule = Shell.compileSource(src, env, url, language, messages);
                        messages.printAll(perr, 20);
                        if (cmodule == null) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                finally {
                    src.close();
                }
            }
            if (cmodule != null) {
                cmodule.evalModule(env, OutPort.outDefault());
            }
        }
        finally {
            currentLoadPath.set(savePath);
        }
        return true;
    }

    static CompiledModule compileSource(InPort port, Environment env, URL url, Language language, SourceMessages messages) throws SyntaxException, IOException {
        ModuleManager manager = ModuleManager.getInstance();
        ModuleInfo minfo = manager.findWithSourcePath(port.getName());
        Compilation comp = language.parse(port, messages, 1, minfo);
        CallContext ctx = CallContext.getInstance();
        ctx.values = Values.noArgs;
        Object inst = ModuleExp.evalModule1(env, comp, url, null);
        if (inst == null || messages.seenErrors()) {
            return null;
        }
        return new CompiledModule(comp.getModule(), inst, language);
    }
}

