/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.IntegerStack;
import gnu.jel.TableKeeper;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.util.Stack;

public class TypesStack
implements Cloneable {
    public static final Class[] specialTypes = (Class[])TableKeeper.getTable("specialTypes");
    public static final byte[] baseType = (byte[])TableKeeper.getTable("baseType");
    public static final byte[] unwrapType = (byte[])TableKeeper.getTable("unwrapType");
    public static final char[] primitiveCodes = (char[])TableKeeper.getTable("primitiveCodes");
    protected static final byte[] stkoccup = (byte[])TableKeeper.getTable("stkoccup");
    private IntegerStack typeIDs = new IntegerStack();
    private Stack classes = new Stack();
    protected int currWords = 0;
    private int maxWords = 0;
    private static final int[] cvt_wide = (int[])TableKeeper.getTable("cvt_wide");

    public static final int typeID(Class c) {
        if (c == null) {
            return 8;
        }
        if (c.isPrimitive()) {
            int i = 0;
            while (i < 10 && specialTypes[i] != c) {
                ++i;
            }
            Debug.assert(i < 10, "You didn't put _ALL_ primitive types into primitiveTypes array.");
            return i;
        }
        int i = 11;
        while (i < specialTypes.length && !specialTypes[i].isAssignableFrom(c)) {
            ++i;
        }
        if (i < specialTypes.length) {
            return i;
        }
        return 8;
    }

    public static final int typeIDObject(Object o) {
        if (o instanceof Boolean) {
            return 0;
        }
        if (o instanceof Byte) {
            return 1;
        }
        if (o instanceof Character) {
            return 2;
        }
        if (o instanceof Short) {
            return 3;
        }
        if (o instanceof Integer) {
            return 4;
        }
        if (o instanceof Long) {
            return 5;
        }
        if (o instanceof Float) {
            return 6;
        }
        if (o instanceof Double) {
            return 7;
        }
        if (o instanceof String) {
            return 11;
        }
        return 8;
    }

    public Object clone() {
        TypesStack res = null;
        try {
            res = (TypesStack)super.clone();
            res.typeIDs = (IntegerStack)res.typeIDs.clone();
            res.classes = (Stack)res.classes.clone();
        }
        catch (CloneNotSupportedException exc) {
            Debug.reportThrowable(exc);
        }
        return res;
    }

    public final Class peek() {
        return (Class)this.classes.peek();
    }

    public final int peekID() {
        return this.typeIDs.peek();
    }

    public final Class peek(int i) {
        return (Class)this.classes.elementAt(this.classes.size() - 1 - i);
    }

    public final int peekID(int i) {
        return this.typeIDs.peek(i);
    }

    public final Class pop() {
        int id = this.typeIDs.pop();
        this.currWords -= stkoccup[baseType[id]];
        Debug.assert(this.currWords >= 0);
        return (Class)this.classes.pop();
    }

    public final void pushID(int id, Class c) {
        Debug.assert(id != 8 || c != null);
        this.typeIDs.push(id);
        if (c != null) {
            this.classes.push(c);
        } else {
            this.classes.push(specialTypes[id]);
        }
        this.currWords += stkoccup[baseType[id]];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void pushID(int id) {
        Debug.assert(id != 8);
        this.pushID(id, null);
    }

    public final void push(Class c) {
        this.pushID(TypesStack.typeID(c), c);
    }

    public final void push(Class cls, int i) {
        int id = TypesStack.typeID(cls);
        this.typeIDs.push(id, i);
        this.classes.insertElementAt(cls, this.classes.size() - i);
        this.currWords += stkoccup[baseType[id]];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void pushID(int id, int i) {
        Class cls = specialTypes[id];
        this.typeIDs.push(id, i);
        this.classes.insertElementAt(cls, this.classes.size() - i);
        this.currWords += stkoccup[baseType[id]];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final int size() {
        return this.typeIDs.size();
    }

    public final void resetStats() {
        Debug.assert(this.currWords == 0);
        this.maxWords = 0;
    }

    public final void tempExcessWords(int nw) {
        if ((nw = this.currWords + nw) > this.maxWords) {
            this.maxWords = nw;
        }
    }

    public final int getMaxOccupation() {
        return this.maxWords;
    }

    public static boolean isWidening(int id1, Class c1, int id2, Class c2) {
        if (baseType[id2] == 8 && id2 != 11 && id1 != 28) {
            if (baseType[id1] == 8) {
                return c2.isAssignableFrom(c1);
            }
            return false;
        }
        Debug.assert((id1 = unwrapType[id1]) < cvt_wide.length);
        return (cvt_wide[id2] & 2048 >> id1) > 0;
    }

    public static boolean isIntegral(int id1) {
        return (62 >> id1 & 1) > 0;
    }

    public static boolean isWidening(Class c1, Class c2) {
        return TypesStack.isWidening(TypesStack.typeID(c1), c1, TypesStack.typeID(c2), c2);
    }

    protected static Number widen(Object o, int clsID) {
        switch (clsID) {
            case 0: {
                if (((Boolean)o).booleanValue()) {
                    return new Long(1L);
                }
                return new Long(0L);
            }
            case 1: {
                return (Number)o;
            }
            case 2: {
                return new Long(((Character)o).charValue());
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (Number)o;
            }
        }
        Debug.println("Attempt to widen wrong primitive (" + clsID + ").");
        return new Long(0L);
    }

    protected static Object narrow(Number val, int clsID) {
        switch (clsID) {
            case 0: {
                if (val.longValue() != 0L) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                return new Byte(val.byteValue());
            }
            case 2: {
                return new Character((char)val.longValue());
            }
            case 3: {
                return new Short(val.shortValue());
            }
            case 4: {
                return new Integer(val.intValue());
            }
            case 5: {
                return new Long(val.longValue());
            }
            case 6: {
                return new Float(val.floatValue());
            }
            case 7: {
                return new Double(val.doubleValue());
            }
        }
        Debug.println("Attempt to narrow wrong primitive (" + clsID + ").");
        return null;
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        TypesStack.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        TypesStack ts = null;
        try {
            t.startTest("ID(Boolean.TYPE)==ID(new Boolean(true))");
            t.compare(TypesStack.typeID(Boolean.TYPE), TypesStack.typeIDObject(new Boolean(true)));
            t.startTest("ID(Byte.TYPE)==ID(new Byte(0))");
            t.compare(TypesStack.typeID(Byte.TYPE), TypesStack.typeIDObject(new Byte(0)));
            t.startTest("ID(\"string\".getClass())==11");
            t.compare(TypesStack.typeID("string".getClass()), 11);
            t.startTest("ID((new Object()).getClass())==8");
            t.compare(TypesStack.typeID(new Object().getClass()), 8);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("Make a new types stack");
            ts = new TypesStack();
            t.testOK();
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("push(Integer.TYPE);pushID(4); pop()==pop()");
            ts.push(Integer.TYPE);
            ts.pushID(4);
            t.compare(ts.pop(), ts.pop());
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("push(Integer.TYPE,0);pushID(4,0); pop()==pop()");
            ts.push(Integer.TYPE, 0);
            ts.pushID(4, 0);
            t.compare(ts.pop(), ts.pop());
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("push(Long.TYPE);pushID(6);pushID(4,1);peekID()==peekID(1)+2");
            ts.push(Long.TYPE);
            ts.pushID(6);
            ts.pushID(4, 1);
            t.compare(ts.peekID(), ts.peekID(1) + 2);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("pop();peekID()==peekID(1)-1");
            ts.pop();
            t.compare(ts.peekID(), ts.peekID(1) - 1);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("getMaxOccupation()==4");
            t.compare(ts.getMaxOccupation(), 4);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("pop();pop(); size()==0");
            ts.pop();
            ts.pop();
            t.compare(ts.size(), 0);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
    }
}

