.TH LKBIB @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
lkbib \- search bibliographic databases
.
.
.\" --------------------------------------------------------------------
.\" Legal Terms
.\" --------------------------------------------------------------------
.
.de co
Copyright \[co] 1989-2014 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.
.\" --------------------------------------------------------------------
.\" Definitions
.\" --------------------------------------------------------------------
.
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.  ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.  el .TP "\\$1"
..
.
.\" --------------------------------------------------------------------
.SH SYNOPSIS
.\" --------------------------------------------------------------------
.
.B lkbib
[
.B \-v
]
[
.BI \-i fields
]
[
.BI \-p filename
]
[
.BI \-t n
]
.IR key \|.\|.\|.
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
.B lkbib
searches bibliographic databases for references that contain the keys
.IR key \|.\|.\|.\&
and prints any references found on the standard output.
.
.B lkbib
will search any databases given by
.B \-p
options, and then a default database.
.
The default database is taken from the
.SB REFER
environment variable if it is set,
otherwise it is
.BR @DEFAULT_INDEX@ .
.
For each database
.I filename
to be searched,
if an index
.IB filename @INDEX_SUFFIX@
created by
.BR @g@indxbib (@MAN1EXT@)
exists, then it will be searched instead;
each index can cover multiple databases.
.
.
.\" --------------------------------------------------------------------
.SH OPTIONS
.\" --------------------------------------------------------------------
.
It is possible to have whitespace between a command line option and its
parameter.
.
.
.TP
.B \-v
Print the version number.
.
.TP
.BI \-p filename
Search
.IR filename .
.
Multiple
.B \-p
options can be used.
.
.TP
.BI \-i string
When searching files for which no index exists,
ignore the contents of fields whose names are in
.IR string .
.
.TP
.BI \-t n
Only require the first
.I n
characters of keys to be given.
.
Initially
.I n
is\~6.
.
.
.\" --------------------------------------------------------------------
.SH ENVIRONMENT
.\" --------------------------------------------------------------------
.
.TP \w'\fBREFER'u+2n
.SB REFER
Default database.
.
.
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
.
.Tp \w'\fB@DEFAULT_INDEX@'u+2n
.B @DEFAULT_INDEX@
Default database to be used if the
.SB REFER
environment variable is not set.
.
.TP
.IB filename @INDEX_SUFFIX@
Index files.
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.BR @g@refer (@MAN1EXT@),
.BR @g@lookbib (@MAN1EXT@),
.BR @g@indxbib (@MAN1EXT@)
.
.
.\" --------------------------------------------------------------------
.SH COPYING
.\" --------------------------------------------------------------------
.co
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
