/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.List;

public class ArcInfo
extends Info {
    String name;
    String javaName;
    ArcProto.Function func = ArcProto.Function.UNKNOWN;
    boolean fixAng;
    boolean wipes;
    boolean noExtend;
    boolean curvable;
    boolean special;
    boolean notUsed;
    boolean skipSizeInPalette;
    boolean slidable;
    int angInc;
    double antennaRatio;
    double widthOffset;
    ArcProto generated;
    LayerDetails[] arcDetails;
    private static Info.SpecialTextDescr[] arcTextTable = new Info.SpecialTextDescr[]{new Info.SpecialTextDescr(0.0, 21.0, 9), new Info.SpecialTextDescr(0.0, 18.0, 11), new Info.SpecialTextDescr(0.0, 15.0, 12), new Info.SpecialTextDescr(0.0, 12.0, 13), new Info.SpecialTextDescr(0.0, 9.0, 23), new Info.SpecialTextDescr(0.0, 6.0, 40), new Info.SpecialTextDescr(0.0, 3.0, 62)};

    ArcInfo() {
    }

    public static Cell[] getArcCells(Library lib) {
        Library[] oneLib = new Library[]{lib};
        return ArcInfo.findCellSequence(oneLib, "arc-", ARCSEQUENCE_KEY);
    }

    void generate(Cell np, EditingPreferences ep) {
        ArcInfo.loadTableEntry(arcTextTable, 9, (Object)this.func);
        ArcInfo.loadTableEntry(arcTextTable, 11, this.fixAng);
        ArcInfo.loadTableEntry(arcTextTable, 12, this.wipes);
        ArcInfo.loadTableEntry(arcTextTable, 13, this.noExtend);
        ArcInfo.loadTableEntry(arcTextTable, 23, new Integer(this.angInc));
        ArcInfo.loadTableEntry(arcTextTable, 40, new Double(this.antennaRatio));
        ArcInfo.loadTableEntry(arcTextTable, 62, new Double(this.widthOffset));
        ArcInfo.createSpecialText(np, arcTextTable, ep);
    }

    static ArcInfo parseCell(Cell np) {
        ArcInfo aIn = new ArcInfo();
        aIn.name = np.getName().substring(4);
        Iterator<NodeInst> it = np.getNodes();
        block9: while (it.hasNext()) {
            NodeInst ni = it.next();
            Variable var = ni.getVar(OPTION_KEY);
            if (var == null) continue;
            String str = ArcInfo.getValueOnNode(ni);
            block0 : switch ((Integer)var.getObject()) {
                case 9: {
                    aIn.func = ArcProto.Function.UNKNOWN;
                    List<ArcProto.Function> allFuncs = ArcProto.Function.getFunctions();
                    for (ArcProto.Function fun : allFuncs) {
                        if (!fun.toString().equalsIgnoreCase(str)) continue;
                        aIn.func = fun;
                        break block0;
                    }
                    continue block9;
                }
                case 23: {
                    aIn.angInc = TextUtils.atoi(str);
                    break;
                }
                case 11: {
                    aIn.fixAng = str.equalsIgnoreCase("yes");
                    break;
                }
                case 12: {
                    aIn.wipes = str.equalsIgnoreCase("yes");
                    break;
                }
                case 13: {
                    aIn.noExtend = str.equalsIgnoreCase("no");
                    break;
                }
                case 40: {
                    aIn.antennaRatio = TextUtils.atof(str);
                    break;
                }
                case 62: {
                    aIn.widthOffset = TextUtils.atof(str);
                }
            }
        }
        return aIn;
    }

    static void compactCell(Cell cell) {
        RectangularShape nonSpecBounds = null;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.getProto() == Generic.tech().cellCenterNode) continue;
            boolean special = false;
            for (int i = 0; i < arcTextTable.length; ++i) {
                if (ArcInfo.arcTextTable[i].ni != ni) continue;
                special = true;
            }
            if (special) continue;
            ERectangle bounds = ni.getBounds();
            if (nonSpecBounds == null) {
                nonSpecBounds = new Rectangle2D.Double(((RectangularShape)bounds).getMinX(), ((RectangularShape)bounds).getMinY(), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
                continue;
            }
            Rectangle2D.union((Rectangle2D)nonSpecBounds, bounds, (Rectangle2D)nonSpecBounds);
        }
        if (nonSpecBounds != null) {
            double xOff = -nonSpecBounds.getCenterX();
            double yOff = -nonSpecBounds.getMaxY();
            if (xOff != 0.0 || yOff != 0.0) {
                Iterator<NodeInst> it2 = cell.getNodes();
                while (it2.hasNext()) {
                    NodeInst ni = it2.next();
                    if (ni.getProto() == Generic.tech().cellCenterNode) continue;
                    boolean special = false;
                    for (int i = 0; i < arcTextTable.length; ++i) {
                        if (ArcInfo.arcTextTable[i].ni != ni) continue;
                        special = true;
                    }
                    if (special) continue;
                    ni.move(xOff, yOff);
                }
            }
        }
    }

    static class LayerDetails {
        LayerInfo layer;
        double width;
        Poly.Type style;

        LayerDetails() {
        }
    }
}

