/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.ArtworkLook;
import com.sun.electric.tool.user.dialogs.Attributes;
import com.sun.electric.tool.user.dialogs.AttributesTable;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GetInfoNode
extends EModelessDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoNode theDialog = null;
    private NodeInst shownNode = null;
    private PortProto shownPort = null;
    private double initialXPos;
    private double initialYPos;
    private String initialXSize;
    private String initialYSize;
    private boolean initialMirrorX;
    private boolean initialMirrorY;
    private int initialRotation;
    private int initialPopupIndex;
    private boolean initialEasyToSelect;
    private boolean initialInvisibleOutsideCell;
    private boolean initialLocked;
    private boolean initialExpansion;
    private String initialName;
    private String initialTextField1;
    private String initialTextField2;
    private String initialPopupEntry;
    private boolean textField1Visible;
    private boolean textField2Visible;
    private boolean popupVisible;
    private DefaultListModel listModel;
    private JList list;
    private List<AttributesTable.AttValPair> allAttributes;
    private List<ArcInst> portObjects;
    private boolean bigger;
    private boolean scalableTrans;
    private boolean multiCutNode;
    private boolean carbonNanotubeNode;
    private boolean swapXY;
    private AttributesTable attributesTable;
    private EditWindow wnd;
    private static Preferences prefs = Preferences.userNodeForPackage(GetInfoNode.class);
    private JButton apply;
    private JRadioButton attributes;
    private JRadioButton busMembers;
    private JButton cancel;
    private JButton colorAndPattern;
    private JCheckBox easyToSelect;
    private JButton editParameters;
    private JRadioButton expanded;
    private ButtonGroup expansion;
    private JCheckBox invisibleOutsideCell;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JScrollPane listPane;
    private JCheckBox locked;
    private JCheckBox mirrorX;
    private JCheckBox mirrorY;
    private JButton more;
    private JPanel moreStuffBottom;
    private JPanel moreStuffTop;
    private JTextField name;
    private JButton ok;
    private JComboBox popup;
    private JLabel popupLabel;
    private JRadioButton ports;
    private JTextField rotation;
    private JButton see;
    private ButtonGroup selection;
    private JButton showAllButton;
    private JTextField textField1;
    private JLabel textField1Label;
    private JTextField textField2;
    private JLabel textField2Label;
    private JTextField type;
    private JRadioButton unexpanded;
    private JTextField xPos;
    private JTextField xSize;
    private JLabel xsizeLabel;
    private JTextField yPos;
    private JTextField ySize;
    private JLabel ysizeLabel;

    public static void showDialog() {
        if (ClientOS.isOSLinux()) {
            if (theDialog != null) {
                theDialog.dispose();
            }
            theDialog = null;
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new GetInfoNode(jf);
        }
        theDialog.loadInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
            theDialog.ensureProperSize();
            theDialog.setVisible(true);
            GetInfoNode.theDialog.name.requestFocus();
        }
        theDialog.toFront();
    }

    @Override
    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo();
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo();
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (e.objectChanged(this.shownNode) || this.shownPort instanceof Export && e.objectChanged((Export)this.shownPort)) {
            this.loadInfo();
        }
    }

    private GetInfoNode(Frame parent) {
        super(parent);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        UserInterfaceMain.addDatabaseChangeListener(this);
        Highlighter.addHighlightListener(this);
        EDialog.makeTextFieldSelectAllOnTab(this.name);
        EDialog.makeTextFieldSelectAllOnTab(this.rotation);
        EDialog.makeTextFieldSelectAllOnTab(this.textField1);
        EDialog.makeTextFieldSelectAllOnTab(this.textField2);
        EDialog.makeTextFieldSelectAllOnTab(this.xPos);
        EDialog.makeTextFieldSelectAllOnTab(this.xSize);
        EDialog.makeTextFieldSelectAllOnTab(this.yPos);
        EDialog.makeTextFieldSelectAllOnTab(this.ySize);
        this.popupVisible = true;
        this.textField2Visible = true;
        this.textField1Visible = true;
        this.type.setEditable(false);
        this.type.setBorder(null);
        this.type.setForeground(UIManager.getColor("Label.foreground"));
        this.type.setFont(UIManager.getFont("Label.font"));
        this.bigger = prefs.getBoolean("GetInfoNode-bigger", false);
        int buttonSelected = prefs.getInt("GetInfoNode-buttonSelected", 0);
        if (!this.bigger) {
            this.getContentPane().remove(this.moreStuffTop);
            this.getContentPane().remove(this.listPane);
            this.getContentPane().remove(this.moreStuffBottom);
            this.more.setText("More");
            this.pack();
        } else {
            this.more.setText("Less");
        }
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.listPane.setViewportView(this.list);
        this.allAttributes = new ArrayList<AttributesTable.AttValPair>();
        this.portObjects = new ArrayList<ArcInst>();
        this.attributesTable = new AttributesTable(null, true, false, false);
        switch (buttonSelected) {
            case 0: {
                this.ports.setSelected(true);
                break;
            }
            case 1: {
                this.attributes.setSelected(true);
                break;
            }
            case 2: {
                this.busMembers.setSelected(true);
            }
        }
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    protected void loadInfo() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GetInfoNode.this.doLoadInfo();
                }
            });
            return;
        }
        this.doLoadInfo();
    }

    private void doLoadInfo() {
        PrimitiveNode pnp;
        Variable var;
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd != null) {
            this.wnd = curWnd;
        }
        NodeInst ni = null;
        PortProto pp = null;
        int nodeCount = 0;
        if (this.wnd != null) {
            for (Highlight h : this.wnd.getHighlighter().getHighlights()) {
                if (!h.isHighlightEOBJ()) continue;
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    pp = ((PortInst)eobj).getPortProto();
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (!(eobj instanceof NodeInst)) continue;
                ni = (NodeInst)eobj;
                ++nodeCount;
            }
        }
        this.showAllButton.setEnabled(false);
        if (nodeCount > 1) {
            ni = null;
        }
        if (ni == null) {
            if (this.shownNode != null) {
                this.type.setText("");
                this.name.setEditable(false);
                this.name.setText("");
                this.xSize.setEditable(false);
                this.xSize.setText("");
                this.ySize.setEditable(false);
                this.ySize.setText("");
                this.xPos.setEditable(false);
                this.xPos.setText("");
                this.yPos.setEditable(false);
                this.yPos.setText("");
                this.rotation.setEditable(false);
                this.rotation.setText("");
                this.mirrorX.setEnabled(false);
                this.mirrorX.setSelected(false);
                this.mirrorY.setEnabled(false);
                this.mirrorY.setSelected(false);
                this.apply.setEnabled(false);
                this.expanded.setEnabled(false);
                this.unexpanded.setEnabled(false);
                this.easyToSelect.setEnabled(false);
                this.easyToSelect.setSelected(false);
                this.invisibleOutsideCell.setEnabled(false);
                this.invisibleOutsideCell.setSelected(false);
                this.textField1Label.setText("");
                this.textField1.setText("");
                this.textField1.setEditable(false);
                this.textField2Label.setText("");
                this.textField2.setText("");
                this.textField2.setEditable(false);
                this.popupLabel.setText("");
                this.popup.removeAllItems();
                this.popup.setEnabled(false);
                this.ports.setEnabled(false);
                this.attributes.setEnabled(false);
                this.attributesTable.setElectricObject(null);
                this.attributesTable.setEnabled(false);
                this.busMembers.setEnabled(false);
                this.listPane.setEnabled(false);
                this.listModel.clear();
                this.locked.setEnabled(false);
                this.locked.setSelected(false);
                this.see.setEnabled(false);
                this.editParameters.setEnabled(false);
                this.colorAndPattern.setEnabled(false);
                this.shownNode = null;
                this.shownPort = null;
            }
            return;
        }
        this.shownNode = ni;
        this.shownPort = pp;
        EDialog.focusClearOnTextField(this.name);
        NodeProto np = ni.getProto();
        Technology tech = ni.getParent().getTechnology();
        this.name.setEditable(true);
        boolean sizeEditable = true;
        this.xPos.setEditable(true);
        this.yPos.setEditable(true);
        this.rotation.setEditable(true);
        this.mirrorX.setEnabled(true);
        this.mirrorY.setEnabled(true);
        this.apply.setEnabled(true);
        this.initialName = ni.getName();
        this.initialXPos = ni.getAnchorCenterX();
        this.initialYPos = ni.getAnchorCenterY();
        double initXSize = ni.getLambdaBaseXSize();
        double initYSize = ni.getLambdaBaseYSize();
        this.initialRotation = ni.getAngle();
        this.swapXY = false;
        if (this.initialRotation == 900 || this.initialRotation == 2700) {
            this.swapXY = true;
        }
        String protoName = np.describe(false);
        String extra = ni.getTechSpecificAddition();
        if (extra.length() > 0) {
            protoName = protoName + " (" + extra + ")";
        }
        this.type.setText(protoName);
        this.name.setText(this.initialName);
        this.xPos.setText(TextUtils.formatDistance(this.initialXPos, tech));
        this.yPos.setText(TextUtils.formatDistance(this.initialYPos, tech));
        boolean realMirrorX = ni.isXMirrored();
        boolean realMirrorY = ni.isYMirrored();
        if (this.swapXY) {
            this.xSize.setText(TextUtils.formatDistance(initYSize, tech));
            this.ySize.setText(TextUtils.formatDistance(initXSize, tech));
            this.initialMirrorX = realMirrorY;
            this.initialMirrorY = realMirrorX;
        } else {
            this.xSize.setText(TextUtils.formatDistance(initXSize, tech));
            this.ySize.setText(TextUtils.formatDistance(initYSize, tech));
            this.initialMirrorX = realMirrorX;
            this.initialMirrorY = realMirrorY;
        }
        this.initialXSize = this.xSize.getText();
        this.initialYSize = this.ySize.getText();
        this.mirrorX.setSelected(this.initialMirrorX);
        this.mirrorY.setSelected(this.initialMirrorY);
        this.rotation.setText(TextUtils.formatDouble((double)this.initialRotation / 10.0));
        PrimitiveNodeSize npSize = ni.getPrimitiveDependentNodeSize(null);
        if (npSize != null) {
            this.xsizeLabel.setText("Width:");
            this.xsizeLabel.setDisplayedMnemonic('w');
            this.ysizeLabel.setText("Length:");
            this.ysizeLabel.setDisplayedMnemonic('l');
            String finalW = npSize.getWidthInString();
            String finalH = npSize.getLengthInString();
            this.xSize.setText(finalW);
            this.ySize.setText(finalH);
            this.initialXSize = this.xSize.getText();
            this.initialYSize = this.ySize.getText();
        } else {
            this.xsizeLabel.setText("X size:");
            this.xsizeLabel.setDisplayedMnemonic('s');
            this.ysizeLabel.setText("Y size:");
            this.ysizeLabel.setDisplayedMnemonic('z');
        }
        this.easyToSelect.setEnabled(true);
        this.invisibleOutsideCell.setEnabled(true);
        this.ports.setEnabled(true);
        this.attributes.setEnabled(true);
        this.attributesTable.setEnabled(true);
        this.busMembers.setEnabled(true);
        this.listPane.setEnabled(true);
        this.locked.setEnabled(true);
        this.editParameters.setEnabled(false);
        if (ni.isCellInstance()) {
            this.editParameters.setEnabled(true);
        }
        this.colorAndPattern.setEnabled(ni.getProto().getTechnology() == Artwork.tech());
        this.allAttributes.clear();
        Iterator<Variable> it = ni.getParametersAndVariables();
        while (it.hasNext()) {
            Variable var2 = it.next();
            String name = var2.getKey().getName();
            if (!name.startsWith("ATTR_")) continue;
            AttributesTable.AttValPair avp = new AttributesTable.AttValPair();
            avp.key = var2.getKey();
            avp.trueName = var2.getTrueName();
            avp.value = var2.getObject().toString();
            avp.code = var2.isCode();
            this.allAttributes.add(avp);
        }
        boolean hasAttributes = this.allAttributes.size() != 0 || ni.getParameters().hasNext();
        this.attributes.setEnabled(hasAttributes);
        this.attributesTable.setEnabled(hasAttributes);
        this.attributesTable.setElectricObject(ni);
        if (this.attributes.isSelected() && !hasAttributes) {
            this.ports.setSelected(true);
        }
        int busWidth = 1;
        Netlist nl = this.shownNode.getParent().getNetlist();
        if (nl != null && this.shownPort != null && this.shownPort instanceof Export) {
            busWidth = nl.getBusWidth((Export)this.shownPort);
        }
        if (busWidth <= 1) {
            if (this.busMembers.isSelected()) {
                this.ports.setSelected(true);
            }
            this.busMembers.setEnabled(false);
        }
        this.showProperList(false);
        this.textField1Label.setText("");
        this.textField1.setText("");
        this.textField1.setEditable(false);
        this.textField2Label.setText("");
        this.textField2.setText("");
        this.textField2.setEditable(false);
        this.popupLabel.setText("");
        this.popup.removeAllItems();
        this.popup.setEnabled(false);
        this.initialTextField2 = null;
        this.initialTextField1 = null;
        boolean lengthEditable = false;
        if (ni.isSerpentineTransistor()) {
            lengthEditable = true;
        }
        if (np instanceof Cell) {
            this.expanded.setEnabled(true);
            this.unexpanded.setEnabled(true);
            this.initialExpansion = ni.isExpanded();
            if (this.initialExpansion) {
                this.expanded.setSelected(true);
            } else {
                this.unexpanded.setSelected(true);
            }
            sizeEditable = false;
        } else {
            this.expanded.setEnabled(false);
            this.unexpanded.setEnabled(false);
        }
        if (sizeEditable) {
            this.xSize.setEditable(true);
            this.ySize.setEditable(true);
        } else {
            this.xSize.setEditable(false);
            this.ySize.setEditable(lengthEditable);
        }
        this.initialInvisibleOutsideCell = ni.isVisInside();
        this.invisibleOutsideCell.setSelected(this.initialInvisibleOutsideCell);
        this.initialEasyToSelect = !ni.isHardSelect();
        this.easyToSelect.setSelected(this.initialEasyToSelect);
        if (np instanceof Cell && !User.isEasySelectionOfCellInstances()) {
            this.easyToSelect.setEnabled(false);
        }
        this.initialLocked = ni.isLocked();
        this.locked.setSelected(this.initialLocked);
        PrimitiveNode.Function fun = ni.getFunction();
        if (!(np != Schematics.tech().transistorNode && np != Schematics.tech().transistor4Node || ni.getFunction().isFET())) {
            this.textField1.setEditable(true);
            this.textField1Label.setText("Area:");
            var = ni.getVar(Schematics.ATTR_AREA);
            this.textField1.setText(var.getPureValue(-1));
        }
        this.multiCutNode = false;
        if (!ni.isCellInstance()) {
            pnp = (PrimitiveNode)np;
            this.multiCutNode = pnp.isMulticut();
        }
        if (this.multiCutNode) {
            this.popupLabel.setText("Cut placement:");
            this.popup.setEnabled(true);
            this.popup.addItem("In node center");
            this.popup.addItem("At node edges");
            this.popup.addItem("In node corner");
            this.initialPopupIndex = ni.getVarValue(Technology.NodeLayer.CUT_ALIGNMENT, Integer.class, new Integer(0));
            this.popup.setSelectedIndex(this.initialPopupIndex);
            this.textField1Label.setText("Cut spacing:");
            this.textField1.setEditable(true);
            var = ni.getVar(Technology.NodeLayer.CUT_SPACING);
            if (var == null) {
                this.textField1.setText("DEFAULT");
            } else {
                this.textField1.setText(var.getPureValue(-1));
            }
        }
        this.carbonNanotubeNode = false;
        if (!(ni.isCellInstance() || (pnp = (PrimitiveNode)np).getFunction() != PrimitiveNode.Function.TRANMOSCN && pnp.getFunction() != PrimitiveNode.Function.TRAPMOSCN)) {
            Technology.NodeLayer[] primLayers;
            for (Technology.NodeLayer nodeLayer : primLayers = pnp.getNodeLayers()) {
                if (!nodeLayer.getLayer().isCarbonNanotubeLayer()) continue;
                this.carbonNanotubeNode = true;
            }
        }
        if (this.carbonNanotubeNode) {
            this.textField1Label.setText("Number of Carbon Nanotubes:");
            this.textField1.setEditable(true);
            var = ni.getVar(Technology.NodeLayer.CARBON_NANOTUBE_COUNT);
            if (var == null) {
                this.textField1.setText("DEFAULT");
            } else {
                this.textField1.setText(var.getPureValue(-1));
            }
            this.textField2Label.setText("Spacing of Carbon Nanotubes:");
            this.textField2.setEditable(true);
            var = ni.getVar(Technology.NodeLayer.CARBON_NANOTUBE_PITCH);
            if (var == null) {
                this.textField2.setText("DEFAULT");
            } else {
                this.textField2.setText(var.getPureValue(-1));
            }
        }
        this.scalableTrans = false;
        if (!ni.isCellInstance() && np.getTechnology() == Technology.getMocmosTechnology() && (np.getName().equals("P-Transistor-Scalable") || np.getName().equals("N-Transistor-Scalable"))) {
            this.scalableTrans = true;
        }
        if (this.scalableTrans) {
            this.popupLabel.setText("Contacts:");
            this.popup.addItem("Top & Bottom / normal spacing");
            this.popup.addItem("Top & Bottom / half-unit closer");
            this.popup.addItem("Only Bottom / normal spacing");
            this.popup.addItem("Only Bottom / half-unit closer");
            this.popup.addItem("None");
            String pt = ni.getVarValue(Technology.TRANS_CONTACT, String.class);
            int numContacts = 2;
            boolean insetContacts = false;
            if (pt != null) {
                for (int i = 0; i < pt.length(); ++i) {
                    char chr = pt.charAt(i);
                    if (chr == '0' || chr == '1' || chr == '2') {
                        numContacts = chr - 48;
                        continue;
                    }
                    if (chr != 'i' && chr != 'I') continue;
                    insetContacts = true;
                }
            }
            this.initialPopupIndex = (2 - numContacts) * 2;
            if (insetContacts && numContacts > 0) {
                ++this.initialPopupIndex;
            }
            this.popup.setSelectedIndex(this.initialPopupIndex);
            this.popup.setEnabled(true);
            this.textField1Label.setText("Width:");
            Variable var3 = ni.getVar(Schematics.ATTR_WIDTH);
            double width = ni.getLambdaBaseXSize();
            if (var3 != null) {
                width = TextUtils.atof(var3.getPureValue(-1));
            }
            this.initialTextField1 = TextUtils.formatDistance(width, tech);
            this.textField1.setEditable(true);
            this.textField1.setText(this.initialTextField1);
        }
        if (fun.isResistor()) {
            if (fun == PrimitiveNode.Function.RESPPOLY || fun == PrimitiveNode.Function.RESNPOLY || fun == PrimitiveNode.Function.RESPNSPOLY || fun == PrimitiveNode.Function.RESNNSPOLY) {
                this.textField1Label.setText("Poly resistance:");
            } else if (fun == PrimitiveNode.Function.RESHIRESPOLY2) {
                this.textField1Label.setText("Hi-Res Poly2 resistance:");
            } else if (fun == PrimitiveNode.Function.RESPWELL || fun == PrimitiveNode.Function.RESNWELL) {
                this.textField1Label.setText("Well resistance:");
            } else if (fun == PrimitiveNode.Function.RESPACTIVE || fun == PrimitiveNode.Function.RESNACTIVE) {
                this.textField1Label.setText("Active resistance:");
            } else {
                this.textField1Label.setText("Resistance:");
            }
            var = ni.getVar(Schematics.SCHEM_RESISTANCE);
            this.initialTextField1 = var == null ? "0" : new String(var.getObject().toString());
            this.textField1.setEditable(true);
            this.textField1.setText(this.initialTextField1);
        }
        if (fun.isCapacitor()) {
            if (fun == PrimitiveNode.Function.ECAPAC) {
                this.textField1Label.setText("Electrolytic cap:");
            } else if (fun == PrimitiveNode.Function.POLY2CAPAC) {
                this.textField1Label.setText("Poly2 cap:");
            } else {
                this.textField1Label.setText("Capacitance:");
            }
            var = ni.getVar(Schematics.SCHEM_CAPACITANCE);
            this.initialTextField1 = var == null ? "0" : new String(var.getObject().toString());
            this.textField1.setEditable(true);
            this.textField1.setText(this.initialTextField1);
        }
        if (fun == PrimitiveNode.Function.INDUCT) {
            this.textField1Label.setText("Inductance:");
            var = ni.getVar(Schematics.SCHEM_INDUCTANCE);
            this.initialTextField1 = var == null ? "0" : new String(var.getObject().toString());
            this.textField1.setEditable(true);
            this.textField1.setText(this.initialTextField1);
        }
        if (np == Schematics.tech().bboxNode) {
            this.textField1Label.setText("Function:");
            var = ni.getVar(Schematics.SCHEM_FUNCTION);
            this.initialTextField1 = var == null ? "" : new String(var.getObject().toString());
            this.textField1.setEditable(true);
            this.textField1.setText(this.initialTextField1);
        }
        if (np == Schematics.tech().globalNode) {
            this.textField1Label.setText("Global name:");
            var = ni.getVar(Schematics.SCHEM_GLOBAL_NAME);
            this.initialTextField1 = var == null ? "" : new String(var.getObject().toString());
            this.textField1.setEditable(true);
            this.textField1.setText(this.initialTextField1);
            this.popupLabel.setText("Characteristics:");
            List<PortCharacteristic> characteristics = PortCharacteristic.getOrderedCharacteristics();
            for (PortCharacteristic ch : characteristics) {
                this.popup.addItem(ch.getName());
            }
            PortCharacteristic ch = PortCharacteristic.findCharacteristic(ni.getTechSpecific());
            this.initialPopupEntry = ch.getName();
            this.popup.setSelectedItem(this.initialPopupEntry);
            this.popup.setEnabled(true);
        }
        if (ni.getParent().isInTechnologyLibrary()) {
            this.popupLabel.setText("Tech. editor:");
            this.popup.addItem(Manipulate.describeNodeMeaning(ni));
        }
        if (np == Artwork.tech().circleNode || np == Artwork.tech().thickCircleNode) {
            double[] arcData = ni.getArcDegrees();
            double start = DBMath.round(arcData[0] * 180.0 / Math.PI);
            double curvature = DBMath.round(arcData[1] * 180.0 / Math.PI);
            if (start != 0.0) {
                this.textField1Label.setText("Offset angle / Degrees of circle:");
                this.initialTextField1 = new String(start + " / " + curvature);
            } else {
                this.textField1Label.setText("Degrees of circle:");
                this.initialTextField1 = curvature == 0.0 ? "360" : new String(Double.toString(curvature));
            }
            this.textField1.setEditable(true);
            this.textField1.setText(this.initialTextField1);
        }
        boolean repack = this.textField1.isEditable() == this.textField1Visible || this.textField2.isEditable() == this.textField2Visible || this.popup.isEnabled() == this.popupVisible;
        this.textField1Visible = this.textField1.isEditable();
        if (this.textField1Visible) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            this.moreStuffTop.add((Component)this.textField1Label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.moreStuffTop.add((Component)this.textField1, gbc);
        } else {
            this.moreStuffTop.remove(this.textField1Label);
            this.moreStuffTop.remove(this.textField1);
        }
        this.textField2Visible = this.textField2.isEditable();
        if (this.textField2Visible) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.anchor = 17;
            this.moreStuffTop.add((Component)this.textField2Label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.moreStuffTop.add((Component)this.textField2, gbc);
        } else {
            this.moreStuffTop.remove(this.textField2Label);
            this.moreStuffTop.remove(this.textField2);
        }
        this.popupVisible = this.popup.isEnabled();
        if (this.popupVisible) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.fill = 2;
            gbc.anchor = 17;
            this.moreStuffTop.add((Component)this.popupLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.moreStuffTop.add((Component)this.popup, gbc);
        } else {
            this.moreStuffTop.remove(this.popupLabel);
            this.moreStuffTop.remove(this.popup);
        }
        EDialog.focusOnTextField(this.name);
        if (repack) {
            this.pack();
        }
    }

    private void showProperList(boolean showAll) {
        this.listModel.clear();
        this.portObjects.clear();
        if (this.ports.isSelected()) {
            this.listPane.setViewportView(this.list);
            NodeProto np = this.shownNode.getProto();
            ArrayList<String> portMessages = new ArrayList<String>();
            int selectedLine = 0;
            int total = 0;
            Iterator<PortInst> it = this.shownNode.getPortInsts();
            while (it.hasNext()) {
                Variable var;
                PortInst pi = it.next();
                if (!showAll && total++ > 100) {
                    int numLeft = 1;
                    while (it.hasNext()) {
                        pi = it.next();
                        ++numLeft;
                    }
                    String description = "*** Plus " + numLeft + " more ports.  Use 'Show All' to see them.";
                    portMessages.add(description);
                    this.portObjects.add(null);
                    this.showAllButton.setEnabled(true);
                    break;
                }
                PortProto pp = pi.getPortProto();
                PortCharacteristic ch = pp.getCharacteristic();
                String description = ch == PortCharacteristic.UNKNOWN ? "Port " : ch.getName() + " port ";
                description = description + pp.getName();
                if (pp == this.shownPort) {
                    selectedLine = portMessages.size();
                    description = description + " (Highlighted)";
                }
                description = description + " connects to";
                boolean noPreferred = true;
                if (pp instanceof Export && (var = ((Export)pp).getVar(Export.EXPORT_PREFERRED_ARCS)) != null) {
                    String[] arcNames = (String[])var.getObject();
                    for (int j = 0; j < arcNames.length; ++j) {
                        if (j > 0) {
                            description = description + ",";
                        }
                        description = description + " " + arcNames[j];
                    }
                    noPreferred = false;
                }
                if (noPreferred) {
                    ArcProto[] connList = pp.getBasePort().getConnections();
                    int count2 = 0;
                    for (int i = 0; i < connList.length; ++i) {
                        ArcProto ap = connList[i];
                        if ((np instanceof Cell || np.getTechnology() != Generic.tech()) && ap.getTechnology() == Generic.tech()) continue;
                        if (count2 > 0) {
                            description = description + ",";
                        }
                        description = description + " " + ap.getName();
                        ++count2;
                    }
                }
                boolean moreInfo = false;
                if (pp == this.shownPort) {
                    moreInfo = true;
                }
                Iterator<Connection> aIt = this.shownNode.getConnections();
                while (aIt.hasNext()) {
                    Connection con = aIt.next();
                    if (con.getPortInst() != pi) continue;
                    moreInfo = true;
                    break;
                }
                Iterator<Export> eIt = this.shownNode.getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    if (e.getOriginalPort() != pi) continue;
                    moreInfo = true;
                    break;
                }
                if (moreInfo) {
                    description = description + ":";
                }
                portMessages.add(description);
                this.portObjects.add(null);
                aIt = this.shownNode.getConnections();
                while (aIt.hasNext()) {
                    Connection con = aIt.next();
                    if (con.getPortInst() != pi) continue;
                    ArcInst ai = con.getArc();
                    description = "  Connected at (" + con.getLocation().getX() + "," + con.getLocation().getY() + ") to " + ai;
                    portMessages.add(description);
                    this.portObjects.add(ai);
                }
                eIt = this.shownNode.getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    if (e.getOriginalPort() != pi) continue;
                    description = "  Available as " + e.getCharacteristic().getName() + " export '" + e.getName() + "'";
                    portMessages.add(description);
                    this.portObjects.add(null);
                }
            }
            this.see.setEnabled(true);
            this.list.setListData(portMessages.toArray());
            this.list.setSelectedIndex(selectedLine);
            this.list.ensureIndexIsVisible(selectedLine);
        }
        if (this.busMembers.isSelected()) {
            Netlist nl = this.shownNode.getParent().getNetlist();
            int busWidth = nl.getBusWidth((Export)this.shownPort);
            ArrayList<String> busMessages = new ArrayList<String>();
            for (int i = 0; i < busWidth; ++i) {
                if (!showAll && i++ > 100) {
                    int numLeft = busWidth - 100;
                    String description = "*** Plus " + numLeft + " more bus members.  Use 'Show All' to see them.";
                    busMessages.add(description);
                    this.showAllButton.setEnabled(true);
                    break;
                }
                Network net = nl.getNetwork(this.shownNode, this.shownPort, i);
                String netDescr = "?";
                if (net != null) {
                    netDescr = net.describe(false);
                }
                busMessages.add(i + ": " + netDescr);
            }
            this.listPane.setViewportView(this.list);
            this.list.setListData(busMessages.toArray());
        }
        if (this.attributes.isSelected()) {
            this.listPane.setViewportView(this.attributesTable);
        }
    }

    private void initComponents() {
        this.expansion = new ButtonGroup();
        this.selection = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.name = new JTextField();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel3 = new JLabel();
        this.xsizeLabel = new JLabel();
        this.xSize = new JTextField();
        this.ysizeLabel = new JLabel();
        this.ySize = new JTextField();
        this.jLabel6 = new JLabel();
        this.xPos = new JTextField();
        this.jLabel7 = new JLabel();
        this.yPos = new JTextField();
        this.jLabel8 = new JLabel();
        this.rotation = new JTextField();
        this.mirrorX = new JCheckBox();
        this.more = new JButton();
        this.apply = new JButton();
        this.mirrorY = new JCheckBox();
        this.moreStuffTop = new JPanel();
        this.expanded = new JRadioButton();
        this.unexpanded = new JRadioButton();
        this.easyToSelect = new JCheckBox();
        this.invisibleOutsideCell = new JCheckBox();
        this.textField1Label = new JLabel();
        this.textField1 = new JTextField();
        this.popupLabel = new JLabel();
        this.popup = new JComboBox();
        this.ports = new JRadioButton();
        this.attributes = new JRadioButton();
        this.busMembers = new JRadioButton();
        this.showAllButton = new JButton();
        this.textField2Label = new JLabel();
        this.textField2 = new JTextField();
        this.moreStuffBottom = new JPanel();
        this.locked = new JCheckBox();
        this.see = new JButton();
        this.colorAndPattern = new JButton();
        this.editParameters = new JButton();
        this.listPane = new JScrollPane();
        this.type = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Node Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GetInfoNode.this.closeDialog(evt);
            }
        });
        this.jLabel1.setLabelFor(this.type);
        this.jLabel1.setText("Type:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.name.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.name, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel3.setDisplayedMnemonic('n');
        this.jLabel3.setLabelFor(this.name);
        this.jLabel3.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.xsizeLabel.setDisplayedMnemonic('s');
        this.xsizeLabel.setLabelFor(this.xSize);
        this.xsizeLabel.setText("X size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.xsizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xSize, gridBagConstraints);
        this.ysizeLabel.setDisplayedMnemonic('z');
        this.ysizeLabel.setLabelFor(this.ySize);
        this.ysizeLabel.setText("Y size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.ysizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ySize, gridBagConstraints);
        this.jLabel6.setDisplayedMnemonic('x');
        this.jLabel6.setLabelFor(this.xPos);
        this.jLabel6.setText("X position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xPos, gridBagConstraints);
        this.jLabel7.setDisplayedMnemonic('y');
        this.jLabel7.setLabelFor(this.yPos);
        this.jLabel7.setText("Y position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yPos, gridBagConstraints);
        this.jLabel8.setDisplayedMnemonic('r');
        this.jLabel8.setLabelFor(this.rotation);
        this.jLabel8.setText("Rotation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.rotation.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.rotation, gridBagConstraints);
        this.mirrorX.setText("Mirror L-R");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mirrorX, gridBagConstraints);
        this.more.setText("More");
        this.more.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.moreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.more, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.mirrorY.setText("Mirror U-D");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mirrorY, gridBagConstraints);
        this.moreStuffTop.setLayout(new GridBagLayout());
        this.expansion.add(this.expanded);
        this.expanded.setText("Expanded");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.expanded, gridBagConstraints);
        this.expansion.add(this.unexpanded);
        this.unexpanded.setText("Unexpanded");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.unexpanded, gridBagConstraints);
        this.easyToSelect.setText("Easy to Select");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.easyToSelect, gridBagConstraints);
        this.invisibleOutsideCell.setText("Invisible Outside Cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.invisibleOutsideCell, gridBagConstraints);
        this.textField1Label.setLabelFor(this.textField1);
        this.textField1Label.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.moreStuffTop.add((Component)this.textField1Label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.textField1, gridBagConstraints);
        this.popupLabel.setLabelFor(this.popup);
        this.popupLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.moreStuffTop.add((Component)this.popupLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.popup, gridBagConstraints);
        this.selection.add(this.ports);
        this.ports.setText("Ports:");
        this.ports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.portsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.moreStuffTop.add((Component)this.ports, gridBagConstraints);
        this.selection.add(this.attributes);
        this.attributes.setText("Parameters:");
        this.attributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.attributesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.moreStuffTop.add((Component)this.attributes, gridBagConstraints);
        this.selection.add(this.busMembers);
        this.busMembers.setText("Bus Members on Port:");
        this.busMembers.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.busMembers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.busMembersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.moreStuffTop.add((Component)this.busMembers, gridBagConstraints);
        this.showAllButton.setText("Show All");
        this.showAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.showAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.moreStuffTop.add((Component)this.showAllButton, gridBagConstraints);
        this.textField2Label.setLabelFor(this.textField1);
        this.textField2Label.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.moreStuffTop.add((Component)this.textField2Label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.textField2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.moreStuffTop, gridBagConstraints);
        this.moreStuffBottom.setLayout(new GridBagLayout());
        this.locked.setText("Locked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.locked, gridBagConstraints);
        this.see.setText("See");
        this.see.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.seeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.see, gridBagConstraints);
        this.colorAndPattern.setText("Color and Pattern...");
        this.colorAndPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.colorAndPatternActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.colorAndPattern, gridBagConstraints);
        this.editParameters.setText("Edit Parameters");
        this.editParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.editParametersActionPerformed(evt);
            }
        });
        this.moreStuffBottom.add((Component)this.editParameters, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.moreStuffBottom, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(200, 100));
        this.listPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.type, gridBagConstraints);
        this.pack();
    }

    private void showAllButtonActionPerformed(ActionEvent evt) {
        this.showProperList(true);
        this.showAllButton.setEnabled(false);
    }

    private void busMembersActionPerformed(ActionEvent evt) {
        this.showProperList(false);
    }

    private void colorAndPatternActionPerformed(ActionEvent evt) {
        ArtworkLook.showArtworkLookDialog();
    }

    private void moreActionPerformed(ActionEvent evt) {
        boolean bl = this.bigger = !this.bigger;
        if (this.bigger) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.getContentPane().add((Component)this.moreStuffTop, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.getContentPane().add((Component)this.listPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.getContentPane().add((Component)this.moreStuffBottom, gridBagConstraints);
            this.more.setText("Less");
        } else {
            this.getContentPane().remove(this.moreStuffTop);
            this.getContentPane().remove(this.listPane);
            this.getContentPane().remove(this.moreStuffBottom);
            this.more.setText("More");
        }
        this.pack();
    }

    private void seeActionPerformed(ActionEvent evt) {
        if (!this.ports.isSelected()) {
            return;
        }
        int currentIndex = this.list.getSelectedIndex();
        if (currentIndex == -1) {
            return;
        }
        ArcInst ai = this.portObjects.get(currentIndex);
        if (ai == null) {
            return;
        }
        NodeInst ni = this.shownNode;
        if (this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.addElectricObject(ni, ni.getParent());
            highlighter.addElectricObject(ai, ai.getParent());
            highlighter.finished();
        }
    }

    private void attributesActionPerformed(ActionEvent evt) {
        this.showProperList(false);
    }

    private void portsActionPerformed(ActionEvent evt) {
        this.showProperList(false);
    }

    private void applyActionPerformed(ActionEvent evt) {
        if (this.shownNode == null) {
            return;
        }
        Technology tech = this.shownNode.getParent().getTechnology();
        double currentXPos = TextUtils.atof(this.xPos.getText(), new Double(this.initialXPos), AbstractTextDescriptor.Unit.DISTANCE, tech);
        double currentYPos = TextUtils.atof(this.yPos.getText(), new Double(this.initialYPos), AbstractTextDescriptor.Unit.DISTANCE, tech);
        int currentRotation = (int)(TextUtils.atof(this.rotation.getText(), new Double(this.initialRotation)) * 10.0);
        new ChangeNode(this.shownNode, this.initialXPos, currentXPos, this.initialYPos, currentYPos, this.initialXSize, this.xSize.getText(), this.initialYSize, this.ySize.getText(), this.mirrorX.isSelected(), this.mirrorY.isSelected(), currentRotation, this.initialPopupIndex, this.popup.getSelectedIndex(), this.initialEasyToSelect, this.easyToSelect.isSelected(), this.initialInvisibleOutsideCell, this.invisibleOutsideCell.isSelected(), this.initialLocked, this.locked.isSelected(), this.initialExpansion, this.expanded.isSelected(), this.initialName, this.name.getText().trim(), this.initialTextField1, this.textField1.getText(), this.initialTextField2, this.textField2.getText(), this.initialPopupEntry, (String)this.popup.getSelectedItem(), this.bigger, this.scalableTrans, this.multiCutNode, this.carbonNanotubeNode, this.swapXY);
        this.attributesTable.applyChanges();
        this.initialName = this.name.getText().trim();
        this.initialExpansion = this.expanded.isSelected();
        this.initialEasyToSelect = this.easyToSelect.isSelected();
        this.initialInvisibleOutsideCell = this.invisibleOutsideCell.isSelected();
        this.initialLocked = this.locked.isSelected();
        this.initialTextField1 = this.textField1.getText();
        this.initialTextField2 = this.textField2.getText();
        this.initialPopupEntry = (String)this.popup.getSelectedItem();
        this.initialXPos = currentXPos;
        this.initialYPos = currentYPos;
        this.initialXSize = this.xSize.getText();
        this.initialYSize = this.ySize.getText();
        this.initialMirrorX = this.mirrorX.isSelected();
        this.initialMirrorY = this.mirrorY.isSelected();
        this.initialRotation = currentRotation;
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        prefs.putBoolean("GetInfoNode-bigger", this.bigger);
        if (this.ports.isSelected()) {
            prefs.putInt("GetInfoNode-buttonSelected", 0);
        }
        if (this.attributes.isSelected()) {
            prefs.putInt("GetInfoNode-buttonSelected", 1);
        }
        if (this.busMembers.isSelected()) {
            prefs.putInt("GetInfoNode-buttonSelected", 2);
        }
        super.closeDialog();
    }

    private void editParametersActionPerformed(ActionEvent evt) {
        Cell paramOwner;
        if (this.shownNode == null) {
            return;
        }
        if (!this.shownNode.isCellInstance()) {
            return;
        }
        Cell.CellGroup group = ((Cell)this.shownNode.getProto()).getCellGroup();
        if (group != null && (paramOwner = group.getParameterOwner()) != null) {
            WindowFrame.createEditWindow(paramOwner);
            Attributes.showDialog();
        }
    }

    private static class ChangeNode
    extends Job {
        private NodeInst ni;
        private double initialXPos;
        private double initialYPos;
        private double currentXPos;
        private double currentYPos;
        private String initialXSize;
        private String initialYSize;
        private String currentXSize;
        private String currentYSize;
        private boolean currentMirrorX;
        private boolean currentMirrorY;
        private int currentRotation;
        private int initialPopupIndex;
        private int currentPopupIndex;
        private boolean initialEasyToSelect;
        private boolean currentEasyToSelect;
        private boolean initialInvisibleOutsideCell;
        private boolean currentInvisibleOutsideCell;
        private boolean initialLocked;
        private boolean currentLocked;
        private boolean initialExpansion;
        private boolean currentExpansion;
        private String initialName;
        private String currentName;
        private String initialTextField1;
        private String currentTextField1;
        private String initialTextField2;
        private String currentTextField2;
        private String initialPopupEntry;
        private String currentPopupEntry;
        private boolean scalableTrans;
        private boolean multiCutNode;
        private boolean carbonNanotubeNode;
        private boolean swapXY;

        public ChangeNode(NodeInst ni, double initialXPos, double currentXPos, double initialYPos, double currentYPos, String initialXSize, String currentXSize, String initialYSize, String currentYSize, boolean currentMirrorX, boolean currentMirrorY, int currentRotation, int initialPopupIndex, int currentPopupIndex, boolean initialEasyToSelect, boolean currentEasyToSelect, boolean initialInvisibleOutsideCell, boolean currentInvisibleOutsideCell, boolean initialLocked, boolean currentLocked, boolean initialExpansion, boolean currentExpansion, String initialName, String currentName, String initialTextField1, String currentTextField1, String initialTextField2, String currentTextField2, String initialPopupEntry, String currentPopupEntry, boolean bigger, boolean scalableTrans, boolean multiCutNode, boolean carbonNanotubeNode, boolean swapXY) {
            super("Modify Node", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.initialXPos = initialXPos;
            this.currentXPos = currentXPos;
            this.initialYPos = initialYPos;
            this.currentYPos = currentYPos;
            this.initialXSize = initialXSize;
            this.currentXSize = currentXSize;
            this.initialYSize = initialYSize;
            this.currentYSize = currentYSize;
            this.currentMirrorX = currentMirrorX;
            this.currentMirrorY = currentMirrorY;
            this.currentRotation = currentRotation;
            this.initialPopupIndex = initialPopupIndex;
            this.currentPopupIndex = currentPopupIndex;
            this.initialEasyToSelect = initialEasyToSelect;
            this.currentEasyToSelect = currentEasyToSelect;
            this.initialInvisibleOutsideCell = initialInvisibleOutsideCell;
            this.currentInvisibleOutsideCell = currentInvisibleOutsideCell;
            this.initialLocked = initialLocked;
            this.currentLocked = currentLocked;
            this.initialExpansion = initialExpansion;
            this.currentExpansion = currentExpansion;
            this.initialName = initialName;
            this.currentName = currentName;
            this.initialTextField1 = initialTextField1;
            this.currentTextField1 = currentTextField1;
            this.initialTextField2 = initialTextField2;
            this.currentTextField2 = currentTextField2;
            this.initialPopupEntry = initialPopupEntry;
            this.currentPopupEntry = currentPopupEntry;
            this.scalableTrans = scalableTrans;
            this.multiCutNode = multiCutNode;
            this.carbonNanotubeNode = carbonNanotubeNode;
            this.swapXY = swapXY;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Orientation orient;
            double initYSize;
            double initXSize;
            double currYSize;
            double currXSize;
            PrimitiveNode.Function fun;
            EditingPreferences ep = this.getEditingPreferences();
            boolean changed = false;
            NodeProto np = this.ni.getProto();
            Technology tech = this.ni.getParent().getTechnology();
            if (!this.currentName.equals(this.initialName)) {
                if (this.currentName.length() == 0) {
                    this.currentName = null;
                }
                this.ni.setName(this.currentName);
                TextDescriptor td = this.ni.getTextDescriptor(NodeInst.NODE_NAME);
                if (td.getDisplay() != AbstractTextDescriptor.Display.SHOWN) {
                    this.ni.setTextDescriptor(NodeInst.NODE_NAME, td.withDisplay(AbstractTextDescriptor.Display.SHOWN));
                }
                changed = true;
            }
            if (this.currentEasyToSelect != this.initialEasyToSelect) {
                if (this.currentEasyToSelect) {
                    this.ni.clearHardSelect();
                } else {
                    this.ni.setHardSelect();
                }
            }
            if (this.currentInvisibleOutsideCell != this.initialInvisibleOutsideCell) {
                if (this.currentInvisibleOutsideCell) {
                    this.ni.setVisInside();
                } else {
                    this.ni.clearVisInside();
                }
                changed = true;
            }
            if (this.currentLocked != this.initialLocked) {
                if (this.currentLocked) {
                    this.ni.setLocked();
                } else {
                    this.ni.clearLocked();
                }
            }
            if (this.scalableTrans) {
                if (this.currentPopupIndex != this.initialPopupIndex) {
                    int numContacts = 2 - this.currentPopupIndex / 2;
                    boolean inset = (this.currentPopupIndex & 1) != 0;
                    String contactInfo = String.valueOf(numContacts);
                    if (inset) {
                        contactInfo = contactInfo + "i";
                    }
                    this.ni.newVar(Technology.TRANS_CONTACT, (Object)contactInfo, ep);
                }
                if (!this.currentTextField1.equals(this.initialTextField1)) {
                    double width = TextUtils.atofDistance(this.currentTextField1, tech);
                    Variable oldVar = this.ni.getVar(Schematics.ATTR_WIDTH);
                    Variable var = this.ni.updateVar(Schematics.ATTR_WIDTH, new Double(width), ep);
                    if (var != null && oldVar == null) {
                        this.ni.addVar(var.withDisplay(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE));
                    }
                }
            }
            if (this.multiCutNode) {
                if (!this.currentTextField1.equals(this.initialTextField1)) {
                    if (this.currentTextField1.equals("DEFAULT") || this.currentTextField1.length() == 0) {
                        this.ni.delVar(Technology.NodeLayer.CUT_SPACING);
                    } else {
                        this.ni.newVar(Technology.NodeLayer.CUT_SPACING, (Object)new Double(TextUtils.atof(this.currentTextField1)), ep);
                    }
                }
                if (this.currentPopupIndex != this.initialPopupIndex) {
                    if (this.currentPopupIndex != 0) {
                        this.ni.newVar(Technology.NodeLayer.CUT_ALIGNMENT, (Object)this.currentPopupIndex, ep);
                    } else {
                        this.ni.delVar(Technology.NodeLayer.CUT_ALIGNMENT);
                    }
                    changed = true;
                }
            }
            if (this.carbonNanotubeNode) {
                if (!this.currentTextField1.equals(this.initialTextField1)) {
                    if (this.currentTextField1.equals("DEFAULT") || this.currentTextField1.length() == 0) {
                        this.ni.delVar(Technology.NodeLayer.CARBON_NANOTUBE_COUNT);
                    } else {
                        this.ni.newVar(Technology.NodeLayer.CARBON_NANOTUBE_COUNT, (Object)new Integer(TextUtils.atoi(this.currentTextField1)), ep);
                    }
                }
                if (!this.currentTextField2.equals(this.initialTextField2)) {
                    if (this.currentTextField2.equals("DEFAULT") || this.currentTextField2.length() == 0) {
                        this.ni.delVar(Technology.NodeLayer.CARBON_NANOTUBE_PITCH);
                    } else {
                        this.ni.newVar(Technology.NodeLayer.CARBON_NANOTUBE_PITCH, (Object)new Double(TextUtils.atof(this.currentTextField2)), ep);
                    }
                }
            }
            if (!((fun = this.ni.getFunction()) != PrimitiveNode.Function.DIODE && fun != PrimitiveNode.Function.DIODEZ || this.currentTextField1.equals(this.initialTextField1))) {
                Variable var = this.ni.updateVarText(Schematics.SCHEM_DIODE, this.currentTextField1, ep);
                if (var != null && !var.isDisplay()) {
                    this.ni.addVar(var.withDisplay(true));
                }
                changed = true;
            }
            if (fun.isResistor() && !this.currentTextField1.equals(this.initialTextField1)) {
                Variable var = this.ni.updateVarText(Schematics.SCHEM_RESISTANCE, this.currentTextField1, ep);
                if (var != null && !var.isDisplay()) {
                    this.ni.addVar(var.withDisplay(true));
                }
                changed = true;
            }
            if (fun.isCapacitor() && !this.currentTextField1.equals(this.initialTextField1)) {
                Variable var = this.ni.updateVarText(Schematics.SCHEM_CAPACITANCE, this.currentTextField1, ep);
                if (var != null && !var.isDisplay()) {
                    this.ni.addVar(var.withDisplay(true));
                }
                changed = true;
            }
            if (fun == PrimitiveNode.Function.INDUCT && !this.currentTextField1.equals(this.initialTextField1)) {
                Variable var = this.ni.updateVarText(Schematics.SCHEM_INDUCTANCE, this.currentTextField1, ep);
                if (var != null && !var.isDisplay()) {
                    this.ni.addVar(var.withDisplay(true));
                }
                changed = true;
            }
            if (np == Schematics.tech().bboxNode && !this.currentTextField1.equals(this.initialTextField1)) {
                Variable var = this.ni.updateVarText(Schematics.SCHEM_FUNCTION, this.currentTextField1, ep);
                if (var != null && !var.isDisplay()) {
                    this.ni.addVar(var.withDisplay(true));
                }
                changed = true;
            }
            if (np == Schematics.tech().globalNode) {
                if (!this.currentTextField1.equals(this.initialTextField1)) {
                    Variable var = this.ni.updateVarText(Schematics.SCHEM_GLOBAL_NAME, this.currentTextField1, ep);
                    if (var != null && !var.isDisplay()) {
                        this.ni.addVar(var.withDisplay(true));
                    }
                    changed = true;
                }
                if (!this.currentPopupEntry.equals(this.initialPopupEntry)) {
                    PortCharacteristic ch = PortCharacteristic.findCharacteristic(this.currentPopupEntry);
                    this.ni.setTechSpecific(ch.getBits());
                    changed = true;
                }
            }
            if (!(np != Artwork.tech().circleNode && np != Artwork.tech().thickCircleNode || this.currentTextField1.equals(this.initialTextField1))) {
                double start = 0.0;
                double curvature = TextUtils.atof(this.currentTextField1) * Math.PI / 180.0;
                int slashPos = this.currentTextField1.indexOf(47);
                if (slashPos >= 0) {
                    start = curvature;
                    curvature = TextUtils.atof(this.currentTextField1.substring(slashPos + 1)) * Math.PI / 180.0;
                }
                this.ni.setArcDegrees(start, curvature, ep);
                changed = true;
            }
            if (this.swapXY) {
                currXSize = TextUtils.atof(this.currentYSize, new Double(this.ni.getLambdaBaseXSize()), AbstractTextDescriptor.Unit.DISTANCE, tech);
                currYSize = TextUtils.atof(this.currentXSize, new Double(this.ni.getLambdaBaseYSize()), AbstractTextDescriptor.Unit.DISTANCE, tech);
                initXSize = TextUtils.atof(this.initialYSize, new Double(currXSize), AbstractTextDescriptor.Unit.DISTANCE, tech);
                initYSize = TextUtils.atof(this.initialXSize, new Double(currYSize), AbstractTextDescriptor.Unit.DISTANCE, tech);
                orient = Orientation.fromJava(this.currentRotation, this.currentMirrorY, this.currentMirrorX);
            } else {
                currXSize = TextUtils.atof(this.currentXSize, new Double(this.ni.getLambdaBaseXSize()), AbstractTextDescriptor.Unit.DISTANCE, tech);
                currYSize = TextUtils.atof(this.currentYSize, new Double(this.ni.getLambdaBaseYSize()), AbstractTextDescriptor.Unit.DISTANCE, tech);
                initXSize = TextUtils.atof(this.initialXSize, new Double(currXSize), AbstractTextDescriptor.Unit.DISTANCE, tech);
                initYSize = TextUtils.atof(this.initialYSize, new Double(currYSize), AbstractTextDescriptor.Unit.DISTANCE, tech);
                orient = Orientation.fromJava(this.currentRotation, this.currentMirrorX, this.currentMirrorY);
            }
            PrimitiveNodeSize size2 = this.ni.getPrimitiveDependentNodeSize(null);
            if (size2 != null) {
                if (np == Schematics.tech().transistorNode || np == Schematics.tech().transistor4Node || np == Schematics.tech().resistorNode) {
                    if (this.ni.getFunction().isFET() || this.ni.getFunction().isComplexResistor()) {
                        double w = TextUtils.atof(this.currentXSize, null);
                        Object width = w == 0.0 ? Variable.withCode(this.currentXSize, this.ni.getCode(Schematics.ATTR_WIDTH)) : new Double(w);
                        double l = TextUtils.atof(this.currentYSize, null);
                        Object length = l == 0.0 ? Variable.withCode(this.currentYSize, this.ni.getCode(Schematics.ATTR_LENGTH)) : new Double(l);
                        this.ni.setPrimitiveNodeSize(width, length, ep);
                    }
                } else if (this.ni.isSerpentineTransistor()) {
                    double initialLength = this.ni.getSerpentineTransistorLength();
                    double length = TextUtils.atof(this.currentYSize, new Double(initialLength));
                    if (length != initialLength) {
                        this.ni.setSerpentineTransistorLength(length, ep);
                    }
                } else {
                    double initialWidth = size2.getDoubleWidth();
                    double initialLength = size2.getDoubleLength();
                    double width = TextUtils.atof(this.currentXSize, new Double(initialWidth));
                    double length = TextUtils.atof(this.currentYSize, new Double(initialLength));
                    if (!DBMath.doublesEqual(width, initialWidth) || !DBMath.doublesEqual(length, initialLength)) {
                        this.ni.setPrimitiveNodeSize(width, length, ep);
                    }
                }
                currXSize = initXSize = this.ni.getLambdaBaseXSize();
                currYSize = initYSize = this.ni.getLambdaBaseYSize();
                orient = this.swapXY ? Orientation.fromJava(this.currentRotation, this.currentMirrorY, this.currentMirrorX) : Orientation.fromJava(this.currentRotation, this.currentMirrorX, this.currentMirrorY);
            }
            Orientation dOrient = orient.concatenate(this.ni.getOrient().inverse());
            if (!(DBMath.doublesEqual(this.currentXPos, this.initialXPos) && DBMath.doublesEqual(this.currentYPos, this.initialYPos) && DBMath.doublesEqual(currXSize, initXSize) && DBMath.doublesEqual(currYSize, initYSize) && dOrient == Orientation.IDENT && !changed)) {
                EPoint[] points = this.ni.getTrace();
                if (points != null) {
                    assert (this.ni.getOrient() == Orientation.IDENT);
                    double percX = currXSize / initXSize;
                    double percY = currYSize / initYSize;
                    EPoint currentPos = EPoint.fromLambda(this.currentXPos, this.currentYPos);
                    FixpTransform trans = new FixpTransform(currentPos, dOrient);
                    EPoint[] newPoints = new EPoint[points.length];
                    for (int i = 0; i < points.length; ++i) {
                        if (points[i] == null) continue;
                        Point2D.Double newPoint = new Point2D.Double(((Point2D)points[i]).getX() * percX, ((Point2D)points[i]).getY() * percY);
                        trans.transform(newPoint, newPoint);
                        newPoints[i] = EPoint.snap(newPoint);
                    }
                    this.ni.setTrace(newPoints);
                } else {
                    boolean wasMirroredInX = this.ni.isMirroredAboutXAxis();
                    boolean wasMirroredInY = this.ni.isMirroredAboutYAxis();
                    this.ni.modifyInstance(DBMath.round(this.currentXPos - this.initialXPos), DBMath.round(this.currentYPos - this.initialYPos), DBMath.round(currXSize - initXSize), DBMath.round(currYSize - initYSize), dOrient);
                    CircuitChangeJobs.rotateNodeText(this.ni, dOrient, wasMirroredInX, wasMirroredInY);
                }
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.ni.isCellInstance() && this.currentExpansion != this.initialExpansion) {
                this.ni.setExpanded(this.currentExpansion);
                EditWindow.expansionChanged(this.ni.getParent());
                EditWindow.clearSubCellCache();
                EditWindow.repaintAllContents();
            }
        }
    }
}

