/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalSeaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;

public class RoutingFrameSeaOfGates
extends RoutingFrame {
    private static final boolean DEBUGSTEPS = false;
    private static final boolean DEBUGLOOPS = false;
    private static final double PERCENTLIMIT = 7.0;
    private static final double GRANULARITY = 1.0;
    private static final double GRAINSIZE = 1.0;
    private static final int COSTALTERNATINGMETAL = 100;
    private static final int COSTLAYERCHANGE = 8;
    private static final int COSTWRONGDIRECTION = 15;
    private static final int COSTTURNING = 1;
    private static final int COSTOFFGRID = 15;
    private SearchVertex svAborted = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    private SearchVertex svExhausted = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    private SearchVertex svLimited = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    private Cell cell;
    private Rectangle2D cellBounds;
    private Map<RoutingFrame.RoutingLayer, RTNode> metalTrees;
    private Map<RoutingFrame.RoutingLayer, RTNode> viaTrees;
    private int numMetalLayers;
    private RoutingFrame.RoutingLayer[] metalLayers;
    private MetalVias[] metalVias;
    private boolean parallelDij;
    private ErrorLogger errorLogger;
    public RoutingFrame.RoutingParameter maxArcWidth = new RoutingFrame.RoutingParameter((RoutingFrame)this, "maxarcwidth", "Maximum arc width:", 10);
    public RoutingFrame.RoutingParameter complexityLimit = new RoutingFrame.RoutingParameter((RoutingFrame)this, "complexity", "Complexity limit:", 200000);
    public RoutingFrame.RoutingParameter useParallelFromToRoutes = new RoutingFrame.RoutingParameter((RoutingFrame)this, "parallelFromToRoutes", "Use two processors per route", false);
    public RoutingFrame.RoutingParameter useParallelRoutes = new RoutingFrame.RoutingParameter((RoutingFrame)this, "parallelRoutes", "Do multiple routes in parallel", false);

    @Override
    public String getAlgorithmName() {
        return "Sea-of-Gates in Framework";
    }

    @Override
    protected void runRouting(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        this.cell = cell;
        this.routeIt(Job.getRunningJob(), segmentsToRoute, allLayers, allContacts, blockages);
    }

    public void routeIt(Job job, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        if (this.initializeDesignRules(allLayers, allContacts)) {
            return;
        }
        Job.getUserInterface().startProgressDialog("Routing " + segmentsToRoute.size() + " nets", null);
        Job.getUserInterface().setProgressNote("Building blockage information...");
        this.errorLogger = ErrorLogger.newInstance("Routing (Sea of gates)");
        this.metalTrees = new HashMap<RoutingFrame.RoutingLayer, RTNode>();
        this.viaTrees = new HashMap<RoutingFrame.RoutingLayer, RTNode>();
        for (RoutingFrame.RoutingGeometry rg : blockages) {
            RoutingFrame.RoutingLayer layer = rg.getLayer();
            Rectangle2D bounds = rg.getBounds();
            if (layer.isMetal()) {
                this.addRectangle(bounds, layer, rg.getNetID());
                continue;
            }
            this.addVia(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), layer, rg.getNetID());
        }
        this.addBlockagesAtPorts(segmentsToRoute);
        ArrayList<NeededRoute> allRoutes = new ArrayList<NeededRoute>();
        int numBatches = segmentsToRoute.size();
        RouteBatches[] routeBatches = new RouteBatches[numBatches];
        for (int b = 0; b < numBatches; ++b) {
            ArrayList<EPoint> lineList;
            ArrayList<PolyBase> polyList;
            String errorMsg;
            RoutingFrame.RoutingSegment rs = segmentsToRoute.get(b);
            routeBatches[b] = new RouteBatches();
            routeBatches[b].segsInBatch = 0;
            double minWidth = Math.max(rs.getWidestArcAtStart(), rs.getWidestArcAtStart());
            int batchNumber = 1;
            List<RoutingFrame.RoutingLayer> fromArcs = rs.getStartLayers();
            RoutingFrame.RoutingLayer fromArc = fromArcs.get(0);
            List<RoutingFrame.RoutingLayer> toArcs = rs.getFinishLayers();
            RoutingFrame.RoutingLayer toArc = toArcs.get(0);
            Point2D fromLoc = rs.getStartEnd().getLocation();
            Point2D toLoc = rs.getFinishEnd().getLocation();
            double fromX = fromLoc.getX();
            double fromY = fromLoc.getY();
            double toX = toLoc.getX();
            double toY = toLoc.getY();
            if (toLoc.getX() < fromLoc.getX()) {
                toX = this.upToGrain(toLoc.getX());
                fromX = this.downToGrain(fromLoc.getX());
            } else if (toLoc.getX() > fromLoc.getX()) {
                toX = this.downToGrain(toLoc.getX());
                fromX = this.upToGrain(fromLoc.getX());
            } else {
                toX = fromX = this.upToGrain(fromLoc.getX());
            }
            if (toLoc.getY() < fromLoc.getY()) {
                toY = this.upToGrain(toLoc.getY());
                fromY = this.downToGrain(fromLoc.getY());
            } else if (toLoc.getY() > fromLoc.getY()) {
                toY = this.downToGrain(toLoc.getY());
                fromY = this.upToGrain(fromLoc.getY());
            } else {
                toY = fromY = this.upToGrain(fromLoc.getY());
            }
            int fromZ = fromArc.getMetalNumber() - 1;
            int toZ = toArc.getMetalNumber() - 1;
            double metalSpacing = Math.max(this.metalLayers[fromZ].getMinWidth(), minWidth) / 2.0;
            RoutingFrame.RoutingLayer lay = this.metalLayers[fromZ];
            double surround = lay.getMinSpacing(lay);
            SOGBound block = this.getMetalBlockage(rs.getNetID(), fromZ, metalSpacing, metalSpacing, surround, fromX, fromY);
            if (block != null) {
                fromX = fromLoc.getX();
                fromY = fromLoc.getY();
                block = this.getMetalBlockage(rs.getNetID(), fromZ, metalSpacing, metalSpacing, surround, fromX, fromY);
                if (block != null) {
                    errorMsg = "Cannot Route to port " + rs.getStartEnd().describe() + " at (" + TextUtils.formatDistance(fromX) + "," + TextUtils.formatDistance(fromY) + ") because it is blocked on layer " + this.metalLayers[fromZ].getName() + " [needs " + TextUtils.formatDistance(metalSpacing + surround) + " all around, blockage is " + TextUtils.formatDistance(block.bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(block.bound.getMaxX()) + " and " + TextUtils.formatDistance(block.bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.bound.getMaxY()) + "]";
                    System.out.println(errorMsg);
                    polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(fromX, fromY, (metalSpacing + surround) * 2.0, (metalSpacing + surround) * 2.0));
                    polyList.add(new PolyBase(block.bound));
                    lineList = new ArrayList<EPoint>();
                    lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMinY()));
                    lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMaxY()));
                    lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMaxY()));
                    lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMinY()));
                    this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, this.cell, 0, true);
                    continue;
                }
            }
            metalSpacing = Math.max(this.metalLayers[toZ].getMinWidth(), minWidth) / 2.0;
            lay = this.metalLayers[toZ];
            surround = lay.getMinSpacing(lay);
            block = this.getMetalBlockage(rs.getNetID(), toZ, metalSpacing, metalSpacing, surround, toX, toY);
            if (block != null) {
                toX = toLoc.getX();
                toY = toLoc.getY();
                block = this.getMetalBlockage(rs.getNetID(), toZ, metalSpacing, metalSpacing, surround, toX, toY);
                if (block != null) {
                    errorMsg = "Cannot route to port " + rs.getFinishEnd().describe() + " at (" + TextUtils.formatDistance(toX) + "," + TextUtils.formatDistance(toY) + ") because it is blocked on layer " + this.metalLayers[toZ].getName() + " [needs " + TextUtils.formatDistance(metalSpacing + surround) + " all around, blockage is " + TextUtils.formatDistance(block.bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(block.bound.getMaxX()) + " and " + TextUtils.formatDistance(block.bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.bound.getMaxY()) + "]";
                    System.out.println("ERROR: " + errorMsg);
                    polyList = new ArrayList();
                    polyList.add(new PolyBase(toX, toY, (metalSpacing + surround) * 2.0, (metalSpacing + surround) * 2.0));
                    polyList.add(new PolyBase(block.bound));
                    lineList = new ArrayList();
                    lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMinY()));
                    lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMaxY()));
                    lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMaxY()));
                    lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMinY()));
                    this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, this.cell, 0, true);
                    continue;
                }
            }
            NeededRoute nr = new NeededRoute(rs.getNetName(), fromX, fromY, fromZ, toX, toY, toZ, rs.getNetID(), minWidth, b, batchNumber++, rs);
            ++routeBatches[b].segsInBatch;
            allRoutes.add(nr);
        }
        boolean parallel = this.useParallelRoutes.getBooleanValue();
        this.parallelDij = this.useParallelFromToRoutes.getBooleanValue();
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        if (numberOfProcessors <= 1) {
            this.parallelDij = false;
        }
        int numberOfThreads = numberOfProcessors;
        if (this.parallelDij) {
            numberOfThreads /= 2;
        }
        if (!parallel) {
            numberOfThreads = 1;
        }
        if (numberOfThreads == 1) {
            parallel = false;
        }
        System.out.println("Sea-of-gates router finding " + allRoutes.size() + " paths on " + numBatches + " networks");
        if (parallel || this.parallelDij) {
            String message = "NOTE: System has " + numberOfProcessors + " processors so";
            if (parallel) {
                message = message + " routing " + numberOfThreads + " paths in parallel";
            }
            if (this.parallelDij) {
                if (parallel) {
                    message = message + " and";
                }
                message = message + " routing both directions of each path in parallel";
            }
            System.out.println(message);
        }
        Environment env = Environment.getThreadEnvironment();
        EditingPreferences ep = this.cell.getEditingPreferences();
        if (numberOfThreads > 1) {
            this.doRoutingParallel(numberOfThreads, allRoutes, routeBatches, env, ep, job);
        } else {
            this.doRouting(allRoutes, routeBatches, job, env, ep);
        }
        Job.getUserInterface().stopProgressDialog();
        this.errorLogger.termLogging(true);
    }

    private void doRouting(List<NeededRoute> allRoutes, RouteBatches[] routeBatches, Job job, Environment env, EditingPreferences ep) {
        int totalRoutes = allRoutes.size();
        for (int r = 0; r < totalRoutes; ++r) {
            if (job != null && job.checkAbort()) {
                System.out.println("Sea-of-gates routing aborted");
                break;
            }
            NeededRoute nr = allRoutes.get(r);
            Job.getUserInterface().setProgressValue(r * 100 / totalRoutes);
            String routeName = nr.routeName;
            if (routeBatches[nr.batchNumber].segsInBatch > 1) {
                routeName = routeName + " (" + nr.routeInBatch + " of " + routeBatches[nr.batchNumber].segsInBatch + ")";
            }
            Job.getUserInterface().setProgressNote("Network " + routeName);
            System.out.println("Routing network " + routeName + "...");
            this.findPath(nr, env, ep);
            if (nr.winningWF == null || nr.winningWF.vertices == null) continue;
            this.createRoute(nr);
        }
    }

    private void doRoutingParallel(int numberOfThreads, List<NeededRoute> allRoutes, RouteBatches[] routeBatches, Environment env, EditingPreferences ep, Job job) {
        RouteInThread[] threads = new RouteInThread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new RouteInThread("Route #" + (i + 1), env, ep);
        }
        NeededRoute[] routesToDo = new NeededRoute[numberOfThreads];
        int[] routeIndices = new int[numberOfThreads];
        Semaphore outSem = new Semaphore(0);
        ArrayList<NeededRoute> myList = new ArrayList<NeededRoute>();
        for (NeededRoute nr : allRoutes) {
            myList.add(nr);
        }
        ArrayList<Rectangle2D> blocked = new ArrayList<Rectangle2D>();
        int totalRoutes = allRoutes.size();
        int routesDone = 0;
        while (myList.size() > 0) {
            int i;
            int threadAssign = 0;
            blocked.clear();
            for (int i2 = 0; i2 < myList.size(); ++i2) {
                NeededRoute nr = (NeededRoute)myList.get(i2);
                boolean isBlocked = false;
                for (Rectangle2D block : blocked) {
                    if (!block.intersects(nr.routeBounds)) continue;
                    isBlocked = true;
                    break;
                }
                if (isBlocked) continue;
                blocked.add(nr.routeBounds);
                routesToDo[threadAssign] = nr;
                routeIndices[threadAssign] = i2;
                threads[threadAssign].startRoute(nr, outSem);
                if (++threadAssign >= numberOfThreads) break;
            }
            String routes = "";
            for (i = 0; i < threadAssign; ++i) {
                String routeName = routesToDo[i].routeName;
                if (routeBatches[routesToDo[i].batchNumber].segsInBatch > 1) {
                    routeName = routeName + "(" + routesToDo[i].routeInBatch + "/" + routeBatches[routesToDo[i].batchNumber].segsInBatch + ")";
                }
                if (routes.length() > 0) {
                    routes = routes + ", ";
                }
                routes = routes + routeName;
            }
            System.out.println("Parallel routing " + routes + "...");
            Job.getUserInterface().setProgressNote(routes);
            outSem.acquireUninterruptibly(threadAssign);
            for (i = 0; i < threadAssign; ++i) {
                if (routesToDo[i].winningWF == null || routesToDo[i].winningWF.vertices == null) continue;
                this.createRoute(routesToDo[i]);
            }
            for (i = threadAssign - 1; i >= 0; --i) {
                myList.remove(routeIndices[i]);
            }
            Job.getUserInterface().setProgressValue((routesDone += threadAssign) * 100 / totalRoutes);
        }
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i].startRoute(null, null);
        }
    }

    private boolean initializeDesignRules(List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts) {
        this.numMetalLayers = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            ++this.numMetalLayers;
        }
        this.metalLayers = new RoutingFrame.RoutingLayer[this.numMetalLayers];
        int metNo = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            this.metalLayers[metNo++] = rl;
        }
        this.metalVias = new MetalVias[this.numMetalLayers - 1];
        for (int i = 0; i < this.numMetalLayers - 1; ++i) {
            this.metalVias[i] = new MetalVias();
        }
        block3: for (RoutingFrame.RoutingContact rc : allContacts) {
            for (int i = 0; i < this.numMetalLayers - 1; ++i) {
                if ((rc.getFirstLayer() != this.metalLayers[i] || rc.getSecondLayer() != this.metalLayers[i + 1]) && (rc.getSecondLayer() != this.metalLayers[i] || rc.getFirstLayer() != this.metalLayers[i + 1])) continue;
                this.metalVias[i].addVia(rc, 0);
                boolean square = true;
                boolean offCenter = false;
                List<RoutingFrame.RoutingGeometry> geoms = rc.getGeometry();
                for (RoutingFrame.RoutingGeometry rg : geoms) {
                    RoutingFrame.RoutingLayer conLayer = rg.getLayer();
                    if (!conLayer.isMetal()) continue;
                    Rectangle2D conRect = rg.getBounds();
                    if (conRect.getWidth() != conRect.getHeight()) {
                        square = false;
                    }
                    if (conRect.getCenterX() == 0.0 && conRect.getCenterY() == 0.0) continue;
                    offCenter = true;
                }
                if (offCenter) {
                    this.metalVias[i].addVia(rc, 90);
                    this.metalVias[i].addVia(rc, 180);
                    this.metalVias[i].addVia(rc, 270);
                    continue block3;
                }
                if (square) continue block3;
                this.metalVias[i].addVia(rc, 90);
                continue block3;
            }
        }
        for (int i = 0; i < this.numMetalLayers; ++i) {
            if (this.metalLayers[i] == null) {
                System.out.println("ERROR: Cannot find layer for Metal " + (i + 1));
                return true;
            }
            if (i >= this.numMetalLayers - 1 || this.metalVias[i].getVias().size() != 0) continue;
            System.out.println("ERROR: Cannot find contact node between Metal " + (i + 1) + " and Metal " + (i + 2));
            return true;
        }
        return false;
    }

    private void addBlockagesAtPorts(List<RoutingFrame.RoutingSegment> segmentsToRoute) {
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            double minWidth = Math.min(rs.getWidestArcAtStart(), rs.getWidestArcAtFinish());
            this.addBlockage(rs.getStartEnd().getLocation(), rs.getStartLayers(), minWidth, rs.getNetID());
            this.addBlockage(rs.getFinishEnd().getLocation(), rs.getFinishLayers(), minWidth, rs.getNetID());
        }
    }

    private void addBlockage(Point2D loc, List<RoutingFrame.RoutingLayer> layers, double minWidth, int netID) {
        int lowMetal = -1;
        int highMetal = -1;
        for (RoutingFrame.RoutingLayer rl : layers) {
            int level = rl.getMetalNumber();
            if (lowMetal < 0) {
                lowMetal = highMetal = level;
                continue;
            }
            lowMetal = Math.min(lowMetal, level);
            highMetal = Math.max(highMetal, level);
        }
        if (lowMetal < 0) {
            return;
        }
        for (int via = lowMetal - 2; via < highMetal; ++via) {
            if (via < 0 || via >= this.numMetalLayers - 1) continue;
            MetalVia mv = this.metalVias[via].getVias().get(0);
            for (RoutingFrame.RoutingGeometry rg : mv.via.getGeometry()) {
                Rectangle2D centeredBounds = rg.getBounds();
                Rectangle2D.Double bounds = new Rectangle2D.Double(centeredBounds.getMinX() + loc.getX(), centeredBounds.getMinY() + loc.getY(), centeredBounds.getWidth(), centeredBounds.getHeight());
                this.addRectangle(bounds, rg.getLayer(), netID);
            }
        }
    }

    private void createRoute(NeededRoute nr) {
        Wavefront wf = nr.winningWF;
        Point2D pt = wf.to.getLocation();
        RoutingFrame.RoutingContact startContact = RoutingFrame.RoutingContact.STARTPOINT;
        RoutingFrame.RoutingContact finishContact = RoutingFrame.RoutingContact.FINISHPOINT;
        if (wf == nr.dir2) {
            startContact = RoutingFrame.RoutingContact.FINISHPOINT;
            finishContact = RoutingFrame.RoutingContact.STARTPOINT;
        }
        int endIndex = wf.vertices.size();
        RoutingFrame.RoutePoint lastRP = new RoutingFrame.RoutePoint(finishContact, pt, 0);
        if (!(DBMath.doublesClose(pt.getX(), wf.toX) && DBMath.doublesClose(pt.getY(), wf.toY) || endIndex < 2)) {
            RoutingFrame.RoutePoint rp;
            SearchVertex v1 = (SearchVertex)wf.vertices.get(0);
            SearchVertex v2 = (SearchVertex)wf.vertices.get(1);
            RoutingFrame.RoutingLayer type = this.metalLayers[wf.toZ];
            double width = Math.max(type.getMinWidth(), nr.minWidth);
            RoutingFrame.RoutingContact pin = type.getPin();
            if (v1.getX() == v2.getX()) {
                rp = this.makeNodeInst(pin, new Point2D.Double(v1.getX(), pt.getY()), 0, nr);
                this.makeArcInst(type, width, rp, lastRP, nr);
                lastRP = rp;
            } else if (v1.getY() == v2.getY()) {
                rp = this.makeNodeInst(pin, new Point2D.Double(pt.getX(), v1.getY()), 0, nr);
                this.makeArcInst(type, width, rp, lastRP, nr);
                lastRP = rp;
            }
        }
        for (int i = 0; i < endIndex; ++i) {
            double width;
            RoutingFrame.RoutingLayer type;
            SearchVertex sv = (SearchVertex)wf.vertices.get(i);
            boolean madeContacts = false;
            while (i < endIndex - 1) {
                SearchVertex svNext = (SearchVertex)wf.vertices.get(i + 1);
                if (sv.getX() != svNext.getX() || sv.getY() != svNext.getY() || sv.getZ() == svNext.getZ()) break;
                List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), svNext.getZ())].getVias();
                int whichContact = sv.getContactNo();
                MetalVia mv = nps.get(whichContact);
                RoutingFrame.RoutePoint rp = this.makeNodeInst(mv.via, new Point2D.Double(sv.getX(), sv.getY()), mv.orientation, nr);
                type = this.metalLayers[sv.getZ()];
                width = Math.max(type.getMinWidth(), nr.minWidth);
                this.makeArcInst(type, width, lastRP, rp, nr);
                madeContacts = true;
                sv = svNext;
                ++i;
                lastRP = rp;
            }
            if (madeContacts && i != endIndex - 1) continue;
            RoutingFrame.RoutingContact np = this.metalLayers[sv.getZ()].getPin();
            RoutingFrame.RoutePoint rp = null;
            if (i == endIndex - 1) {
                Point2D fPoint = wf.from.getLocation();
                rp = new RoutingFrame.RoutePoint(startContact, fPoint, 0);
                if (!(DBMath.doublesClose(fPoint.getX(), sv.getX()) && DBMath.doublesClose(fPoint.getY(), sv.getY()) || endIndex < 2)) {
                    RoutingFrame.RoutePoint intRP;
                    RoutingFrame.RoutingContact pNp;
                    SearchVertex v1 = (SearchVertex)wf.vertices.get(wf.vertices.size() - 2);
                    SearchVertex v2 = (SearchVertex)wf.vertices.get(wf.vertices.size() - 1);
                    type = this.metalLayers[wf.fromZ];
                    width = Math.max(type.getMinWidth(), nr.minWidth);
                    if (v1.getX() == v2.getX()) {
                        pNp = this.metalLayers[wf.fromZ].getPin();
                        intRP = this.makeNodeInst(pNp, new Point2D.Double(v1.getX(), fPoint.getY()), 0, nr);
                        this.makeArcInst(type, width, lastRP, intRP, nr);
                        lastRP = intRP;
                    } else if (v1.getY() == v2.getY()) {
                        pNp = this.metalLayers[wf.fromZ].getPin();
                        intRP = this.makeNodeInst(pNp, new Point2D.Double(fPoint.getX(), v1.getY()), 0, nr);
                        this.makeArcInst(type, width, lastRP, intRP, nr);
                        lastRP = intRP;
                    }
                }
            } else {
                rp = this.makeNodeInst(np, new Point2D.Double(sv.getX(), sv.getY()), 0, nr);
            }
            if (lastRP != null) {
                RoutingFrame.RoutingLayer type2 = this.metalLayers[sv.getZ()];
                double width2 = Math.max(type2.getMinWidth(), nr.minWidth);
                this.makeArcInst(type2, width2, lastRP, rp, nr);
            }
            lastRP = rp;
        }
    }

    private RoutingFrame.RoutePoint makeNodeInst(RoutingFrame.RoutingContact np, Point2D loc, int angle, NeededRoute nr) {
        RoutingFrame.RoutePoint rp = new RoutingFrame.RoutePoint(np, loc, angle);
        nr.rs.addWireEnd(rp);
        List<RoutingFrame.RoutingGeometry> geoms = np.getGeometry();
        if (geoms != null) {
            for (RoutingFrame.RoutingGeometry rg : geoms) {
                this.addLayer(rg.getLayer(), rg.getBounds(), GenMath.MATID, nr.netID, false);
            }
        }
        return rp;
    }

    private RoutingFrame.RouteWire makeArcInst(RoutingFrame.RoutingLayer type, double wid, RoutingFrame.RoutePoint from2, RoutingFrame.RoutePoint to2, NeededRoute nr) {
        RoutingFrame.RouteWire rw = new RoutingFrame.RouteWire(type, from2, to2, wid);
        nr.rs.addWire(rw);
        Rectangle2D box = this.makeArcBox(from2.getLocation(), to2.getLocation(), wid);
        if (box != null) {
            this.addLayer(type, box, GenMath.MATID, nr.netID, false);
        }
        return rw;
    }

    public Rectangle2D makeArcBox(Point2D from2, Point2D to2, double width) {
        double w2 = width / 2.0;
        int angle = DBMath.figureAngle(from2, to2);
        switch (angle) {
            case 0: 
            case 1800: {
                double y = to2.getY();
                double x1 = to2.getX();
                double x2 = from2.getX();
                return new Rectangle2D.Double(Math.min(x1, x2) - w2, y - w2, Math.abs(x1 - x2) + width, width);
            }
            case 900: 
            case 2700: {
                double x2 = to2.getX();
                double y1 = to2.getY();
                double y2 = from2.getY();
                return new Rectangle2D.Double(x2 - w2, Math.min(y1, y2) - w2, width, Math.abs(y1 - y2) + width);
            }
        }
        return null;
    }

    private double getVertexLength(List<SearchVertex> vertices) {
        if (vertices == null) {
            return Double.MAX_VALUE;
        }
        if (vertices.size() == 0) {
            return Double.MAX_VALUE;
        }
        double sum2 = 0.0;
        SearchVertex last2 = null;
        for (SearchVertex sv : vertices) {
            if (last2 != null) {
                sum2 += Math.abs(sv.getX() - last2.getX()) + Math.abs(sv.getY() - last2.getY()) + (double)(Math.abs(sv.getZ() - last2.getZ()) * 10);
            }
            last2 = sv;
        }
        return sum2;
    }

    private void findPath(NeededRoute nr, Environment env, EditingPreferences ep) {
        Wavefront d1 = nr.dir1;
        if (DBMath.areEquals(d1.toX, d1.fromX) && DBMath.areEquals(d1.toY, d1.fromY) && d1.toZ == d1.fromZ) {
            nr.winningWF = d1;
            nr.winningWF.vertices = new ArrayList();
            SearchVertex sv = new SearchVertex(d1.toX, d1.toY, d1.toZ, 0, null, 0, nr.winningWF);
            nr.winningWF.vertices.add(sv);
            nr.cleanSearchMemory();
            return;
        }
        if (this.parallelDij) {
            Semaphore outSem = new Semaphore(0);
            new DijkstraInThread("Route a->b", nr.dir1, nr.dir2, outSem, env, ep);
            new DijkstraInThread("Route b->a", nr.dir2, nr.dir1, outSem, env, ep);
            outSem.acquireUninterruptibly(2);
        } else {
            this.doTwoWayDijkstra(nr);
        }
        Wavefront wf = nr.winningWF;
        double verLength = Double.MAX_VALUE;
        if (wf != null) {
            verLength = this.getVertexLength(wf.vertices);
        }
        if (verLength == Double.MAX_VALUE) {
            if (wf == null) {
                wf = nr.dir1;
            }
            String errorMsg = wf.vertices == null ? "Search too complex (exceeds complexity limit of " + this.complexityLimit.getIntValue() + " steps)" : "Failed to route from port " + wf.from.describe() + " to port " + wf.to.describe();
            System.out.println("ERROR: " + errorMsg);
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            lineList.add(new EPoint(wf.toX, wf.toY));
            lineList.add(new EPoint(wf.fromX, wf.fromY));
            this.errorLogger.logMessageWithLines(errorMsg, null, lineList, this.cell, 0, true);
        }
        nr.cleanSearchMemory();
    }

    private void doTwoWayDijkstra(NeededRoute nr) {
        SearchVertex result2 = null;
        int numSearchVertices = 0;
        while (result2 == null) {
            if (++numSearchVertices > this.complexityLimit.getIntValue()) {
                return;
            }
            SearchVertex resultA = this.advanceWavefront(nr.dir1);
            SearchVertex resultB = this.advanceWavefront(nr.dir2);
            if (resultA == null && resultB == null) continue;
            result2 = resultA;
            nr.winningWF = nr.dir1;
            if (result2 != null && result2 != this.svExhausted) continue;
            result2 = resultB;
            nr.winningWF = nr.dir2;
        }
        if (result2 == this.svAborted || result2 == this.svExhausted) {
            nr.winningWF = null;
            return;
        }
        List<SearchVertex> realVertices = this.getOptimizedList(result2);
        nr.winningWF.vertices = realVertices;
    }

    private SearchVertex advanceWavefront(Wavefront wf) {
        if (wf.active.size() == 0) {
            return this.svExhausted;
        }
        SearchVertex svCurrent = (SearchVertex)wf.active.first();
        wf.active.remove(svCurrent);
        double curX = svCurrent.getX();
        double curY = svCurrent.getY();
        int curZ = svCurrent.getZ();
        if (wf.debug) {
            System.out.print("AT (" + TextUtils.formatDouble(curX) + "," + TextUtils.formatDouble(curY) + ",M" + (curZ + 1) + ")C=" + svCurrent.cost + " WENT");
        }
        block16: for (int i = 0; i < 6; ++i) {
            double inc;
            boolean foundDest;
            double dx = 0.0;
            double dy = 0.0;
            int dz = 0;
            switch (i) {
                case 0: {
                    dx = -1.0;
                    double intermediate = this.upToGrainAlways(curX + dx);
                    if (intermediate == curX + dx) break;
                    dx = intermediate - curX;
                    break;
                }
                case 1: {
                    dx = 1.0;
                    double intermediate = this.downToGrainAlways(curX + dx);
                    if (intermediate == curX + dx) break;
                    dx = intermediate - curX;
                    break;
                }
                case 2: {
                    dy = -1.0;
                    double intermediate = this.upToGrainAlways(curY + dy);
                    if (intermediate == curY + dy) break;
                    dy = intermediate - curY;
                    break;
                }
                case 3: {
                    dy = 1.0;
                    double intermediate = this.downToGrainAlways(curY + dy);
                    if (intermediate == curY + dy) break;
                    dy = intermediate - curY;
                    break;
                }
                case 4: {
                    dz = -1;
                    break;
                }
                case 5: {
                    dz = 1;
                }
            }
            boolean stuck = false;
            if (dz == 0) {
                boolean goFarther = false;
                if (dx != 0.0) {
                    if ((wf.toX - curX) * dx > 0.0) {
                        goFarther = true;
                    }
                } else if ((wf.toY - curY) * dy > 0.0) {
                    goFarther = true;
                }
                if (goFarther) {
                    double jumpSize = this.getJumpSize(curX, curY, curZ, dx, dy, wf);
                    if (dx > 0.0) {
                        if (jumpSize <= 0.0) {
                            stuck = true;
                        }
                        dx = jumpSize;
                    }
                    if (dx < 0.0) {
                        if (jumpSize >= 0.0) {
                            stuck = true;
                        }
                        dx = jumpSize;
                    }
                    if (dy > 0.0) {
                        if (jumpSize <= 0.0) {
                            stuck = true;
                        }
                        dy = jumpSize;
                    }
                    if (dy < 0.0) {
                        if (jumpSize >= 0.0) {
                            stuck = true;
                        }
                        dy = jumpSize;
                    }
                }
            }
            double nX = curX + dx;
            double nY = curY + dy;
            int nZ = curZ + dz;
            if (wf.debug) {
                switch (i) {
                    case 0: {
                        System.out.print("  X-" + TextUtils.formatDouble(Math.abs(dx)));
                        break;
                    }
                    case 1: {
                        System.out.print("  X+" + TextUtils.formatDouble(dx));
                        break;
                    }
                    case 2: {
                        System.out.print("  Y-" + TextUtils.formatDouble(Math.abs(dy)));
                        break;
                    }
                    case 3: {
                        System.out.print("  Y+" + TextUtils.formatDouble(dy));
                        break;
                    }
                    case 4: {
                        System.out.print("  -Z");
                        break;
                    }
                    case 5: {
                        System.out.print("  +Z");
                    }
                }
            }
            if (stuck) {
                if (!wf.debug) continue;
                System.out.print(":CannotMove");
                continue;
            }
            if (nX < ((Wavefront)wf).nr.minimumSearchBoundX && (dx = (nX = ((Wavefront)wf).nr.minimumSearchBoundX) - curX) == 0.0) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (nX > ((Wavefront)wf).nr.maximumSearchBoundX && (dx = (nX = ((Wavefront)wf).nr.maximumSearchBoundX) - curX) == 0.0) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (nY < ((Wavefront)wf).nr.minimumSearchBoundY && (dy = (nY = ((Wavefront)wf).nr.minimumSearchBoundY) - curY) == 0.0) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (nY > ((Wavefront)wf).nr.maximumSearchBoundY && (dy = (nY = ((Wavefront)wf).nr.maximumSearchBoundY) - curY) == 0.0) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (nZ < 0 || nZ >= this.numMetalLayers) {
                if (!wf.debug) continue;
                System.out.print(":OutOfBounds");
                continue;
            }
            if (wf.getVertex(nX, nY, nZ)) {
                if (!wf.debug) continue;
                System.out.print(":AlreadyVisited");
                continue;
            }
            int whichContact = 0;
            Point2D[] cuts = null;
            if (dz == 0) {
                double width = Math.max(this.metalLayers[nZ].getMinWidth(), ((Wavefront)wf).nr.minWidth);
                double metalSpacing = width / 2.0;
                boolean allClear = false;
                while (true) {
                    double newNY;
                    double newNX;
                    SOGBound sb;
                    SearchVertex prevPath = svCurrent;
                    double checkX = (curX + nX) / 2.0;
                    double checkY = (curY + nY) / 2.0;
                    double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                    double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                    while (prevPath != null && prevPath.last != null && prevPath.zv == nZ && prevPath.last.zv == nZ) {
                        if (prevPath.xv == prevPath.last.xv && dx == 0.0) {
                            checkY = (prevPath.last.yv + nY) / 2.0;
                            halfHei = metalSpacing + Math.abs(prevPath.last.yv - nY) / 2.0;
                            prevPath = prevPath.last;
                            continue;
                        }
                        if (prevPath.yv != prevPath.last.yv || dy != 0.0) break;
                        checkX = (prevPath.last.xv + nX) / 2.0;
                        halfWid = metalSpacing + Math.abs(prevPath.last.xv - nX) / 2.0;
                        prevPath = prevPath.last;
                    }
                    if ((sb = this.getMetalBlockageAndNotch(wf, nZ, halfWid, halfHei, checkX, checkY, prevPath)) == null) {
                        allClear = true;
                        break;
                    }
                    if (i == 0) {
                        newNX = this.downToGrainAlways(nX + 1.0);
                        if (newNX >= curX) break;
                        dx = newNX - curX;
                    } else if (i == 1) {
                        newNX = this.upToGrainAlways(nX - 1.0);
                        if (newNX <= curX) break;
                        dx = newNX - curX;
                    } else if (i == 2) {
                        double newDY;
                        newNY = this.downToGrainAlways(nY + 1.0);
                        if (newNY >= curY) break;
                        dy = newDY = newNY - curY;
                    } else if (i == 3) {
                        newNY = this.upToGrainAlways(nY - 1.0);
                        if (newNY <= curY) break;
                        dy = newNY - curY;
                    }
                    nX = curX + dx;
                    nY = curY + dy;
                }
                if (!allClear) {
                    double surround;
                    double halfHei;
                    if (!wf.debug) continue;
                    double checkX = (curX + nX) / 2.0;
                    double checkY = (curY + nY) / 2.0;
                    double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                    SOGBound sb = this.getMetalBlockage(((Wavefront)wf).nr.netID, nZ, halfWid, halfHei = metalSpacing + Math.abs(dy) / 2.0, surround = this.metalLayers[nZ].getMaxSurround(), checkX, checkY);
                    if (sb != null) {
                        System.out.print(":Blocked");
                        continue;
                    }
                    System.out.print(":BlockedNotch");
                    continue;
                }
            } else {
                int lowMetal = Math.min(curZ, nZ);
                int highMetal = Math.max(curZ, nZ);
                List<MetalVia> nps = this.metalVias[lowMetal].getVias();
                whichContact = -1;
                for (int contactNo = 0; contactNo < nps.size(); ++contactNo) {
                    MetalVia mv = nps.get(contactNo);
                    RoutingFrame.RoutingContact np = mv.via;
                    List<RoutingFrame.RoutingGeometry> conGeoms = mv.via.getGeometry();
                    AffineTransform trans = null;
                    if (mv.orientation != 0) {
                        trans = this.makePureTransform(mv.orientation);
                    }
                    int cutCount = 0;
                    for (RoutingFrame.RoutingGeometry rg : conGeoms) {
                        if (rg.getLayer().isMetal()) continue;
                        ++cutCount;
                    }
                    Point2D[] curCuts = new Point2D[cutCount];
                    cutCount = 0;
                    boolean failed = false;
                    for (RoutingFrame.RoutingGeometry rg : conGeoms) {
                        SearchVertex lastSv;
                        RoutingFrame.RoutingLayer conLayer;
                        Rectangle2D conRect = rg.getBounds();
                        if (trans != null) {
                            conRect = (Rectangle2D)conRect.clone();
                            DBMath.transformRect(conRect, trans);
                        }
                        if ((conLayer = rg.getLayer()).isMetal()) {
                            double halfHei;
                            double halfWid;
                            int metalNo = conLayer.getMetalNumber() - 1;
                            if (this.getMetalBlockageAndNotch(wf, metalNo, halfWid = conRect.getWidth() / 2.0, halfHei = conRect.getHeight() / 2.0, conRect.getCenterX(), conRect.getCenterY(), svCurrent) == null) continue;
                            failed = true;
                            break;
                        }
                        double conCX = conRect.getCenterX();
                        double conCY = conRect.getCenterY();
                        double surround = np.getViaSpacing();
                        if (this.getViaBlockage(((Wavefront)wf).nr.netID, conLayer, surround, surround, conCX, conCY) != null) {
                            failed = true;
                            break;
                        }
                        curCuts[cutCount++] = new Point2D.Double(conCX, conCY);
                        SearchVertex sv = svCurrent;
                        while (sv != null && (lastSv = sv.last) != null) {
                            if (Math.min(sv.getZ(), lastSv.getZ()) == lowMetal && Math.max(sv.getZ(), lastSv.getZ()) == highMetal) {
                                Point2D[] svCuts = sv.getCutLayer() == lowMetal ? sv.getCuts() : lastSv.getCuts();
                                if (svCuts != null) {
                                    for (Point2D cutPt : svCuts) {
                                        if (Math.abs(cutPt.getX() - conCX) >= surround || Math.abs(cutPt.getY() - conCY) >= surround) continue;
                                        failed = true;
                                        break;
                                    }
                                }
                                if (failed) break;
                            }
                            sv = sv.last;
                        }
                        if (!failed) continue;
                        break;
                    }
                    if (failed) continue;
                    whichContact = contactNo;
                    cuts = curCuts;
                    break;
                }
                if (whichContact < 0) {
                    if (!wf.debug) continue;
                    System.out.print(":Blocked");
                    continue;
                }
            }
            SearchVertex svNext = new SearchVertex(nX, nY, nZ, whichContact, cuts, Math.min(curZ, nZ), wf);
            svNext.last = svCurrent;
            boolean bl = foundDest = DBMath.areEquals(nX, wf.toX) && DBMath.areEquals(nY, wf.toY);
            if (foundDest && nZ == wf.toZ) {
                if (wf.debug) {
                    System.out.print(":FoundDestination");
                }
                return svNext;
            }
            svNext.cost = svCurrent.cost;
            if (dx != 0.0) {
                if (wf.toX == curX) {
                    svNext.cost += 7;
                } else if ((wf.toX - curX) * dx < 0.0) {
                    svNext.cost += 15;
                }
                if (nZ % 2 == 0) {
                    int c = 100 * (int)Math.abs(dx) / (int)this.cellBounds.getWidth();
                    svNext.cost += c;
                }
            }
            if (dy != 0.0) {
                if (wf.toY == curY) {
                    svNext.cost += 7;
                } else if ((wf.toY - curY) * dy < 0.0) {
                    svNext.cost += 15;
                }
                if (nZ % 2 != 0) {
                    int c = 100 * (int)Math.abs(dy) / (int)this.cellBounds.getHeight();
                    svNext.cost += c;
                }
            }
            if (dz != 0) {
                if (wf.toZ == curZ) {
                    svNext.cost += 8;
                } else if ((wf.toZ - curZ) * dz < 0) {
                    svNext.cost += 120;
                }
            } else {
                double jumpSize1 = Math.abs(this.getJumpSize(nX, nY, nZ, dx, dy, wf));
                double jumpSize2 = Math.abs(this.getJumpSize(curX, curY, curZ, -dx, -dy, wf));
                if (jumpSize1 > 1.0 && jumpSize2 > 1.0) {
                    svNext.cost = (int)((double)svNext.cost + jumpSize1 * jumpSize2 / 10.0);
                }
                if (svCurrent.last != null) {
                    boolean xTurn = svCurrent.getX() != svCurrent.last.getX();
                    boolean yTurn = svCurrent.getY() != svCurrent.last.getY();
                    if (xTurn != (dx != 0.0) || yTurn != (dy != 0.0)) {
                        svNext.cost += 1;
                    }
                }
            }
            if (this.downToGrainAlways(nX) != nX && nX != wf.toX) {
                svNext.cost += 15;
            }
            if (this.downToGrainAlways(nY) != nY && nY != wf.toY) {
                svNext.cost += 15;
            }
            wf.setVertex(nX, nY, nZ);
            wf.active.add(svNext);
            if (wf.debug) {
                System.out.print("(" + TextUtils.formatDouble(svNext.getX()) + "," + TextUtils.formatDouble(svNext.getY()) + ",M" + (svNext.getZ() + 1) + ")C=" + svNext.cost);
            }
            if (dz != 0) continue;
            if (Math.abs(dx) > 1.0) {
                inc = dx < 0.0 ? 1.0 : -1.0;
                double lessDX = dx + inc;
                int cost = svNext.cost;
                int countDown = 0;
                while (true) {
                    double nowX = curX + lessDX;
                    ++cost;
                    if (!wf.getVertex(nowX, nY, nZ)) {
                        SearchVertex svIntermediate = new SearchVertex(nowX, nY, nZ, whichContact, cuts, curZ, wf);
                        svIntermediate.last = svCurrent;
                        svIntermediate.cost = cost;
                        wf.setVertex(nowX, nY, nZ);
                        wf.active.add(svIntermediate);
                    }
                    if (!(inc < 0.0) ? lessDX > -1.0 : (lessDX += inc) < 1.0) break;
                    if (countDown++ < 10) continue;
                    countDown = 0;
                    inc += inc;
                }
            }
            if (!(Math.abs(dy) > 1.0)) continue;
            inc = dy < 0.0 ? 1.0 : -1.0;
            double lessDY = dy + inc;
            int cost = svNext.cost;
            int countDown = 0;
            while (true) {
                double nowY = curY + lessDY;
                ++cost;
                if (!wf.getVertex(nX, nowY, nZ)) {
                    SearchVertex svIntermediate = new SearchVertex(nX, nowY, nZ, whichContact, cuts, curZ, wf);
                    svIntermediate.last = svCurrent;
                    svIntermediate.cost = cost;
                    wf.setVertex(nX, nowY, nZ);
                    wf.active.add(svIntermediate);
                }
                if (!(inc < 0.0) ? lessDY > -1.0 : (lessDY += inc) < 1.0) continue block16;
                if (countDown++ < 10) continue;
                countDown = 0;
                inc += inc;
            }
        }
        if (wf.debug) {
            System.out.println();
        }
        return null;
    }

    private List<SearchVertex> getOptimizedList(SearchVertex initialThread) {
        ArrayList<SearchVertex> realVertices = new ArrayList<SearchVertex>();
        SearchVertex thread = initialThread;
        if (thread != null) {
            SearchVertex lastVertex = thread;
            realVertices.add(lastVertex);
            thread = thread.last;
            while (thread != null) {
                if (lastVertex.getZ() != thread.getZ()) {
                    realVertices.add(thread);
                    lastVertex = thread;
                    thread = thread.last;
                    continue;
                }
                double dx = thread.getX() - lastVertex.getX();
                double dy = thread.getY() - lastVertex.getY();
                lastVertex = thread;
                thread = thread.last;
                while (!(thread == null || lastVertex.getZ() != thread.getZ() || thread.getX() - lastVertex.getX() != 0.0 && dx == 0.0 || thread.getY() - lastVertex.getY() != 0.0 && dy == 0.0)) {
                    lastVertex = thread;
                    thread = thread.last;
                }
                realVertices.add(lastVertex);
            }
        }
        return realVertices;
    }

    private double getJumpSize(double curX, double curY, int curZ, double dx, double dy, Wavefront wf) {
        Rectangle2D jumpBound = ((Wavefront)wf).nr.jumpBound;
        double width = Math.max(this.metalLayers[curZ].getMinWidth(), ((Wavefront)wf).nr.minWidth);
        double metalToMetal = wf.getSpacingRule(curZ, width, -1.0);
        double metalSpacing = width / 2.0 + metalToMetal;
        double lX = curX - metalSpacing;
        double hX = curX + metalSpacing;
        double lY = curY - metalSpacing;
        double hY = curY + metalSpacing;
        if (dx > 0.0) {
            hX = jumpBound.getMaxX() + metalSpacing;
        } else if (dx < 0.0) {
            lX = jumpBound.getMinX() - metalSpacing;
        } else if (dy > 0.0) {
            hY = jumpBound.getMaxY() + metalSpacing;
        } else if (dy < 0.0) {
            lY = jumpBound.getMinY() - metalSpacing;
        }
        RTNode rtree = this.metalTrees.get(this.metalLayers[curZ]);
        if (rtree != null) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
            RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
            while (sea.hasNext()) {
                Rectangle2D bound;
                SOGBound sBound = (SOGBound)sea.next();
                if (Math.abs(sBound.getNetID()) == ((Wavefront)wf).nr.netID || (bound = sBound.getBounds()).getMinX() >= hX || bound.getMaxX() <= lX || bound.getMinY() >= hY || bound.getMaxY() <= lY) continue;
                if (dx > 0.0 && bound.getMinX() < hX) {
                    hX = bound.getMinX();
                }
                if (dx < 0.0 && bound.getMaxX() > lX) {
                    lX = bound.getMaxX();
                }
                if (dy > 0.0 && bound.getMinY() < hY) {
                    hY = bound.getMinY();
                }
                if (!(dy < 0.0) || !(bound.getMaxY() > lY)) continue;
                lY = bound.getMaxY();
            }
        }
        if (dx > 0.0) {
            dx = this.downToGrain(hX - metalSpacing) - curX;
            if (curX + dx > wf.toX && curY == wf.toY && curZ == wf.toZ) {
                dx = wf.toX - curX;
            }
            if (curX + dx != wf.toX) {
                dx = this.downToGrainAlways(hX - metalSpacing) - curX;
            }
            return dx;
        }
        if (dx < 0.0) {
            dx = this.upToGrain(lX + metalSpacing) - curX;
            if (curX + dx < wf.toX && curY == wf.toY && curZ == wf.toZ) {
                dx = wf.toX - curX;
            }
            if (curX + dx != wf.toX) {
                dx = this.upToGrainAlways(lX + metalSpacing) - curX;
            }
            return dx;
        }
        if (dy > 0.0) {
            dy = this.downToGrain(hY - metalSpacing) - curY;
            if (curX == wf.toX && curY + dy > wf.toY && curZ == wf.toZ) {
                dy = wf.toY - curY;
            }
            if (curY + dy != wf.toY) {
                dy = this.downToGrainAlways(hY - metalSpacing) - curY;
            }
            return dy;
        }
        if (dy < 0.0) {
            dy = this.upToGrain(lY + metalSpacing) - curY;
            if (curX == wf.toX && curY + dy < wf.toY && curZ == wf.toZ) {
                dy = wf.toY - curY;
            }
            if (curY + dy != wf.toY) {
                dy = this.upToGrainAlways(lY + metalSpacing) - curY;
            }
            return dy;
        }
        return 0.0;
    }

    private double upToGrain(double v) {
        return v;
    }

    private double upToGrainAlways(double v) {
        return Math.ceil(v * 1.0) * 1.0;
    }

    private double downToGrain(double v) {
        return v;
    }

    private double downToGrainAlways(double v) {
        return Math.floor(v * 1.0) * 1.0;
    }

    private SOGBound getMetalBlockageAndNotch(Wavefront wf, int metNo, double halfWidth, double halfHeight, double x2, double y, SearchVertex svCurrent) {
        RoutingFrame.RoutingLayer layer = this.metalLayers[metNo];
        RTNode rtree = this.metalTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        int netID = ((Wavefront)wf).nr.netID;
        double minWidth = ((Wavefront)wf).nr.minWidth;
        double metLX = x2 - halfWidth;
        double metHX = x2 + halfWidth;
        double metLY = y - halfHeight;
        double metHY = y + halfHeight;
        Rectangle2D.Double metBound = new Rectangle2D.Double(metLX, metLY, metHX - metLX, metHY - metLY);
        double metWid = Math.min(halfWidth, halfHeight) * 2.0;
        double metLen = Math.max(halfWidth, halfHeight) * 2.0;
        double surround = this.metalLayers[metNo].getMaxSurround();
        double lX = metLX - surround;
        double hX = metHX + surround;
        double lY = metLY - surround;
        double hY = metHY + surround;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        ArrayList<Rectangle2D> recsOnPath = new ArrayList<Rectangle2D>();
        if (svCurrent != null) {
            List<SearchVertex> svList = this.getOptimizedList(svCurrent);
            for (int ind = 1; ind < svList.size(); ++ind) {
                Point2D.Double tail;
                SearchVertex sv = svList.get(ind);
                SearchVertex lastSv = svList.get(ind - 1);
                if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                if (sv.getZ() != lastSv.getZ()) {
                    List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), lastSv.getZ())].getVias();
                    int whichContact = lastSv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    RoutingFrame.RoutingContact np = mv.via;
                    AffineTransform trans = null;
                    if (mv.orientation != 0) {
                        trans = this.makePureTransform(mv.orientation);
                    }
                    List<RoutingFrame.RoutingGeometry> conPolys = np.getGeometry();
                    for (RoutingFrame.RoutingGeometry rg : conPolys) {
                        if (rg.getLayer() != layer) continue;
                        Rectangle2D bound = rg.getBounds();
                        if (trans != null) {
                            bound = (Rectangle2D)bound.clone();
                            DBMath.transformRect(bound, trans);
                        }
                        if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                        recsOnPath.add(bound);
                    }
                    continue;
                }
                RoutingFrame.RoutingLayer type = this.metalLayers[metNo];
                double width = Math.max(type.getMinWidth(), minWidth);
                Point2D.Double head2 = new Point2D.Double(sv.getX(), sv.getY());
                Rectangle2D bound = this.makeArcBox(head2, tail = new Point2D.Double(lastSv.getX(), lastSv.getY()), width);
                if (bound == null || bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                recsOnPath.add(bound);
            }
        }
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGBound sBound = (SOGBound)sea.next();
            Rectangle2D bound = sBound.getBounds();
            if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
            double drWid = Math.max(Math.min(bound.getWidth(), bound.getHeight()), metWid);
            double drLen = Math.max(Math.max(bound.getWidth(), bound.getHeight()), metLen);
            double spacing = wf.getSpacingRule(metNo, drWid, drLen);
            double lXAllow = metLX - spacing;
            double hXAllow = metHX + spacing;
            double lYAllow = metLY - spacing;
            double hYAllow = metHY + spacing;
            if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lXAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hXAllow) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lYAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hYAllow)) continue;
            if (Math.abs(sBound.getNetID()) == netID) {
                if (sBound.getNetID() < 0 || !this.foundANotch(rtree, metBound, sBound.bound, netID, recsOnPath, spacing)) continue;
                return sBound;
            }
            return sBound;
        }
        if (svCurrent != null) {
            double spacing = wf.getSpacingRule(metNo, metWid, metLen);
            List<SearchVertex> svList = this.getOptimizedList(svCurrent);
            for (int ind = 1; ind < svList.size(); ++ind) {
                Point2D.Double tail;
                SearchVertex sv = svList.get(ind);
                SearchVertex lastSv = svList.get(ind - 1);
                if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                if (sv.getZ() != lastSv.getZ()) {
                    List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), lastSv.getZ())].getVias();
                    int whichContact = lastSv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    RoutingFrame.RoutingContact np = mv.via;
                    AffineTransform trans = null;
                    if (mv.orientation != 0) {
                        trans = this.makePureTransform(mv.orientation);
                    }
                    List<RoutingFrame.RoutingGeometry> conPolys = np.getGeometry();
                    for (RoutingFrame.RoutingGeometry rg : conPolys) {
                        if (rg.getLayer() != layer) continue;
                        Rectangle2D bound = rg.getBounds();
                        if (trans != null) {
                            bound = (Rectangle2D)bound.clone();
                            DBMath.transformRect(bound, trans);
                        }
                        if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                        SOGBound sBound = new SOGBound(bound, netID);
                        if (!this.foundANotch(rtree, metBound, bound, netID, recsOnPath, spacing)) continue;
                        return sBound;
                    }
                    continue;
                }
                RoutingFrame.RoutingLayer type = this.metalLayers[metNo];
                double width = Math.max(type.getMinWidth(), minWidth);
                Point2D.Double head3 = new Point2D.Double(sv.getX(), sv.getY());
                Rectangle2D bound = this.makeArcBox(head3, tail = new Point2D.Double(lastSv.getX(), lastSv.getY()), width);
                if (bound == null || bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                SOGBound sBound = new SOGBound(bound, netID);
                if (!this.foundANotch(rtree, metBound, bound, netID, recsOnPath, spacing)) continue;
                return sBound;
            }
        }
        return null;
    }

    private AffineTransform makePureTransform(int angle) {
        double sin0;
        double cos0;
        int sect = angle / 45;
        int ang = angle % 45;
        if (sect % 2 != 0) {
            ang = 45 - ang;
        }
        if (ang == 0) {
            cos0 = 1.0;
            sin0 = 0.0;
        } else if (ang == 45) {
            cos0 = sin0 = StrictMath.sqrt(0.5);
        } else {
            double alpha = (double)ang * Math.PI / 180.0;
            cos0 = StrictMath.cos(alpha);
            sin0 = StrictMath.sin(alpha);
        }
        double cos = 0.0;
        double sin = 0.0;
        switch (sect) {
            case 0: {
                cos = cos0;
                sin = sin0;
                break;
            }
            case 1: {
                cos = sin0;
                sin = cos0;
                break;
            }
            case 2: {
                cos = -sin0;
                sin = cos0;
                break;
            }
            case 3: {
                cos = -cos0;
                sin = sin0;
                break;
            }
            case 4: {
                cos = -cos0;
                sin = -sin0;
                break;
            }
            case 5: {
                cos = -sin0;
                sin = -cos0;
                break;
            }
            case 6: {
                cos = sin0;
                sin = -cos0;
                break;
            }
            case 7: {
                cos = cos0;
                sin = -sin0;
            }
        }
        double[] matrix = new double[]{cos, sin, sin, cos};
        return new AffineTransform(matrix);
    }

    private boolean foundANotch(RTNode rtree, Rectangle2D metBound, Rectangle2D bound, int netID, List<Rectangle2D> recsOnPath, double dist) {
        boolean vOverlap;
        boolean hOverlap = metBound.getMinX() <= bound.getMaxX() && metBound.getMaxX() >= bound.getMinX();
        boolean bl = vOverlap = metBound.getMinY() <= bound.getMaxY() && metBound.getMaxY() >= bound.getMinY();
        if (hOverlap && vOverlap) {
            return false;
        }
        if (hOverlap) {
            double ptY;
            if (metBound.getCenterY() > bound.getCenterY()) {
                if (metBound.getMinY() - bound.getMaxY() > dist) {
                    return false;
                }
                ptY = (metBound.getMinY() + bound.getMaxY()) / 2.0;
            } else {
                if (bound.getMinY() - metBound.getMaxY() > dist) {
                    return false;
                }
                ptY = (metBound.getMaxY() + bound.getMinY()) / 2.0;
            }
            double pt1X = Math.max(metBound.getMinX(), bound.getMinX());
            double pt2X = Math.min(metBound.getMaxX(), bound.getMaxX());
            double pt3X = (pt1X + pt2X) / 2.0;
            if (!this.pointInRTree(rtree, pt1X, ptY, netID, recsOnPath)) {
                return true;
            }
            if (!this.pointInRTree(rtree, pt2X, ptY, netID, recsOnPath)) {
                return true;
            }
            return !this.pointInRTree(rtree, pt3X, ptY, netID, recsOnPath);
        }
        if (vOverlap) {
            double ptX;
            if (metBound.getCenterX() > bound.getCenterX()) {
                if (metBound.getMinX() - bound.getMaxX() > dist) {
                    return false;
                }
                ptX = (metBound.getMinX() + bound.getMaxX()) / 2.0;
            } else {
                if (bound.getMinX() - metBound.getMaxX() > dist) {
                    return false;
                }
                ptX = (metBound.getMaxX() + bound.getMinX()) / 2.0;
            }
            double pt1Y = Math.max(metBound.getMinY(), bound.getMinY());
            double pt2Y = Math.min(metBound.getMaxY(), bound.getMaxY());
            double pt3Y = (pt1Y + pt2Y) / 2.0;
            if (!this.pointInRTree(rtree, ptX, pt1Y, netID, recsOnPath)) {
                return true;
            }
            if (!this.pointInRTree(rtree, ptX, pt2Y, netID, recsOnPath)) {
                return true;
            }
            return !this.pointInRTree(rtree, ptX, pt3Y, netID, recsOnPath);
        }
        if (metBound.getMinX() > bound.getMaxX() && metBound.getMinY() > bound.getMaxY()) {
            double pt2Y;
            double pt1X = metBound.getMinX();
            double pt1Y = bound.getMaxY();
            double pt2X = bound.getMaxX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMaxX() < bound.getMinX() && metBound.getMinY() > bound.getMaxY()) {
            double pt2Y;
            double pt1X = metBound.getMaxX();
            double pt1Y = bound.getMaxY();
            double pt2X = bound.getMinX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMaxX() < bound.getMinX() && metBound.getMaxY() < bound.getMinY()) {
            double pt2Y;
            double pt1X = metBound.getMaxX();
            double pt1Y = bound.getMinY();
            double pt2X = bound.getMinX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMinX() > bound.getMaxX() && metBound.getMaxY() < bound.getMinY()) {
            double pt2Y;
            double pt1X = metBound.getMinX();
            double pt1Y = bound.getMinY();
            double pt2X = bound.getMaxX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        return false;
    }

    private boolean pointInRTree(RTNode rtree, double x2, double y, int netID, List<Rectangle2D> recsOnPath) {
        Rectangle2D.Double searchArea = new Rectangle2D.Double(x2, y, 0.0, 0.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGBound sBound = (SOGBound)sea.next();
            if (sBound.netID != netID || sBound.bound.getMinX() > x2 || sBound.bound.getMaxX() < x2 || sBound.bound.getMinY() > y || sBound.bound.getMaxY() < y) continue;
            return true;
        }
        for (Rectangle2D bound : recsOnPath) {
            if (bound.getMinX() > x2 || bound.getMaxX() < x2 || bound.getMinY() > y || bound.getMaxY() < y) continue;
            return true;
        }
        return false;
    }

    private SOGBound getMetalBlockage(int netID, int metNo, double halfWidth, double halfHeight, double surround, double x2, double y) {
        RoutingFrame.RoutingLayer layer = this.metalLayers[metNo];
        RTNode rtree = this.metalTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        double lX = x2 - halfWidth - surround;
        double hX = x2 + halfWidth + surround;
        double lY = y - halfHeight - surround;
        double hY = y + halfHeight + surround;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGBound sBound = (SOGBound)sea.next();
            Rectangle2D bound = sBound.getBounds();
            if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lX) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hX) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lY) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hY) || Math.abs(sBound.getNetID()) == netID) continue;
            return sBound;
        }
        return null;
    }

    private SOGVia getViaBlockage(int netID, RoutingFrame.RoutingLayer layer, double halfWidth, double halfHeight, double x2, double y) {
        RTNode rtree = this.viaTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        Rectangle2D.Double searchArea = new Rectangle2D.Double(x2 - halfWidth, y - halfHeight, halfWidth * 2.0, halfHeight * 2.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGVia sLoc = (SOGVia)sea.next();
            if (sLoc.getNetID() == netID && sLoc.loc.getX() == x2 && sLoc.loc.getY() == y) continue;
            return sLoc;
        }
        return null;
    }

    private void addLayer(RoutingFrame.RoutingLayer layer, Rectangle2D box, AffineTransform trans, int netID, boolean canPlacePseudo) {
        if (layer.isMetal()) {
            this.addRectangle(box, layer, netID);
        } else {
            this.addVia(new Point2D.Double(box.getCenterX(), box.getCenterY()), layer, netID);
        }
    }

    private void addRectangle(Rectangle2D bounds, RoutingFrame.RoutingLayer layer, int netID) {
        RTNode newRoot;
        RTNode root2 = this.metalTrees.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new SOGBound(bounds, netID))) != root2) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addVia(Point2D loc, RoutingFrame.RoutingLayer layer, int netID) {
        RTNode newRoot;
        RTNode root2 = this.viaTrees.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.viaTrees.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new SOGVia(loc, netID))) != root2) {
            this.viaTrees.put(layer, newRoot);
        }
    }

    private class SearchVertex
    implements Comparable<SearchVertex> {
        private double xv;
        private double yv;
        private int zv;
        private int cost;
        private int cutLayer;
        private Point2D[] cuts;
        private SearchVertex last;
        private Wavefront w;

        SearchVertex(double x2, double y, int z, int whichContact, Point2D[] cuts, int cl, Wavefront w) {
            this.xv = x2;
            this.yv = y;
            this.zv = (z << 8) + (whichContact & 0xFF);
            this.cuts = cuts;
            this.cutLayer = cl;
            this.w = w;
        }

        double getX() {
            return this.xv;
        }

        double getY() {
            return this.yv;
        }

        int getZ() {
            return this.zv >> 8;
        }

        int getContactNo() {
            return this.zv & 0xFF;
        }

        Point2D[] getCuts() {
            return this.cuts;
        }

        void clearCuts() {
            this.cuts = null;
        }

        int getCutLayer() {
            return this.cutLayer;
        }

        @Override
        public int compareTo(SearchVertex sv) {
            int diff2 = this.cost - sv.cost;
            if (diff2 != 0) {
                return diff2;
            }
            if (this.w != null) {
                double otherDist;
                double thisDist = Math.abs(this.xv - this.w.toX) + Math.abs(this.yv - this.w.toY) + (double)Math.abs(this.zv - this.w.toZ);
                if (thisDist < (otherDist = Math.abs(sv.xv - this.w.toX) + Math.abs(sv.yv - this.w.toY) + (double)Math.abs(sv.zv - this.w.toZ))) {
                    return -1;
                }
                if (thisDist > otherDist) {
                    return 1;
                }
            }
            return 0;
        }
    }

    private static class PrimsBySize
    implements Comparator<MetalVia> {
        private PrimsBySize() {
        }

        @Override
        public int compare(MetalVia mv1, MetalVia mv2) {
            double sz2;
            RoutingFrame.RoutingContact pn1 = mv1.via;
            RoutingFrame.RoutingContact pn2 = mv2.via;
            double sz1 = pn1.getDefWidth() * pn1.getDefHeight();
            if (sz1 < (sz2 = pn2.getDefWidth() * pn2.getDefHeight())) {
                return -1;
            }
            if (sz1 > sz2) {
                return 1;
            }
            return 0;
        }
    }

    private static class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(RoutingFrame.RoutingContact pn, int o) {
            this.vias.add(new MetalVia(pn, o));
            Collections.sort(this.vias, new PrimsBySize());
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        RoutingFrame.RoutingContact via;
        int orientation;

        MetalVia(RoutingFrame.RoutingContact v, int o) {
            this.via = v;
            this.orientation = o;
        }
    }

    private static class SOGVia
    implements RTBounds {
        private Point2D loc;
        private int netID;

        SOGVia(Point2D loc, int netID) {
            this.loc = loc;
            this.netID = netID;
        }

        @Override
        public Rectangle2D getBounds() {
            return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGVia on net " + this.netID;
        }
    }

    private static class SOGBound
    implements RTBounds {
        private Rectangle2D bound;
        private int netID;

        SOGBound(Rectangle2D bound, int netID) {
            this.bound = bound;
            this.netID = netID;
        }

        @Override
        public Rectangle2D getBounds() {
            return this.bound;
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGBound on net " + this.netID;
        }
    }

    private class DijkstraInThread
    extends Thread {
        private Wavefront wf;
        private Wavefront otherWf;
        private Semaphore whenDone;
        private Environment env;
        private EditingPreferences ep;

        public DijkstraInThread(String name, Wavefront wf, Wavefront otherWf, Semaphore whenDone, Environment env, EditingPreferences ep) {
            super(name);
            this.wf = wf;
            this.otherWf = otherWf;
            this.whenDone = whenDone;
            this.env = env;
            this.ep = ep;
            this.start();
        }

        @Override
        public void run() {
            Environment.setThreadEnvironment(this.env);
            EditingPreferences.setThreadEditingPreferences(this.ep);
            SearchVertex result2 = null;
            int numSearchVertices = 0;
            while (result2 == null) {
                if (++numSearchVertices > RoutingFrameSeaOfGates.this.complexityLimit.getIntValue()) {
                    result2 = RoutingFrameSeaOfGates.this.svLimited;
                    continue;
                }
                if (this.wf.abort) {
                    result2 = RoutingFrameSeaOfGates.this.svAborted;
                    continue;
                }
                result2 = RoutingFrameSeaOfGates.this.advanceWavefront(this.wf);
            }
            if (result2 != RoutingFrameSeaOfGates.this.svAborted && result2 != RoutingFrameSeaOfGates.this.svExhausted && result2 != RoutingFrameSeaOfGates.this.svLimited) {
                this.wf.vertices = RoutingFrameSeaOfGates.this.getOptimizedList(result2);
                ((Wavefront)this.wf).nr.winningWF = this.wf;
                this.otherWf.abort = true;
            }
            this.whenDone.release();
        }
    }

    private class RouteInThread
    extends Thread {
        private Semaphore inSem;
        private NeededRoute nr;
        private Semaphore whenDone;
        private Environment env;
        private EditingPreferences ep;

        public RouteInThread(String name, Environment env, EditingPreferences ep) {
            super(name);
            this.inSem = new Semaphore(0);
            this.env = env;
            this.ep = ep;
            this.start();
        }

        public void startRoute(NeededRoute nr, Semaphore whenDone) {
            this.nr = nr;
            this.whenDone = whenDone;
            this.inSem.release();
        }

        @Override
        public void run() {
            Environment.setThreadEnvironment(this.env);
            EditingPreferences.setThreadEditingPreferences(this.ep);
            while (true) {
                this.inSem.acquireUninterruptibly();
                if (this.nr == null) {
                    return;
                }
                RoutingFrameSeaOfGates.this.findPath(this.nr, this.env, this.ep);
                this.whenDone.release();
            }
        }
    }

    private class NeededRoute {
        String routeName;
        int netID;
        double minWidth;
        int batchNumber;
        int routeInBatch;
        Rectangle2D routeBounds;
        double minimumSearchBoundX;
        double maximumSearchBoundX;
        double minimumSearchBoundY;
        double maximumSearchBoundY;
        Rectangle2D jumpBound;
        Wavefront dir1;
        Wavefront dir2;
        Wavefront winningWF;
        RoutingFrame.RoutingSegment rs;

        NeededRoute(String routeName, double fromX, double fromY, int fromZ, double toX, double toY, int toZ, int netID, double minWidth, int batchNumber, int routeInBatch, RoutingFrame.RoutingSegment rs) {
            this.routeName = routeName;
            this.netID = netID;
            this.minWidth = minWidth;
            this.batchNumber = batchNumber;
            this.routeInBatch = routeInBatch;
            this.rs = rs;
            RoutingFrameSeaOfGates.this.cellBounds = RoutingFrameSeaOfGates.this.cell.getBounds();
            this.minimumSearchBoundX = RoutingFrameSeaOfGates.this.downToGrain(RoutingFrameSeaOfGates.this.cellBounds.getMinX());
            this.maximumSearchBoundX = RoutingFrameSeaOfGates.this.upToGrain(RoutingFrameSeaOfGates.this.cellBounds.getMaxX());
            this.minimumSearchBoundY = RoutingFrameSeaOfGates.this.downToGrain(RoutingFrameSeaOfGates.this.cellBounds.getMinY());
            this.maximumSearchBoundY = RoutingFrameSeaOfGates.this.upToGrain(RoutingFrameSeaOfGates.this.cellBounds.getMaxY());
            double maxStrayFromRouteBounds = Math.min(RoutingFrameSeaOfGates.this.cellBounds.getWidth(), RoutingFrameSeaOfGates.this.cellBounds.getHeight()) * 7.0 / 100.0;
            this.routeBounds = new Rectangle2D.Double(Math.min(fromX, toX) - maxStrayFromRouteBounds, Math.min(fromY, toY) - maxStrayFromRouteBounds, Math.abs(fromX - toX) + maxStrayFromRouteBounds * 2.0, Math.abs(fromY - toY) + maxStrayFromRouteBounds * 2.0);
            this.minimumSearchBoundX = this.routeBounds.getMinX();
            this.maximumSearchBoundX = this.routeBounds.getMaxX();
            this.minimumSearchBoundY = this.routeBounds.getMinY();
            this.maximumSearchBoundY = this.routeBounds.getMaxY();
            this.jumpBound = new Rectangle2D.Double(Math.min(fromX, toX), Math.min(fromY, toY), Math.abs(fromX - toX), Math.abs(fromY - toY));
            this.dir1 = new Wavefront(this, rs.getStartEnd(), fromX, fromY, fromZ, rs.getFinishEnd(), toX, toY, toZ, "a->b", false);
            this.dir2 = new Wavefront(this, rs.getFinishEnd(), toX, toY, toZ, rs.getStartEnd(), fromX, fromY, fromZ, "b->a", false);
        }

        public void cleanSearchMemory() {
            Wavefront.access$702(this.dir1, null);
            this.dir1.active = null;
            if (this.dir1.vertices != null) {
                for (SearchVertex sv : this.dir1.vertices) {
                    sv.clearCuts();
                }
            }
            Wavefront.access$702(this.dir2, null);
            this.dir2.active = null;
            if (this.dir2.vertices != null) {
                for (SearchVertex sv : this.dir2.vertices) {
                    sv.clearCuts();
                }
            }
        }
    }

    private class Wavefront {
        private NeededRoute nr;
        private String name;
        private TreeSet<SearchVertex> active;
        private List<SearchVertex> vertices;
        private boolean abort;
        private RoutingFrame.RoutingEnd from;
        private RoutingFrame.RoutingEnd to;
        private double fromX;
        private double fromY;
        private int fromZ;
        private double toX;
        private double toY;
        private int toZ;
        private final boolean debug;
        private Map<Double, Set<Double>>[] searchVertexPlanesDBL;
        private Map<Double, Map<Double, Double>>[] layerSurround;

        Wavefront(NeededRoute nr, RoutingFrame.RoutingEnd from2, double fromX, double fromY, int fromZ, RoutingFrame.RoutingEnd to2, double toX, double toY, int toZ, String name, boolean debug) {
            this.nr = nr;
            this.from = from2;
            this.fromX = fromX;
            this.fromY = fromY;
            this.fromZ = fromZ;
            this.to = to2;
            this.toX = toX;
            this.toY = toY;
            this.toZ = toZ;
            this.name = name;
            this.debug = debug;
            this.active = new TreeSet();
            this.vertices = null;
            this.abort = false;
            this.searchVertexPlanesDBL = new Map[RoutingFrameSeaOfGates.this.numMetalLayers];
            this.layerSurround = new Map[RoutingFrameSeaOfGates.this.numMetalLayers];
            for (int i = 0; i < RoutingFrameSeaOfGates.this.numMetalLayers; ++i) {
                this.layerSurround[i] = new HashMap<Double, Map<Double, Double>>();
            }
            if (debug) {
                System.out.println("----------- SEARCHING FROM (" + TextUtils.formatDouble(fromX) + "," + TextUtils.formatDouble(fromY) + ",M" + (fromZ + 1) + ") TO (" + TextUtils.formatDouble(toX) + "," + TextUtils.formatDouble(toY) + ",M" + (toZ + 1) + ") -----------");
            }
            SearchVertex svStart = new SearchVertex(fromX, fromY, fromZ, 0, null, 0, this);
            svStart.cost = 0;
            this.setVertex(fromX, fromY, fromZ);
            this.active.add(svStart);
        }

        public boolean getVertex(double x2, double y, int z) {
            Map<Double, Set<Double>> plane = this.searchVertexPlanesDBL[z];
            if (plane == null) {
                return false;
            }
            Set<Double> row = plane.get(new Double(y));
            if (row == null) {
                return false;
            }
            boolean found = row.contains(new Double(x2));
            return found;
        }

        public void setVertex(double x2, double y, int z) {
            Double iY;
            Set<Double> row;
            Map<Double, Set<Double>> plane = this.searchVertexPlanesDBL[z];
            if (plane == null) {
                this.searchVertexPlanesDBL[z] = plane = new HashMap<Double, Set<Double>>();
            }
            if ((row = plane.get(iY = new Double(y))) == null) {
                row = new HashSet<Double>();
                plane.put(iY, row);
            }
            row.add(new Double(x2));
        }

        public double getSpacingRule(int layer, double width, double length) {
            Double value2;
            if (width < 0.0) {
                width = RoutingFrameSeaOfGates.this.metalLayers[layer].getMinWidth();
            }
            if (length < 0.0) {
                length = 50.0;
            }
            Double wid = new Double(RoutingFrameSeaOfGates.this.upToGrain(width));
            Double len = new Double(RoutingFrameSeaOfGates.this.upToGrain(length));
            Map<Double, Double> widMap = this.layerSurround[layer].get(wid);
            if (widMap == null) {
                widMap = new HashMap<Double, Double>();
                this.layerSurround[layer].put(wid, widMap);
            }
            if ((value2 = widMap.get(len)) == null) {
                RoutingFrame.RoutingLayer lay = RoutingFrameSeaOfGates.this.metalLayers[layer];
                double v = lay.getMinSpacing(lay);
                value2 = new Double(v);
                widMap.put(len, value2);
            }
            return value2;
        }

        static /* synthetic */ Map[] access$702(Wavefront x0, Map[] x1) {
            x0.searchVertexPlanesDBL = x1;
            return x1;
        }
    }

    private static class RouteBatches {
        int segsInBatch;

        private RouteBatches() {
        }
    }
}

