/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.CapLayer;
import com.sun.electric.tool.generator.layout.fill.ExportConfig;
import com.sun.electric.tool.generator.layout.fill.Floorplan;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fill.MetalLayer;
import com.sun.electric.tool.generator.layout.fill.MetalLayerFlex;
import com.sun.electric.tool.generator.layout.fill.VddGndStraps;

public class FillCell {
    public static final String VDD_NAME = "vdd";
    public static final String GND_NAME = "gnd";
    public static final PortCharacteristic VDD_CHARACTERISTIC = PortCharacteristic.PWR;
    public static final PortCharacteristic GND_CHARACTERISTIC = PortCharacteristic.GND;
    private int vddNum;
    private int gndNum;
    private final TechType tech;

    private String vddName() {
        int n = this.vddNum++;
        return VDD_NAME + (n == 0 ? "" : "_" + n);
    }

    private String gndName() {
        int n = this.gndNum++;
        return GND_NAME + (n == 0 ? "" : "_" + n);
    }

    public void exportPerimeter(VddGndStraps lay, Cell cell) {
        int i;
        for (i = 0; i < lay.numGnd(); ++i) {
            this.exportStripeEnds(i, lay, true, cell);
        }
        for (i = 0; i < lay.numVdd(); ++i) {
            this.exportStripeEnds(i, lay, false, cell);
        }
    }

    public void exportPerimeter(VddGndStraps[] lays, int botLay, int topLay, ExportConfig exptConfig, Cell cell) {
        int[] perim = exptConfig.getPerimeterExports(botLay, topLay);
        for (int i = 0; i < perim.length; ++i) {
            VddGndStraps lay = lays[perim[i]];
            if (lay == null) continue;
            this.exportPerimeter(lay, cell);
        }
    }

    private void exportStripeEnds(int n, VddGndStraps lay, boolean gnd, Cell cell) {
        PortInst piRight;
        PrimitiveNode pin = lay.getPinType();
        ArcProto metal = lay.getMetalType();
        double edge = (lay.isHorizontal() ? lay.getCellWidth() : lay.getCellHeight()) / 2.0;
        double center = gnd ? lay.getGndCenter(n) : lay.getVddCenter(n);
        double width = gnd ? lay.getGndWidth(n) : lay.getVddWidth(n);
        PortInst piLeft = gnd ? lay.getGnd(n, 0) : lay.getVdd(n, 0);
        PortInst portInst = piRight = gnd ? lay.getGnd(n, 1) : lay.getVdd(n, 1);
        if (lay.isHorizontal()) {
            this.export(-edge, center, pin, metal, piLeft, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
            this.export(edge, center, pin, metal, piRight, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
        } else {
            this.export(center, -edge, pin, metal, piLeft, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
            this.export(center, edge, pin, metal, piRight, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
        }
    }

    private void export(double x2, double y, PrimitiveNode pin, ArcProto metal, PortInst conn, double w, String name, boolean gnd, Cell cell, boolean withExtraArc) {
        Export e = null;
        e = Export.newInstance(cell, conn, name);
        e.setCharacteristic(gnd ? GND_CHARACTERISTIC : VDD_CHARACTERISTIC);
    }

    public void exportWiring(VddGndStraps lay, Cell cell) {
        int i;
        for (i = 0; i < lay.numGnd(); ++i) {
            this.exportStripeCenter(i, lay, true, cell);
        }
        for (i = 0; i < lay.numVdd(); ++i) {
            this.exportStripeCenter(i, lay, false, cell);
        }
    }

    public void exportWiring(VddGndStraps[] lays, int botLay, int topLay, ExportConfig exptConfig, Cell cell) {
        int[] intnl = exptConfig.getInternalExports(botLay, topLay);
        for (int i = 0; i < intnl.length; ++i) {
            VddGndStraps lay = lays[intnl[i]];
            if (lay == null) continue;
            this.exportWiring(lay, cell);
        }
    }

    private void exportStripeCenter(int n, VddGndStraps lay, boolean gnd, Cell cell) {
        PortInst pi;
        PrimitiveNode pin = lay.getPinType();
        ArcProto metal = lay.getMetalType();
        double center = gnd ? lay.getGndCenter(n) : lay.getVddCenter(n);
        double width = gnd ? lay.getGndWidth(n) : lay.getVddWidth(n);
        PortInst portInst = pi = gnd ? lay.getGnd(n, 0) : lay.getVdd(n, 0);
        if (lay.isHorizontal()) {
            this.export(0.0, center, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
        } else {
            this.export(center, 0.0, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
        }
    }

    private void appendExportLayerNumbers(StringBuffer buf, String type, int[] layerNbs) {
        if (layerNbs.length > 0) {
            buf.append(type);
            for (int i = 0; i < layerNbs.length; ++i) {
                buf.append(layerNbs[i]);
            }
        }
    }

    private String fillName(int lo, int hi, ExportConfig expConfig) {
        StringBuffer buf = new StringBuffer();
        buf.append("fill");
        if (lo != 1 || hi != this.tech.getNumMetals()) {
            for (int i = lo; i <= hi; ++i) {
                buf.append(i);
            }
        }
        if (expConfig != ExportConfig.PERIMETER) {
            if (expConfig == ExportConfig.PERIMETER_AND_INTERNAL) {
                buf.append("w");
            } else {
                int[] perim = expConfig.getPerimeterExports(lo, hi);
                this.appendExportLayerNumbers(buf, "p", perim);
                int[] intnl = expConfig.getInternalExports(lo, hi);
                this.appendExportLayerNumbers(buf, "w", intnl);
            }
        }
        buf.append("{lay}");
        return buf.toString();
    }

    private VddGndStraps[] findHoriVert(VddGndStraps lay1, VddGndStraps lay2) {
        if (lay1.isHorizontal()) {
            Job.error(lay2.isHorizontal(), "adjacent layers both horizontal");
            return new VddGndStraps[]{lay1, lay2};
        }
        Job.error(!lay2.isHorizontal(), "adjacent layers both vertical");
        return new VddGndStraps[]{lay2, lay1};
    }

    private void connectVddStraps(VddGndStraps horLay, int horNdx, VddGndStraps verLay, int verNdx, Cell cell) {
        double w = verLay.getVddWidth(verNdx);
        double x2 = verLay.getVddCenter(verNdx);
        ArcProto verMetal = verLay.getMetalType();
        PortInst verPort = horNdx % 2 == 0 ? verLay.getVdd(verNdx, 0) : verLay.getVdd(verNdx, 1);
        double h = horLay.getVddWidth(horNdx);
        double y = horLay.getVddCenter(horNdx);
        ArcProto horMetal = horLay.getMetalType();
        PrimitiveNode viaType = this.tech.getViaFor(verMetal, horMetal);
        PortInst horPort = verNdx % 2 == 0 ? horLay.getVdd(horNdx, 0) : horLay.getVdd(horNdx, 1);
        Job.error(viaType == null, "can't find via for metal layers " + verMetal + " " + horMetal);
        ViaDim d = new ViaDim(horLay, x2, y, w, h);
        PortInst via = LayoutLib.newNodeInst(viaType, d.x, d.y, d.w, d.h, 0.0, cell).getOnlyPortInst();
        G.noExtendArc(horMetal, h, horPort, via);
        G.noExtendArc(verMetal, w, via, verPort);
    }

    private void connectGndStraps(VddGndStraps horLay, int horNdx, VddGndStraps verLay, int verNdx, Cell cell) {
        double w = verLay.getGndWidth(verNdx);
        double x2 = verLay.getGndCenter(verNdx);
        ArcProto verMetal = verLay.getMetalType();
        PortInst verPort = horNdx % 2 == 0 ? verLay.getGnd(verNdx, 0) : verLay.getGnd(verNdx, 1);
        double h = horLay.getGndWidth(horNdx);
        double y = horLay.getGndCenter(horNdx);
        ArcProto horMetal = horLay.getMetalType();
        PrimitiveNode viaType = this.tech.getViaFor(verMetal, horMetal);
        PortInst horPort = verNdx % 2 == 0 ? horLay.getGnd(horNdx, 0) : horLay.getGnd(horNdx, 1);
        Job.error(viaType == null, "can't find via for metal layers");
        ViaDim d = new ViaDim(horLay, x2, y, w, h);
        PortInst via = LayoutLib.newNodeInst(viaType, d.x, d.y, d.w, d.h, 0.0, cell).getOnlyPortInst();
        G.noExtendArc(horMetal, h, horPort, via);
        G.noExtendArc(verMetal, w, via, verPort);
    }

    private void connectLayers(VddGndStraps loLayer, VddGndStraps hiLayer, Cell cell) {
        int v;
        int h;
        VddGndStraps[] layers = this.findHoriVert(loLayer, hiLayer);
        VddGndStraps horLay = layers[0];
        VddGndStraps verLay = layers[1];
        for (h = 0; h < horLay.numVdd(); ++h) {
            for (v = 0; v < verLay.numVdd(); ++v) {
                this.connectVddStraps(horLay, h, verLay, v, cell);
            }
        }
        for (h = 0; h < horLay.numGnd(); ++h) {
            for (v = 0; v < verLay.numGnd(); ++v) {
                this.connectGndStraps(horLay, h, verLay, v, cell);
            }
        }
    }

    protected Cell makeFillCell1(Library lib, Floorplan[] plans, int botLayer, int topLayer, CapCell capCell, ExportConfig expCfg, boolean metalFlex, boolean hierFlex) {
        String name = this.fillName(botLayer, topLayer, expCfg);
        Cell cell = Cell.newInstance(lib, name);
        VddGndStraps[] layers = new VddGndStraps[topLayer + 1];
        for (int i = topLayer; i >= botLayer; --i) {
            layers[i] = i == 1 ? new CapLayer(this.tech, (CapFloorplan)plans[i], capCell, cell) : (metalFlex && !hierFlex ? new MetalLayerFlex(this.tech, i, plans[i], cell) : new MetalLayer(this.tech, i, plans[i], cell));
            if (i == topLayer) continue;
            this.connectLayers(layers[i], layers[i + 1], cell);
        }
        this.exportPerimeter(layers, botLayer, topLayer, expCfg, cell);
        this.exportWiring(layers, botLayer, topLayer, expCfg, cell);
        double cellWidth = plans[topLayer].cellWidth;
        double cellHeight = plans[topLayer].cellHeight;
        LayoutLib.newNodeInst(this.tech.essentialBounds(), -cellWidth / 2.0, -cellHeight / 2.0, G.DEF_SIZE, G.DEF_SIZE, 180.0, cell);
        LayoutLib.newNodeInst(this.tech.essentialBounds(), cellWidth / 2.0, cellHeight / 2.0, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell);
        return cell;
    }

    protected FillCell(TechType tech) {
        this.tech = tech;
    }

    private static class ViaDim {
        public final double x;
        public final double y;
        public final double w;
        public final double h;

        public ViaDim(VddGndStraps lay, double x2, double y, double w, double h) {
            if (x2 + w / 2.0 == lay.getCellWidth() / 2.0) {
                w -= 1.0;
                x2 -= 0.5;
            } else if (x2 - w / 2.0 == -lay.getCellWidth() / 2.0) {
                w -= 1.0;
                x2 += 0.5;
            }
            if (y + h / 2.0 == lay.getCellHeight() / 2.0) {
                h -= 1.0;
                y -= 0.5;
            } else if (y - h / 2.0 == -lay.getCellHeight() / 2.0) {
                h -= 1.0;
                y += 0.5;
            }
            this.x = x2;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

