/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.tool.project.Project;
import com.sun.electric.util.TextUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Users {
    public static final boolean LOWSECURITY = true;
    private static final String PUSERFILE = "projectusers";
    private static HashMap<String, String> usersMap;
    private static final int ROTORSZ = 256;
    private static final int MASK = 255;

    public static int getNumUsers() {
        Users.ensureUserList();
        return usersMap.size();
    }

    public static Iterator<String> getUsers() {
        Users.ensureUserList();
        return usersMap.keySet().iterator();
    }

    public static boolean isExistingUser(String user) {
        Users.ensureUserList();
        return usersMap.get(user) != null;
    }

    public static void deleteUser(String user) {
        usersMap.remove(user);
        Users.saveUserList();
    }

    public static void addUser(String user, String encryptedPassword) {
        usersMap.put(user, encryptedPassword);
        Users.saveUserList();
    }

    public static String getEncryptedPassword(String user) {
        return usersMap.get(user);
    }

    public static void changeEncryptedPassword(String user, String newEncryptedPassword) {
        usersMap.put(user, newEncryptedPassword);
        Users.saveUserList();
    }

    static boolean needUserName() {
        Project.pmActive = true;
        if (Project.getCurrentUserName().length() == 0) {
            Project.setCurrentUserName(System.getProperty("user.name"));
            return false;
        }
        return false;
    }

    private static void ensureUserList() {
        if (usersMap == null) {
            usersMap = new HashMap();
            String userFile = Project.getRepositoryLocation() + File.separator + PUSERFILE;
            URL url = TextUtils.makeURLToFile(userFile);
            try {
                String userLine;
                URLConnection urlCon = url.openConnection();
                InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
                LineNumberReader lnr = new LineNumberReader(is);
                while ((userLine = lnr.readLine()) != null) {
                    int colonPos = userLine.indexOf(58);
                    if (colonPos < 0) {
                        System.out.println("Missing ':' in user file: " + userLine);
                        break;
                    }
                    String userName = userLine.substring(0, colonPos);
                    String encryptedPassword = userLine.substring(colonPos + 1);
                    usersMap.put(userName, encryptedPassword);
                }
                lnr.close();
            }
            catch (IOException e) {
                System.out.println("Creating new user database");
            }
        }
    }

    private static void saveUserList() {
        String userFile = Project.getRepositoryLocation() + File.separator + PUSERFILE;
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(userFile)));
            for (String userName : usersMap.keySet()) {
                String encryptedPassword = usersMap.get(userName);
                printWriter.println(userName + ":" + encryptedPassword);
            }
            printWriter.close();
            System.out.println("Wrote " + userFile);
        }
        catch (IOException e) {
            System.out.println("Error writing " + userFile);
            return;
        }
    }

    public static String encryptPassword(String text2) {
        int i;
        String key = "BicIsSchediwy";
        String readable = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-";
        int seed = 123;
        int keyLen = key.length();
        for (int i2 = 0; i2 < keyLen; ++i2) {
            seed = seed * key.charAt(i2) + i2;
        }
        char[] t1 = new char[256];
        char[] t2 = new char[256];
        char[] t3 = new char[256];
        char[] deck = new char[256];
        for (i = 0; i < 256; ++i) {
            t1[i] = (char)i;
            t3[i] = '\u0000';
            deck[i] = (char)i;
        }
        for (i = 0; i < 256; ++i) {
            seed = 5 * seed + key.charAt(i % keyLen);
            int random = seed % 65521;
            int k = 255 - i;
            int ic = (random & 0xFF) % (k + 1);
            random >>= 8;
            char temp = t1[k];
            t1[k] = t1[ic];
            t1[ic] = temp;
            if (t3[k] != '\u0000') continue;
            ic = (random & 0xFF) % k;
            while (t3[ic] != '\u0000') {
                ic = (ic + 1) % k;
            }
            t3[k] = (char)ic;
            t3[ic] = (char)k;
        }
        for (i = 0; i < 256; ++i) {
            t2[t1[i] & 0xFF] = (char)i;
        }
        int n1 = 0;
        int n2 = 0;
        int nr2 = 0;
        StringBuffer result2 = new StringBuffer();
        for (int pt = 0; pt < text2.length(); ++pt) {
            int nr1 = deck[n1] & 0xFF;
            nr2 = deck[nr1] & 0xFF;
            int i3 = t2[t3[t1[text2.charAt(pt) + nr1 & 0xFF] + nr2 & 0xFF] - nr2 & 0xFF] - nr1;
            result2.append(readable.charAt(i3 & 0x3F));
            if (++n1 != 256) continue;
            n1 = 0;
            if (++n2 == 256) {
                n2 = 0;
            }
            Users.shuffle(deck, key);
        }
        String res = result2.toString();
        return res;
    }

    private static void shuffle(char[] deck, String key) {
        int seed = 123;
        int keyLen = key.length();
        for (int i = 0; i < 256; ++i) {
            seed = 5 * seed + key.charAt(i % keyLen);
            int random = seed % 65521;
            int k = 255 - i;
            int ic = (random & 0xFF) % (k + 1);
            char temp = deck[k];
            deck[k] = deck[ic];
            deck[ic] = temp;
        }
    }
}

