/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementMinCut;
import com.sun.electric.tool.placement.PlacementRandom;
import com.sun.electric.tool.placement.PlacementSimple;
import com.sun.electric.tool.placement.forceDirected1.PlacementForceDirectedTeam5;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import com.sun.electric.tool.placement.genetic2.PlacementGenetic;
import com.sun.electric.tool.placement.simulatedAnnealing1.SimulatedAnnealing;
import com.sun.electric.tool.placement.simulatedAnnealing2.PlacementSimulatedAnnealing;
import com.sun.electric.tool.user.IconParameters;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementFrame {
    private static PlacementFrame[] placementAlgorithms = new PlacementFrame[]{new SimulatedAnnealing(), new PlacementSimulatedAnnealing(), new GeneticPlacement(), new PlacementGenetic(), new PlacementForceDirectedTeam5(), new PlacementForceDirectedStaged(), new PlacementMinCut(), new PlacementSimple(), new PlacementRandom()};

    public static PlacementFrame[] getPlacementAlgorithms() {
        return placementAlgorithms;
    }

    protected void runPlacement(List<PlacementNode> nodesToPlace, List<PlacementNetwork> allNetworks, String cellName) {
    }

    public String getAlgorithmName() {
        return "?";
    }

    public Cell doPlacement(Cell cell, Placement.PlacementPreferences prefs) {
        Iterator<PortInst> pIt;
        Netlist netList = cell.getNetlist();
        if (netList == null) {
            System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
            return null;
        }
        NodeProto iconToPlace = null;
        ArrayList<PlacementNode> nodesToPlace = new ArrayList<PlacementNode>();
        HashMap convertedNodes = new HashMap();
        ArrayList<PlacementExport> exportsToPlace = new ArrayList<PlacementExport>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Export e;
            Iterator<Export> eIt;
            NodeInst ni = it.next();
            if (ni.isIconOfParent()) {
                iconToPlace = ni.getProto();
                continue;
            }
            boolean validNode = ni.isCellInstance();
            if (!validNode) {
                PrimitiveNode.Function fun;
                if (ni.getProto().getTechnology() != Generic.tech() && (fun = ni.getFunction()) != PrimitiveNode.Function.CONNECT && fun != PrimitiveNode.Function.CONTACT && !fun.isPin()) {
                    validNode = true;
                }
                if (ni.hasExports()) {
                    validNode = true;
                }
            }
            if (!validNode) continue;
            NodeProto np = ni.getProto();
            ArrayList<PlacementPort> pl = new ArrayList<PlacementPort>();
            HashMap<PortProto, PlacementPort> placedPorts = new HashMap<PortProto, PlacementPort>();
            if (ni.isCellInstance()) {
                eIt = ((Cell)np).getExports();
                while (eIt.hasNext()) {
                    e = eIt.next();
                    Poly poly = e.getPoly();
                    PlacementPort plPort = new PlacementPort(poly.getCenterX(), poly.getCenterY(), e);
                    pl.add(plPort);
                    placedPorts.put(e, plPort);
                }
            } else {
                NodeInst niDummy = NodeInst.makeDummyInstance(np);
                pIt = niDummy.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    Poly poly = pi.getPoly();
                    double offX = poly.getCenterX() - niDummy.getTrueCenterX();
                    double offY = poly.getCenterY() - niDummy.getTrueCenterY();
                    PlacementPort plPort = new PlacementPort(offX, offY, pi.getPortProto());
                    pl.add(plPort);
                    placedPorts.put(pi.getPortProto(), plPort);
                }
            }
            eIt = ni.getExports();
            while (eIt.hasNext()) {
                e = eIt.next();
                PlacementPort plPort = (PlacementPort)placedPorts.get(e.getOriginalPort().getPortProto());
                PlacementExport plExport = new PlacementExport(plPort, e.getName(), e.getCharacteristic());
                exportsToPlace.add(plExport);
            }
            String name = ni.getName();
            if (ni.getNameKey().isTempname()) {
                name = null;
            }
            PlacementNode plNode = new PlacementNode(np, name, ni.getTechSpecific(), np.getDefWidth(), np.getDefHeight(), pl);
            nodesToPlace.add(plNode);
            for (PlacementPort plPort : pl) {
                plPort.setPlacementNode(plNode);
            }
            plNode.setOrientation(Orientation.IDENT);
            convertedNodes.put(ni, placedPorts);
        }
        Map<Network, PortInst[]> portInstsByNetwork = null;
        if (cell.getView() != View.SCHEMATIC) {
            portInstsByNetwork = netList.getPortInstsByNetwork();
        }
        ArrayList<PlacementNetwork> allNetworks = new ArrayList<PlacementNetwork>();
        Iterator<Network> it2 = netList.getNetworks();
        while (it2.hasNext()) {
            Network net = it2.next();
            ArrayList<PlacementPort> portsOnNet = new ArrayList<PlacementPort>();
            PortInst[] portInsts = null;
            if (portInstsByNetwork != null) {
                portInsts = portInstsByNetwork.get(net);
            } else {
                ArrayList<PortInst> portList = new ArrayList<PortInst>();
                pIt = net.getPorts();
                while (pIt.hasNext()) {
                    portList.add(pIt.next());
                }
                portInsts = portList.toArray(new PortInst[0]);
            }
            for (int i = 0; i < portInsts.length; ++i) {
                PlacementPort plPort;
                PortInst pi = portInsts[i];
                NodeInst ni = pi.getNodeInst();
                PortProto pp = pi.getPortProto();
                Map convertedPorts = (Map)convertedNodes.get(ni);
                if (convertedPorts == null || (plPort = (PlacementPort)convertedPorts.get(pp)) == null) continue;
                portsOnNet.add(plPort);
            }
            if (portsOnNet.size() <= 1) continue;
            PlacementNetwork plNet = new PlacementNetwork(portsOnNet);
            for (PlacementPort plPort : portsOnNet) {
                plPort.setPlacementNetwork(plNet);
            }
            allNetworks.add(plNet);
        }
        Cell newCell = this.doPlacement(cell.getLibrary(), cell.noLibDescribe(), nodesToPlace, allNetworks, exportsToPlace, iconToPlace, prefs.iconParameters);
        return newCell;
    }

    public Cell doPlacement(Library lib, String cellName, List<PlacementNode> nodesToPlace, List<PlacementNetwork> allNetworks, List<PlacementExport> exportsToPlace, NodeProto iconToPlace, IconParameters iconParameters) {
        long startTime = System.currentTimeMillis();
        System.out.println("Running placement on cell '" + cellName + "' using the '" + this.getAlgorithmName() + "' algorithm");
        this.runPlacement(nodesToPlace, allNetworks, cellName);
        Cell newCell = Cell.makeInstance(lib, cellName);
        HashMap<PlacementNode, NodeInst> placedNodes = new HashMap<PlacementNode, NodeInst>();
        for (PlacementNode plNode : nodesToPlace) {
            NodeInst ni;
            double xPos = plNode.getPlacementX();
            double yPos = plNode.getPlacementY();
            Orientation orient = plNode.getPlacementOrientation();
            NodeProto np = plNode.original;
            if (np instanceof Cell) {
                Cell placementCell = (Cell)np;
                ERectangle bounds = placementCell.getBounds();
                Point2D.Double centerOffset = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                orient.pureRotate().transform(centerOffset, centerOffset);
                xPos -= ((Point2D)centerOffset).getX();
                yPos -= ((Point2D)centerOffset).getY();
            }
            if ((ni = NodeInst.makeInstance(np, (Point2D)new Point2D.Double(xPos, yPos), np.getDefWidth(), np.getDefHeight(), newCell, orient, plNode.nodeName, plNode.techBits)) == null) {
                System.out.println("Placement failed to create node");
            } else {
                placedNodes.put(plNode, ni);
            }
            if (plNode.addedVariables == null) continue;
            for (Variable.Key key : plNode.addedVariables.keySet()) {
                Object value = plNode.addedVariables.get(key);
                Variable var = ni.newDisplayVar(key, value);
                if (key == Schematics.SCHEM_RESISTANCE) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(0.0, 0.5).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                if (key == Schematics.ATTR_WIDTH) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(0.5, -1.0).withRelSize(1.0).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                if (key == Schematics.ATTR_LENGTH) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(-0.5, -1.0).withRelSize(0.5).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                ni.setTextDescriptor(key, var.getTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.VALUE));
            }
        }
        if (iconToPlace != null) {
            ERectangle bounds = newCell.getBounds();
            EPoint center = new EPoint(bounds.getMaxX() + iconToPlace.getDefWidth(), bounds.getMaxY() + iconToPlace.getDefHeight());
            NodeInst.makeInstance(iconToPlace, center, iconToPlace.getDefWidth(), iconToPlace.getDefHeight(), newCell);
        }
        for (PlacementExport plExport : exportsToPlace) {
            PlacementPort plPort = plExport.getPort();
            String exportName = plExport.getName();
            PlacementNode plNode = plPort.getPlacementNode();
            NodeInst newNI = (NodeInst)placedNodes.get(plNode);
            if (newNI == null) continue;
            PortInst portToExport = newNI.findPortInstFromProto(plPort.getPortProto());
            Export.newInstance(newCell, portToExport, exportName, plExport.getCharacteristic(), iconParameters);
        }
        ImmutableArcInst a = Generic.tech().unrouted_arc.getDefaultInst(newCell.getEditingPreferences());
        long gridExtend = a.getGridExtendOverMin();
        for (PlacementNetwork plNet : allNetworks) {
            PlacementPort lastPp = null;
            PortInst lastPi = null;
            EPoint lastPt = null;
            for (PlacementPort plPort : plNet.getPortsOnNet()) {
                PlacementNode plNode = plPort.getPlacementNode();
                NodeInst newNi = (NodeInst)placedNodes.get(plNode);
                if (newNi == null) continue;
                PlacementPort thisPp = plPort;
                PortInst thisPi = newNi.findPortInstFromProto(thisPp.getPortProto());
                EPoint thisPt = new EPoint(plNode.getPlacementX() + plPort.getRotatedOffX(), plNode.getPlacementY() + plPort.getRotatedOffY());
                if (lastPp != null) {
                    ArcInst.newInstance(newCell, Generic.tech().unrouted_arc, null, null, lastPi, thisPi, lastPt, thisPt, gridExtend, 0, a.flags);
                }
                lastPp = thisPp;
                lastPi = thisPi;
                lastPt = thisPt;
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\t(took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
        return newCell;
    }

    public static class PlacementExport {
        private PlacementPort portToExport;
        private String exportName;
        private PortCharacteristic characteristic;

        public PlacementExport(PlacementPort port, String name, PortCharacteristic chr) {
            this.portToExport = port;
            this.exportName = name;
            this.characteristic = chr;
        }

        PlacementPort getPort() {
            return this.portToExport;
        }

        String getName() {
            return this.exportName;
        }

        PortCharacteristic getCharacteristic() {
            return this.characteristic;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlacementNetwork {
        private List<PlacementPort> portsOnNet;

        public PlacementNetwork(List<PlacementPort> ports) {
            this.portsOnNet = ports;
        }

        public List<PlacementPort> getPortsOnNet() {
            return this.portsOnNet;
        }
    }

    public static class PlacementPort {
        private double offX;
        private double offY;
        private double rotatedOffX;
        private double rotatedOffY;
        private PlacementNode plNode;
        private PlacementNetwork plNet;
        private PortProto proto;

        public PlacementPort(double x, double y, PortProto pp) {
            this.offX = x;
            this.offY = y;
            this.proto = pp;
        }

        public void setPlacementNode(PlacementNode pn) {
            this.plNode = pn;
        }

        public PlacementNode getPlacementNode() {
            return this.plNode;
        }

        public void setPlacementNetwork(PlacementNetwork pn) {
            this.plNet = pn;
        }

        public PlacementNetwork getPlacementNetwork() {
            return this.plNet;
        }

        PortProto getPortProto() {
            return this.proto;
        }

        public double getOffX() {
            return this.offX;
        }

        public double getOffY() {
            return this.offY;
        }

        public double getRotatedOffX() {
            return this.rotatedOffX;
        }

        public double getRotatedOffY() {
            return this.rotatedOffY;
        }

        public void computeRotatedOffset() {
            Orientation orient = this.plNode.getPlacementOrientation();
            if (orient == Orientation.IDENT) {
                this.rotatedOffX = this.offX;
                this.rotatedOffY = this.offY;
                return;
            }
            AffineTransform trans = orient.pureRotate();
            Point2D.Double offset = new Point2D.Double(this.offX, this.offY);
            trans.transform(offset, offset);
            this.rotatedOffX = ((Point2D)offset).getX();
            this.rotatedOffY = ((Point2D)offset).getY();
        }

        public String toString() {
            return this.proto.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlacementNode {
        private NodeProto original;
        private String nodeName;
        private int techBits;
        private double width;
        private double height;
        private List<PlacementPort> ports;
        private double xPos;
        private double yPos;
        private Orientation orient;
        private Map<Variable.Key, Object> addedVariables;
        private Object userObject;

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object obj) {
            this.userObject = obj;
        }

        public PlacementNode(NodeProto type, String name, int tBits, double wid, double hei, List<PlacementPort> pps) {
            this.original = type;
            this.nodeName = name;
            this.techBits = tBits;
            this.width = wid;
            this.height = hei;
            this.ports = pps;
        }

        public void addVariable(Variable.Key name, Object value) {
            if (this.addedVariables == null) {
                this.addedVariables = new HashMap<Variable.Key, Object>();
            }
            this.addedVariables.put(name, value);
        }

        public List<PlacementPort> getPorts() {
            return this.ports;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public void setPlacement(double x, double y) {
            this.xPos = x;
            this.yPos = y;
        }

        public void setOrientation(Orientation o) {
            this.orient = o;
            for (PlacementPort plPort : this.ports) {
                plPort.computeRotatedOffset();
            }
        }

        public double getPlacementX() {
            return this.xPos;
        }

        public double getPlacementY() {
            return this.yPos;
        }

        public Orientation getPlacementOrientation() {
            return this.orient;
        }

        public NodeProto getType() {
            return this.original;
        }

        public int getTechBits() {
            return this.techBits;
        }

        public String toString() {
            String name = this.original.describe(false);
            if (this.nodeName != null) {
                name = name + "[" + this.nodeName + "]";
            }
            if (this.techBits != 0) {
                name = name + "(" + this.techBits + ")";
            }
            return name;
        }
    }
}

