/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TempPref;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FrameTab
extends PreferencePanel {
    private HashMap<Library, LibraryFrameInfo> frameLibInfo;
    private boolean frameInfoUpdating = false;
    private JPanel frame;
    private JTextField frameDefaultCompany;
    private JTextField frameDefaultDesigner;
    private JTextField frameDefaultProject;
    private JComboBox frameLibrary;
    private JTextField frameLibraryCompany;
    private JTextField frameLibraryDesigner;
    private JTextField frameLibraryProject;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;

    public FrameTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.frame;
    }

    public String getName() {
        return "Frame";
    }

    public void init() {
        Library curLib = Library.getCurrent();
        this.frameLibInfo = new HashMap();
        for (Library lib : Library.getVisibleLibraries()) {
            LibraryFrameInfo lfi = new LibraryFrameInfo();
            String company = "";
            String designer = "";
            String project = "";
            Variable var = lib.getVar(User.FRAME_COMPANY_NAME, String.class);
            if (var != null) {
                company = (String)var.getObject();
            }
            if ((var = lib.getVar(User.FRAME_DESIGNER_NAME, String.class)) != null) {
                designer = (String)var.getObject();
            }
            if ((var = lib.getVar(User.FRAME_PROJECT_NAME, String.class)) != null) {
                project = (String)var.getObject();
            }
            lfi.companyName = TempPref.makeStringPref(company);
            lfi.designerName = TempPref.makeStringPref(designer);
            lfi.projectName = TempPref.makeStringPref(project);
            this.frameLibInfo.put(lib, lfi);
            this.frameLibrary.addItem(lib.getName());
        }
        this.frameLibrary.setSelectedItem(curLib.getName());
        this.frameLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrameTab.this.loadFrameLibInfo();
            }
        });
        this.frameLibraryCompany.getDocument().addDocumentListener(new NewFrameLibInfoListener(this));
        this.frameLibraryDesigner.getDocument().addDocumentListener(new NewFrameLibInfoListener(this));
        this.frameLibraryProject.getDocument().addDocumentListener(new NewFrameLibInfoListener(this));
        this.frameLibrary.setSelectedItem(curLib.getName());
        this.frameDefaultCompany.setText(User.getFrameCompanyName());
        this.frameDefaultDesigner.setText(User.getFrameDesignerName());
        this.frameDefaultProject.setText(User.getFrameProjectName());
        this.loadFrameLibInfo();
    }

    private void loadFrameLibInfo() {
        String libName = (String)this.frameLibrary.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        LibraryFrameInfo lfi = this.frameLibInfo.get(lib);
        if (lfi == null) {
            return;
        }
        this.frameInfoUpdating = true;
        this.frameLibraryCompany.setText(lfi.companyName.getString());
        this.frameLibraryDesigner.setText(lfi.designerName.getString());
        this.frameLibraryProject.setText(lfi.projectName.getString());
        this.frameInfoUpdating = false;
    }

    private void updateFrameLibInfo() {
        if (this.frameInfoUpdating) {
            return;
        }
        String libName = (String)this.frameLibrary.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        LibraryFrameInfo lfi = this.frameLibInfo.get(lib);
        if (lfi == null) {
            return;
        }
        lfi.companyName.setString(this.frameLibraryCompany.getText());
        lfi.designerName.setString(this.frameLibraryDesigner.getText());
        lfi.projectName.setString(this.frameLibraryProject.getText());
    }

    public void term() {
        String currValue = this.frameDefaultCompany.getText();
        if (!currValue.equals(User.getFrameCompanyName())) {
            User.setFrameCompanyName(currValue);
        }
        if (!(currValue = this.frameDefaultDesigner.getText()).equals(User.getFrameDesignerName())) {
            User.setFrameDesignerName(currValue);
        }
        if (!(currValue = this.frameDefaultProject.getText()).equals(User.getFrameProjectName())) {
            User.setFrameProjectName(currValue);
        }
        for (Library lib : this.frameLibInfo.keySet()) {
            LibraryFrameInfo lfi = this.frameLibInfo.get(lib);
            if (lfi == null) continue;
            if (!lfi.companyName.getString().equals(lfi.companyName.getFactoryValue())) {
                lib.newVar(User.FRAME_COMPANY_NAME, (Object)lfi.companyName.getString());
            }
            if (!lfi.designerName.getString().equals(lfi.designerName.getFactoryValue())) {
                lib.newVar(User.FRAME_DESIGNER_NAME, (Object)lfi.designerName.getString());
            }
            if (lfi.projectName.getString().equals(lfi.projectName.getFactoryValue())) continue;
            lib.newVar(User.FRAME_PROJECT_NAME, (Object)lfi.projectName.getString());
        }
    }

    private void initComponents() {
        this.frame = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.frameLibrary = new JComboBox();
        this.jLabel17 = new JLabel();
        this.frameDefaultCompany = new JTextField();
        this.frameLibraryCompany = new JTextField();
        this.jLabel18 = new JLabel();
        this.frameDefaultDesigner = new JTextField();
        this.frameLibraryDesigner = new JTextField();
        this.jLabel19 = new JLabel();
        this.frameDefaultProject = new JTextField();
        this.frameLibraryProject = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FrameTab.this.closeDialog(evt);
            }
        });
        this.frame.setLayout(new GridBagLayout());
        this.jLabel15.setText("General default:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.frame.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setText("Library default:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.frame.add((Component)this.jLabel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.frameLibrary, gridBagConstraints);
        this.jLabel17.setText("Company Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.frame.add((Component)this.jLabel17, gridBagConstraints);
        this.frameDefaultCompany.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.frameDefaultCompany, gridBagConstraints);
        this.frameLibraryCompany.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.frameLibraryCompany, gridBagConstraints);
        this.jLabel18.setText("Designer Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.frame.add((Component)this.jLabel18, gridBagConstraints);
        this.frameDefaultDesigner.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.frameDefaultDesigner, gridBagConstraints);
        this.frameLibraryDesigner.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.frameLibraryDesigner, gridBagConstraints);
        this.jLabel19.setText("Project Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.frame.add((Component)this.jLabel19, gridBagConstraints);
        this.frameDefaultProject.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.frameDefaultProject, gridBagConstraints);
        this.frameLibraryProject.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.frameLibraryProject, gridBagConstraints);
        this.getContentPane().add((Component)this.frame, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class NewFrameLibInfoListener
    implements DocumentListener {
        FrameTab dialog;

        NewFrameLibInfoListener(FrameTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.updateFrameLibInfo();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.updateFrameLibInfo();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.updateFrameLibInfo();
        }
    }

    private static class LibraryFrameInfo {
        TempPref companyName;
        TempPref designerName;
        TempPref projectName;

        private LibraryFrameInfo() {
        }
    }
}

