/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.ImmutableArrayList;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class ERectangle
extends Rectangle2D
implements Serializable {
    public static final ERectangle[] NULL_ARRAY = new ERectangle[0];
    public static final ImmutableArrayList<ERectangle> EMPTY_LIST = new ImmutableArrayList<ERectangle>(NULL_ARRAY);
    private final long gridMinX;
    private final long gridMinY;
    private final long gridMaxX;
    private final long gridMaxY;
    private final double lambdaMinX;
    private final double lambdaMinY;
    private final double lambdaMaxX;
    private final double lambdaMaxY;
    private final double lambdaWidth;
    private final double lambdaHeight;
    private final boolean isSmall;

    private ERectangle(long gridX, long gridY, long gridWidth, long gridHeight) {
        this.gridMinX = gridX;
        this.gridMinY = gridY;
        this.gridMaxX = gridX + gridWidth;
        this.gridMaxY = gridY + gridHeight;
        this.lambdaMinX = DBMath.gridToLambda(this.gridMinX);
        this.lambdaMinY = DBMath.gridToLambda(this.gridMinY);
        this.lambdaMaxX = DBMath.gridToLambda(this.gridMaxX);
        this.lambdaMaxY = DBMath.gridToLambda(this.gridMaxY);
        this.lambdaWidth = DBMath.gridToLambda(gridWidth);
        this.lambdaHeight = DBMath.gridToLambda(gridHeight);
        this.isSmall = GenMath.isSmallInt(this.gridMinX) & GenMath.isSmallInt(this.gridMinY) & GenMath.isSmallInt(this.gridMaxX) & GenMath.isSmallInt(this.gridMaxY);
    }

    public static ERectangle fromLambda(double x, double y, double w, double h) {
        return new ERectangle(DBMath.lambdaToGrid(x), DBMath.lambdaToGrid(y), DBMath.lambdaToGrid(w), DBMath.lambdaToGrid(h));
    }

    public static ERectangle fromGrid(long x, long y, long w, long h) {
        return new ERectangle(x, y, w, h);
    }

    public static ERectangle fromLambda(Rectangle2D r) {
        if (r instanceof ERectangle) {
            return (ERectangle)r;
        }
        return ERectangle.fromLambda(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static ERectangle fromGrid(Rectangle2D r) {
        long x1 = (long)Math.floor(r.getMinX());
        long y1 = (long)Math.floor(r.getMinY());
        long x2 = (long)Math.ceil(r.getMaxX());
        long y2 = (long)Math.ceil(r.getMaxY());
        return ERectangle.fromGrid(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public double getX() {
        return this.lambdaMinX;
    }

    @Override
    public double getY() {
        return this.lambdaMinY;
    }

    @Override
    public double getWidth() {
        return this.lambdaWidth;
    }

    @Override
    public double getHeight() {
        return this.lambdaHeight;
    }

    @Override
    public double getMaxX() {
        return this.lambdaMaxX;
    }

    @Override
    public double getMaxY() {
        return this.lambdaMaxY;
    }

    public double getLambdaX() {
        return this.lambdaMinX;
    }

    public double getLambdaY() {
        return this.lambdaMinY;
    }

    public double getLambdaWidth() {
        return this.lambdaWidth;
    }

    public double getLambdaHeight() {
        return this.lambdaHeight;
    }

    public double getLambdaMinX() {
        return this.lambdaMinX;
    }

    public double getLambdaMinY() {
        return this.lambdaMinY;
    }

    public double getLambdaMaxX() {
        return this.lambdaMaxX;
    }

    public double getLambdaMaxY() {
        return this.lambdaMaxY;
    }

    public double getLambdaCenterX() {
        return this.getCenterX();
    }

    public double getLambdaCenterY() {
        return this.getCenterY();
    }

    public long getGridX() {
        return this.gridMinX;
    }

    public long getGridY() {
        return this.gridMinY;
    }

    public long getGridWidth() {
        return this.gridMaxX - this.gridMinX;
    }

    public long getGridHeight() {
        return this.gridMaxY - this.gridMinY;
    }

    public long getGridMinX() {
        return this.gridMinX;
    }

    public long getGridMinY() {
        return this.gridMinY;
    }

    public long getGridMaxX() {
        return this.gridMaxX;
    }

    public long getGridMaxY() {
        return this.gridMaxY;
    }

    public double getGridCenterX() {
        return this.gridMinX + this.gridMaxX >> 1;
    }

    public double getGridCenterY() {
        return this.gridMinY + this.gridMaxY >> 1;
    }

    @Override
    public boolean isEmpty() {
        return this.gridMinX >= this.gridMaxX || this.gridMinY >= this.gridMaxY;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    @Override
    public void setRect(double x, double y, double w, double h) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int outcode(double x, double y) {
        int out = 0;
        if (this.gridMinX >= this.gridMaxX) {
            out |= 5;
        } else if (x * 400.0 < (double)this.gridMinX) {
            out |= 1;
        } else if (x * 400.0 > (double)this.gridMaxX) {
            out |= 4;
        }
        if (this.gridMinY >= this.gridMaxY) {
            out |= 0xA;
        } else if (y * 400.0 < (double)this.gridMinY) {
            out |= 2;
        } else if (y * 400.0 > (double)this.gridMaxY) {
            out |= 8;
        }
        return out;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this;
    }

    @Override
    public Rectangle getBounds() {
        long width = this.getGridWidth();
        long height = this.getGridHeight();
        if (width < 0L || height < 0L) {
            return new Rectangle();
        }
        return new Rectangle((int)this.getGridX(), (int)this.getGridY(), (int)width, (int)height);
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D r) {
        if (r instanceof ERectangle) {
            ERectangle src = (ERectangle)r;
            long x1 = Math.max(this.gridMinX, src.gridMinX);
            long y1 = Math.max(this.gridMinY, src.gridMinY);
            long x2 = Math.min(this.gridMaxX, src.gridMaxX);
            long y2 = Math.min(this.gridMaxY, src.gridMaxY);
            if (x1 == this.gridMinX && y1 == this.gridMinY && x2 == this.gridMaxX && y2 == this.gridMaxY) {
                return this;
            }
            if (x1 == src.gridMinX && y1 == src.gridMinY && x2 == src.gridMaxX && y2 == src.gridMaxY) {
                return src;
            }
            return new ERectangle(x1, y1, x2 - x1, y2 - 1L);
        }
        Rectangle2D.Double dest = new Rectangle2D.Double();
        Rectangle2D.intersect(this, r, dest);
        return dest;
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D r) {
        if (r instanceof ERectangle) {
            ERectangle src = (ERectangle)r;
            long x1 = Math.min(this.gridMinX, src.gridMinX);
            long y1 = Math.min(this.gridMinY, src.gridMinY);
            long x2 = Math.max(this.gridMaxX, src.gridMaxX);
            long y2 = Math.max(this.gridMaxY, src.gridMaxY);
            if (x1 == this.gridMinX && y1 == this.gridMinY && x2 == this.gridMaxX && y2 == this.gridMaxY) {
                return this;
            }
            if (x1 == src.gridMinX && y1 == src.gridMinY && x2 == src.gridMaxX && y2 == src.gridMaxY) {
                return src;
            }
            return new ERectangle(x1, y1, x2 - x1, y2 - 1L);
        }
        Rectangle2D.Double dest = new Rectangle2D.Double();
        Rectangle2D.union(this, r, dest);
        return dest;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.getX() + ",y=" + this.getY() + ",w=" + this.getWidth() + ",h=" + this.getHeight() + "]";
    }
}

