/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.LibId;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import java.io.IOException;

public class ImmutableCell
extends ImmutableElectricObject {
    public final CellId cellId;
    public final CellName groupName;
    public final long creationDate;
    public final Technology tech;

    private ImmutableCell(CellId cellId, CellName groupName, long creationDate, Technology tech, int flags, Variable[] vars) {
        super(vars, flags);
        this.cellId = cellId;
        this.groupName = groupName;
        this.creationDate = creationDate;
        this.tech = tech;
    }

    public static ImmutableCell newInstance(CellId cellId, long creationDate) {
        if (cellId == null) {
            throw new NullPointerException("cellId");
        }
        return new ImmutableCell(cellId, CellName.newName(cellId.cellName.getName(), View.SCHEMATIC, 0), creationDate, null, 0, Variable.NULL_ARRAY);
    }

    public ImmutableCell withGroupName(CellName groupName) {
        if (this.groupName.equals(groupName)) {
            return this;
        }
        if (groupName.getVersion() != 0 || groupName.getView() != View.SCHEMATIC) {
            throw new IllegalArgumentException(groupName.toString());
        }
        return new ImmutableCell(this.cellId, groupName, this.creationDate, this.tech, this.flags, this.getVars());
    }

    public ImmutableCell withCreationDate(long creationDate) {
        if (this.creationDate == creationDate) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, creationDate, this.tech, this.flags, this.getVars());
    }

    public ImmutableCell withTech(Technology tech) {
        if (this.tech == tech) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, tech, this.flags, this.getVars());
    }

    public ImmutableCell withFlags(int flags) {
        if (this.flags == flags) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.tech, flags, this.getVars());
    }

    public ImmutableCell withVariable(Variable var) {
        Variable[] vars = this.arrayWithVariable(var);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.tech, this.flags, vars);
    }

    public ImmutableCell withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.tech, this.flags, vars);
    }

    ImmutableCell withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        CellId cellId = idMapper.get(this.cellId);
        if (this.getVars() == vars && this.cellId == cellId) {
            return this;
        }
        return new ImmutableCell(cellId, this.groupName, this.creationDate, this.tech, this.flags, vars);
    }

    public ImmutableCell withoutVariables() {
        if (this.getNumVariables() == 0) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.tech, this.flags, Variable.NULL_ARRAY);
    }

    public LibId getLibId() {
        return this.cellId.libId;
    }

    @Override
    void write(SnapshotWriter writer) throws IOException {
        writer.writeNodeProtoId(this.cellId);
        writer.writeString(this.groupName.toString());
        writer.writeLong(this.creationDate);
        writer.writeBoolean(this.tech != null);
        if (this.tech != null) {
            writer.writeTechnology(this.tech);
        }
        writer.writeInt(this.flags);
        super.write(writer);
    }

    static ImmutableCell read(SnapshotReader reader) throws IOException {
        CellId cellId = (CellId)reader.readNodeProtoId();
        String groupNameString = reader.readString();
        CellName groupName = CellName.parseName(groupNameString);
        long creationDate = reader.readLong();
        boolean hasTech = reader.readBoolean();
        Technology tech = hasTech ? reader.readTechnology() : null;
        int flags = reader.readInt();
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableCell.readVars(reader) : Variable.NULL_ARRAY;
        return new ImmutableCell(cellId, groupName, creationDate, tech, flags, vars);
    }

    @Override
    public int hashCodeExceptVariables() {
        return this.cellId.hashCode();
    }

    @Override
    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableCell)) {
            return false;
        }
        ImmutableCell that = (ImmutableCell)o;
        return this.cellId == that.cellId && this.groupName == that.groupName && this.creationDate == that.creationDate && this.tech == that.tech && this.flags == that.flags;
    }

    public void check() {
        this.check(true);
        assert (this.cellId != null);
        assert (this.groupName.getVersion() == 0);
        assert (this.groupName.getView() == View.SCHEMATIC);
    }

    public String toString() {
        return this.cellId.toString();
    }
}

