/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.Name;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class ExportId
implements PortProtoId,
Serializable {
    public static final ExportId[] NULL_ARRAY = new ExportId[0];
    public final CellId parentId;
    public final int chronIndex;
    public final String externalId;

    ExportId(CellId parentId, int chronIndex, String externalId) {
        assert (parentId != null);
        if (externalId.length() == 0) {
            throw new IllegalArgumentException("ExportId");
        }
        this.parentId = parentId;
        this.chronIndex = chronIndex;
        this.externalId = externalId;
    }

    private Object writeReplace() {
        return new ExportIdKey(this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("ExportId");
    }

    @Override
    public CellId getParentId() {
        return this.parentId;
    }

    @Override
    public int getChronIndex() {
        return this.chronIndex;
    }

    @Override
    public Name getNameKey(Snapshot snapshot) {
        return this.inSnapshot((Snapshot)snapshot).name;
    }

    @Override
    public String getName(Snapshot snapshot) {
        return this.inSnapshot((Snapshot)snapshot).name.toString();
    }

    public ImmutableExport inSnapshot(Snapshot snapshot) {
        CellBackup cellBackup = snapshot.getCell(this.parentId);
        return cellBackup != null ? cellBackup.getExport(this) : null;
    }

    @Override
    public Export inDatabase(EDatabase database) {
        Cell cell = database.getCell(this.parentId);
        if (cell == null) {
            return null;
        }
        return cell.getExportChron(this.chronIndex);
    }

    public int hashCode() {
        return this.externalId.hashCode();
    }

    public String toString() {
        return this.parentId + ":" + this.externalId;
    }

    void check() {
        assert (this.externalId.length() > 0);
    }

    private static class ExportIdKey
    extends EObjectInputStream.Key {
        private final int cellIndex;
        private final int chronIndex;

        private ExportIdKey(ExportId exportId) {
            this.cellIndex = exportId.parentId.cellIndex;
            this.chronIndex = exportId.chronIndex;
        }

        @Override
        protected Object readResolveInDatabase(EDatabase database) throws InvalidObjectException {
            return database.getIdManager().getCellId(this.cellIndex).getPortId(this.chronIndex);
        }
    }
}

