/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SpecialProperties {
    public static int doubleClickOnNode(EditWindow wnd, NodeInst ni) {
        if (ni.getProto() == Schematics.tech.resistorNode) {
            NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Resistance", "Ohms", Schematics.SCHEM_RESISTANCE);
            if (npd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech.capacitorNode) {
            NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Capacitance", "Farads", Schematics.SCHEM_CAPACITANCE);
            if (npd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech.inductorNode) {
            NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Inductance", "Henrys", Schematics.SCHEM_INDUCTANCE);
            if (npd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech.diodeNode) {
            NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Diode Area", null, Schematics.SCHEM_DIODE);
            if (npd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech.transistorNode || ni.getProto() == Schematics.tech.transistor4Node) {
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun == PrimitiveNode.Function.TRA4NPN || fun == PrimitiveNode.Function.TRA4PNP || fun == PrimitiveNode.Function.TRANPN || fun == PrimitiveNode.Function.TRAPNP) {
                NodePropertiesDialog npd = new NodePropertiesDialog(wnd, ni, "Transistor area", null, Schematics.ATTR_AREA);
                if (npd.wantMore()) {
                    return -1;
                }
                return 1;
            }
            TransistorPropertiesDialog tpd = new TransistorPropertiesDialog(wnd, ni);
            if (tpd.wantMore()) {
                return -1;
            }
            return 1;
        }
        if (ni.getProto() == Schematics.tech.globalNode) {
            GlobalPropertiesDialog gpd = new GlobalPropertiesDialog(wnd, ni);
            if (gpd.wantMore()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private static TextUtils.UnitScale getUnit(String str) {
        TextUtils.UnitScale[] scales = TextUtils.UnitScale.getUnitScales();
        for (int i = 0; i < scales.length; ++i) {
            String sSuffix;
            TextUtils.UnitScale u = scales[i];
            String postfix = u.getPostFix();
            if (postfix.equals("") || postfix.length() >= str.length() || !(sSuffix = str.substring(str.length() - postfix.length(), str.length())).equalsIgnoreCase(postfix)) continue;
            return u;
        }
        return TextUtils.UnitScale.NONE;
    }

    private static class TransistorPropertiesDialog
    extends EDialog {
        private JTextField valueWid;
        private JTextField valueLen;
        private JComboBox comboWid;
        private JComboBox comboLen;
        private boolean cancelHit;
        private boolean moreHit;

        private TransistorPropertiesDialog(EditWindow wnd, NodeInst ni) {
            super((Frame)null, true);
            String tWid = "";
            TextDescriptor.Code cWid = TextDescriptor.Code.NONE;
            Variable varWid = ni.getVar(Schematics.ATTR_WIDTH);
            if (varWid != null) {
                tWid = varWid.getObject().toString();
                cWid = varWid.getCode();
            }
            String tLen = "";
            TextDescriptor.Code cLen = TextDescriptor.Code.NONE;
            Variable varLen = ni.getVar(Schematics.ATTR_LENGTH);
            if (varLen != null) {
                tLen = varLen.getObject().toString();
                cLen = varLen.getCode();
            }
            this.initComponents(wnd, ni, "Transistor Properties", tWid, cWid, tLen, cLen);
            this.moreHit = false;
            this.cancelHit = false;
            this.setVisible(true);
            if (!this.cancelHit) {
                String newWid = this.valueWid.getText();
                String newLen = this.valueLen.getText();
                TextDescriptor.Code newWidCode = (TextDescriptor.Code)this.comboWid.getSelectedItem();
                TextDescriptor.Code newLenCode = (TextDescriptor.Code)this.comboLen.getSelectedItem();
                new ModifyNodeProperties(ni, newWid, newWidCode, newLen, newLenCode);
            }
        }

        protected void escapePressed() {
            this.exit(false);
        }

        private boolean wantMore() {
            return this.moreHit;
        }

        private void exit(boolean goodButton) {
            this.cancelHit = !goodButton;
            this.setVisible(false);
            this.dispose();
        }

        private void moreButton() {
            this.moreHit = true;
            this.exit(true);
        }

        private void initComponents(EditWindow wnd, NodeInst ni, String title, String initialWid, TextDescriptor.Code codeWid, String initialLen, TextDescriptor.Code codeLen) {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle(title);
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    TransistorPropertiesDialog.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Width:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.valueWid = new JTextField(initialWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.valueWid, gbc);
            this.valueWid.selectAll();
            this.comboWid = new JComboBox();
            Iterator it = TextDescriptor.Code.getCodes();
            while (it.hasNext()) {
                this.comboWid.addItem(it.next());
            }
            this.comboWid.setSelectedItem(codeWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.comboWid, gbc);
            JLabel lab2 = new JLabel("Length:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            this.valueLen = new JTextField(initialLen);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.valueLen, gbc);
            this.comboLen = new JComboBox();
            Iterator it2 = TextDescriptor.Code.getCodes();
            while (it2.hasNext()) {
                this.comboLen.addItem(it2.next());
            }
            this.comboLen.setSelectedItem(codeLen);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.comboLen, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TransistorPropertiesDialog.this.exit(false);
                }
            });
            JButton more = new JButton("More...");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)more, gbc);
            more.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TransistorPropertiesDialog.this.moreButton();
                }
            });
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 4;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TransistorPropertiesDialog.this.exit(true);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            this.pack();
            Point ew = wnd.getLocationOnScreen();
            Point locInWnd = wnd.databaseToScreen(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            Point textfield = this.valueWid.getLocation();
            Dimension textSize = this.valueWid.getSize();
            this.setLocation(locInWnd.x + ew.x - (textfield.x + textSize.width / 2), locInWnd.y + ew.y - (textfield.y + textSize.height / 2 + 20));
        }
    }

    private static class GlobalPropertiesDialog
    extends EDialog {
        private JTextField value;
        private JComboBox combo;
        private boolean cancelHit;
        private boolean moreHit;

        private GlobalPropertiesDialog(EditWindow wnd, NodeInst ni) {
            super((Frame)null, true);
            String gName = "";
            Variable var = ni.getVar(Schematics.SCHEM_GLOBAL_NAME);
            if (var != null) {
                gName = var.getObject().toString();
            }
            this.initComponents(wnd, ni, "Global Signal", gName);
            this.moreHit = false;
            this.cancelHit = false;
            this.setVisible(true);
            if (!this.cancelHit) {
                String newValue = this.value.getText();
                PortCharacteristic ch = PortCharacteristic.findCharacteristic((String)this.combo.getSelectedItem());
                int newBits = ch.getBits();
                new ModifyNodeProperties(ni, Schematics.SCHEM_GLOBAL_NAME, newValue, newBits);
            }
        }

        protected void escapePressed() {
            this.exit(false);
        }

        private boolean wantMore() {
            return this.moreHit;
        }

        private void exit(boolean goodButton) {
            this.cancelHit = !goodButton;
            this.setVisible(false);
            this.dispose();
        }

        private void moreButton() {
            this.moreHit = true;
            this.exit(true);
        }

        private void initComponents(EditWindow wnd, NodeInst ni, String title, String initialValue) {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle(title);
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    GlobalPropertiesDialog.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Global signal name:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.value = new JTextField(initialValue);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.value, gbc);
            this.value.selectAll();
            JLabel lab2 = new JLabel("Characteristics:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            this.combo = new JComboBox();
            boolean selected = false;
            List characteristics = PortCharacteristic.getOrderedCharacteristics();
            Iterator it = characteristics.iterator();
            while (it.hasNext()) {
                PortCharacteristic ch = (PortCharacteristic)it.next();
                this.combo.addItem(ch.getName());
            }
            PortCharacteristic ch = PortCharacteristic.findCharacteristic(ni.getTechSpecific());
            this.combo.setSelectedItem(ch.getName());
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.combo, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GlobalPropertiesDialog.this.exit(false);
                }
            });
            JButton more = new JButton("More...");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)more, gbc);
            more.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GlobalPropertiesDialog.this.moreButton();
                }
            });
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GlobalPropertiesDialog.this.exit(true);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            this.pack();
            Point ew = wnd.getLocationOnScreen();
            Point locInWnd = wnd.databaseToScreen(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            Point textfield = this.value.getLocation();
            Dimension textSize = this.value.getSize();
            this.setLocation(locInWnd.x + ew.x - (textfield.x + textSize.width / 2), locInWnd.y + ew.y - (textfield.y + textSize.height / 2 + 20));
        }
    }

    private static class ModifyNodeProperties
    extends Job {
        private NodeInst ni;
        private Variable.Key key;
        private String newValue;
        private String newValueLen;
        private TextDescriptor.Code newCode;
        private TextDescriptor.Code newCodeLen;
        private int newBits;

        private ModifyNodeProperties(NodeInst ni, Variable.Key key, String newValue) {
            super("Change Node Value", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.key = key;
            this.newValue = newValue;
            this.newBits = -1;
            this.startJob();
        }

        private ModifyNodeProperties(NodeInst ni, Variable.Key key, String newValue, int newBits) {
            super("Change Node Value", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.key = key;
            this.newValue = newValue;
            this.newBits = newBits;
            this.startJob();
        }

        private ModifyNodeProperties(NodeInst ni, String newWid, TextDescriptor.Code newWidCode, String newLen, TextDescriptor.Code newLenCode) {
            super("Change Node Value", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.key = null;
            this.newValue = newWid;
            this.newCode = newWidCode;
            this.newValueLen = newLen;
            this.newCodeLen = newLenCode;
            this.startJob();
        }

        public boolean doIt() {
            if (this.key == null) {
                Variable oldWid = this.ni.getVar(Schematics.ATTR_WIDTH);
                Variable var = this.ni.newDisplayVar(Schematics.ATTR_WIDTH, this.newValue);
                if (var != null) {
                    if (oldWid != null) {
                        var.setTextDescriptor(oldWid.getTextDescriptor());
                    }
                    var.setCode(this.newCode);
                }
                Variable oldLen = this.ni.getVar(Schematics.ATTR_LENGTH);
                var = this.ni.newDisplayVar(Schematics.ATTR_LENGTH, this.newValueLen);
                if (var != null) {
                    if (oldLen != null) {
                        var.setTextDescriptor(oldLen.getTextDescriptor());
                    }
                    var.setCode(this.newCodeLen);
                }
            } else {
                Variable oldVar = this.ni.getVar(this.key);
                Variable var = this.ni.newDisplayVar(this.key, this.newValue);
                if (var != null && oldVar != null) {
                    var.setTextDescriptor(oldVar.getTextDescriptor());
                }
                if (this.newBits != -1) {
                    this.ni.setTechSpecific(this.newBits);
                }
            }
            return true;
        }
    }

    private static class NodePropertiesDialog
    extends EDialog {
        private JTextField value;
        private JComboBox combo;
        private boolean cancelHit;
        private boolean moreHit;

        private NodePropertiesDialog(EditWindow wnd, NodeInst ni, String title, String units, Variable.Key key) {
            super((Frame)null, true);
            TextUtils.UnitScale[] scales = TextUtils.UnitScale.getUnitScales();
            String[] theScales = new String[scales.length];
            for (int i = 0; i < scales.length; ++i) {
                theScales[i] = scales[i].toString();
            }
            double num = 0.0;
            TextUtils.UnitScale scale = TextUtils.UnitScale.NONE;
            Variable var = ni.getVar(key);
            if (var != null) {
                String val = var.getObject().toString();
                scale = SpecialProperties.getUnit(val);
                String postFix = scale.getPostFix();
                if (postFix.length() > 0) {
                    val = val.substring(0, val.length() - postFix.length());
                }
                num = TextUtils.atof(val);
            }
            this.initComponents(wnd, ni, title, TextUtils.formatDouble(num), theScales, scale.getName(), units);
            this.moreHit = false;
            this.cancelHit = false;
            this.setVisible(true);
            if (!this.cancelHit) {
                String newValue = this.value.getText();
                if (units != null) {
                    int newScale = this.combo.getSelectedIndex();
                    newValue = newValue + scales[newScale].getPostFix();
                }
                new ModifyNodeProperties(ni, key, newValue);
            }
        }

        protected void escapePressed() {
            this.exit(false);
        }

        private boolean wantMore() {
            return this.moreHit;
        }

        private void exit(boolean goodButton) {
            this.cancelHit = !goodButton;
            this.setVisible(false);
            this.dispose();
        }

        private void moreButton() {
            this.moreHit = true;
            this.exit(true);
        }

        private void initComponents(EditWindow wnd, NodeInst ni, String title, String initialValue, String[] theScales, String initialScale, String units) {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle(title);
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    NodePropertiesDialog.this.exit(false);
                }
            });
            this.value = new JTextField(initialValue);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = units == null ? 4 : 2;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.value, gbc);
            this.value.selectAll();
            if (units != null) {
                this.combo = new JComboBox();
                int selected = 0;
                for (int k = 0; k < theScales.length; ++k) {
                    String sca = theScales[k];
                    if (sca.equalsIgnoreCase(initialScale)) {
                        selected = k;
                    }
                    if (sca.length() == 0) {
                        this.combo.addItem(units);
                        continue;
                    }
                    this.combo.addItem(sca + "-" + units.toLowerCase());
                }
                this.combo.setSelectedIndex(selected);
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 0;
                gbc.gridwidth = 2;
                gbc.anchor = 10;
                gbc.fill = 2;
                gbc.weightx = 0.5;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)this.combo, gbc);
            }
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    NodePropertiesDialog.this.exit(false);
                }
            });
            JButton more = new JButton("More...");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)more, gbc);
            more.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    NodePropertiesDialog.this.moreButton();
                }
            });
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    NodePropertiesDialog.this.exit(true);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            this.pack();
            Point ew = wnd.getLocationOnScreen();
            Point locInWnd = wnd.databaseToScreen(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            Point textfield = this.value.getLocation();
            Dimension textSize = this.value.getSize();
            this.setLocation(locInWnd.x + ew.x - (textfield.x + textSize.width / 2), locInWnd.y + ew.y - (textfield.y + textSize.height / 2 + 20));
        }
    }
}

