/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PrimitiveNode
implements NodeProtoId,
NodeProto,
Comparable {
    public static final int NORMAL = 0;
    public static final int SERPTRANS = 1;
    public static final int POLYGONAL = 2;
    public static final int MULTICUT = 3;
    public static final int HIGHLOWVT = 4;
    private static final int NODESHRINK = 1;
    private static final int ARCSWIPE = 512;
    private static final int NSQUARE = 1024;
    private static final int HOLDSTRACE = 2048;
    private static final int CANBEZEROSIZE = 4096;
    private static final int WIPEON1OR2 = 8192;
    private static final int LOCKEDPRIM = 16384;
    private static final int NEDGESELECT = 32768;
    private static final int ARCSHRINK = 65536;
    private static final int NINVISIBLE = 131072;
    private static final int NODESPECIAL = 262144;
    private static final int NNOTUSED = 524288;
    private static final int NODEGROUP = 0x100000;
    private String protoName;
    private String fullName;
    private Technology tech;
    private Function function;
    private Technology.NodeLayer[] layers;
    private Technology.NodeLayer[] electricalLayers;
    private PrimitivePort[] primPorts;
    private int userBits;
    private int globalPrimNodeIndex;
    private int techPrimNodeIndex = -1;
    private int specialType;
    private double[] specialValues;
    private double minWidth;
    private double minHeight;
    private String minSizeRule;
    private SizeOffset offset;
    private Dimension2D autoGrowth;
    private static int primNodeNumber;
    private static HashMap defaultWidthPrefs;
    private static HashMap defaultHeightPrefs;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected PrimitiveNode(String protoName, Technology tech, double defWidth, double defHeight, SizeOffset offset, Technology.NodeLayer[] layers) {
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("PrimitiveNode name " + protoName + " is not safe to write inti JELIB");
        }
        this.protoName = protoName;
        this.fullName = tech.getTechName() + ":" + protoName;
        this.function = Function.UNKNOWN;
        this.tech = tech;
        this.layers = layers;
        this.electricalLayers = null;
        this.userBits = 0;
        this.specialType = 0;
        this.setFactoryDefSize(defWidth, defHeight);
        if (offset == null) {
            offset = new SizeOffset(0.0, 0.0, 0.0, 0.0);
        }
        this.offset = offset;
        this.autoGrowth = null;
        this.minHeight = -1.0;
        this.minWidth = -1.0;
        this.minSizeRule = "";
        this.globalPrimNodeIndex = primNodeNumber++;
        tech.addNodeProto(this);
    }

    public static PrimitiveNode newInstance(String protoName, Technology tech, double width, double height, SizeOffset offset, Technology.NodeLayer[] layers) {
        if (tech.findNodeProto(protoName) != null) {
            System.out.println("Error: technology " + tech.getTechName() + " has multiple nodes named " + protoName);
            return null;
        }
        if (width < 0.0 || height < 0.0) {
            System.out.println("Error: technology " + tech.getTechName() + " node " + protoName + " has negative size");
            return null;
        }
        PrimitiveNode pn = new PrimitiveNode(protoName, tech, width, height, offset, layers);
        return pn;
    }

    public NodeProto inCurrentThread() {
        return this;
    }

    public NodeProtoId getId() {
        return this;
    }

    public String getName() {
        return this.protoName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFunction(Function function) {
        this.checkChanging();
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public Function getGroupFunction() {
        if (this.function == Function.TRANMOS || this.function == Function.TRA4NMOS || this.function == Function.TRAPMOS || this.function == Function.TRA4PMOS || this.function == Function.TRADMOS || this.function == Function.TRA4DMOS || this.function == Function.TRANPN || this.function == Function.TRA4NPN || this.function == Function.TRAPNP || this.function == Function.TRA4PNP || this.function == Function.TRANJFET || this.function == Function.TRA4NJFET || this.function == Function.TRAPJFET || this.function == Function.TRA4PJFET || this.function == Function.TRADMES || this.function == Function.TRA4DMES || this.function == Function.TRAEMES || this.function == Function.TRA4EMES || this.function == Function.TRANS4) {
            return Function.TRANS;
        }
        if (this.function.isResistor() || this.function.isCapacitor() || this.function == Function.DIODE || this.function == Function.DIODEZ || this.function == Function.INDUCT) {
            return Function.INDUCT;
        }
        if (this.function == Function.CCVS || this.function == Function.CCCS || this.function == Function.VCVS || this.function == Function.VCCS || this.function == Function.TLINE) {
            return Function.TLINE;
        }
        if (this.function == Function.BASE || this.function == Function.EMIT || this.function == Function.COLLECT) {
            return Function.COLLECT;
        }
        if (this.function == Function.BUFFER || this.function == Function.GATEAND || this.function == Function.GATEOR || this.function == Function.MUX || this.function == Function.GATEXOR) {
            return Function.GATEXOR;
        }
        if (this.function == Function.CONPOWER || this.function == Function.CONGROUND) {
            return Function.CONGROUND;
        }
        if (this.function == Function.METER || this.function == Function.SOURCE) {
            return Function.SOURCE;
        }
        if (this.function == Function.SUBSTRATE || this.function == Function.WELL) {
            return Function.WELL;
        }
        return this.function;
    }

    public Technology.NodeLayer[] getLayers() {
        return this.layers;
    }

    public void setLayers(Technology.NodeLayer[] layers) {
        this.layers = layers;
    }

    public Iterator layerIterator() {
        return new NodeLayerIterator(this.layers);
    }

    public Technology.NodeLayer[] getElectricalLayers() {
        return this.electricalLayers;
    }

    public void setElectricalLayers(Technology.NodeLayer[] electricalLayers) {
        this.electricalLayers = electricalLayers;
    }

    public Technology.NodeLayer findNodeLayer(Layer layer, boolean electrical) {
        Technology.NodeLayer[] nodes;
        Technology.NodeLayer[] nodeLayerArray = nodes = electrical ? this.electricalLayers : this.layers;
        if (nodes != null) {
            for (int j = 0; j < nodes.length; ++j) {
                Technology.NodeLayer oneLayer = nodes[j];
                if (oneLayer.getLayer() != layer) continue;
                return oneLayer;
            }
        }
        return null;
    }

    public int getDefPlacementAngle() {
        int defAngle = User.getNewNodeRotation();
        return defAngle;
    }

    private Pref getNodeProtoWidthPref(double factoryWidth) {
        Pref pref = (Pref)defaultWidthPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultWidthFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factoryWidth);
            defaultWidthPrefs.put(this, pref);
        }
        return pref;
    }

    private Pref getNodeProtoHeightPref(double factoryHeight) {
        Pref pref = (Pref)defaultHeightPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultHeightFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factoryHeight);
            defaultHeightPrefs.put(this, pref);
        }
        return pref;
    }

    protected void setFactoryDefSize(double defWidth, double defHeight) {
        this.getNodeProtoWidthPref(defWidth);
        this.getNodeProtoHeightPref(defHeight);
    }

    public boolean setDefSize(double defWidth, double defHeight) {
        boolean changed = this.getNodeProtoWidthPref(0.0).setDouble(defWidth);
        changed = !this.getNodeProtoHeightPref(0.0).setDouble(defHeight) ? changed : true;
        return changed;
    }

    public double getDefWidth() {
        return this.getNodeProtoWidthPref(0.0).getDouble();
    }

    public double getDefHeight() {
        return this.getNodeProtoHeightPref(0.0).getDouble();
    }

    public SizeOffset getProtoSizeOffset() {
        return this.offset;
    }

    public double getMinWidth() {
        return this.minWidth;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public String getMinSizeRule() {
        return this.minSizeRule;
    }

    public void setMinSize(double minWidth, double minHeight, String minSizeRule) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.minSizeRule = minSizeRule;
    }

    public void setSizeOffset(SizeOffset offset) {
        this.offset = offset;
    }

    public void setAutoGrowth(double dX, double dY) {
        this.autoGrowth = new Dimension2D.Double(dX, dY);
    }

    public Dimension2D getAutoGrowth() {
        return this.autoGrowth;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public void addPrimitivePorts(PrimitivePort[] ports) {
        if (!$assertionsDisabled && this.primPorts != null) {
            throw new AssertionError((Object)(this + " addPrimitivePorts twice"));
        }
        this.primPorts = (PrimitivePort[])ports.clone();
        for (int i = 0; i < this.primPorts.length; ++i) {
            this.primPorts[i].setPortIndex(this, i);
        }
    }

    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        name = name.canonic();
        for (int i = 0; i < this.primPorts.length; ++i) {
            PrimitivePort pp = this.primPorts[i];
            if (pp.getNameKey().canonic() != name) continue;
            return pp;
        }
        return null;
    }

    public Iterator getPorts() {
        return ArrayIterator.iterator(this.primPorts);
    }

    public int getNumPorts() {
        return this.primPorts.length;
    }

    public final PortProto getPort(int portIndex) {
        return this.primPorts[portIndex];
    }

    public PrimitivePort connectsTo(ArcProto arc) {
        for (int i = 0; i < this.primPorts.length; ++i) {
            PrimitivePort pp = this.primPorts[i];
            if (!pp.connectsTo(arc)) continue;
            return pp;
        }
        return null;
    }

    public int getSpecialType() {
        return this.specialType;
    }

    public void setSpecialType(int specialType) {
        this.specialType = specialType;
    }

    public double[] getSpecialValues() {
        return this.specialValues;
    }

    public void setSpecialValues(double[] specialValues) {
        if (specialValues.length != 6) {
            throw new IndexOutOfBoundsException("Invalid number of values in setSpecialValues");
        }
        this.specialValues = specialValues;
    }

    public boolean isPin() {
        return this.getFunction() == Function.PIN;
    }

    public String describe(boolean withQuotes) {
        String name = "";
        if (this.tech != Technology.getCurrent()) {
            name = name + this.tech.getTechName() + ":";
        }
        name = name + this.protoName;
        return withQuotes ? "'" + name + "'" : name;
    }

    public void setGroupNode() {
        this.checkChanging();
        this.userBits |= 0x100000;
    }

    public boolean isGroupNode() {
        return (this.userBits & 0x100000) != 0;
    }

    public void setSpecialNode() {
        this.checkChanging();
        this.userBits |= 0x40000;
    }

    public boolean isSpecialNode() {
        return (this.userBits & 0x40000) != 0;
    }

    public void setCanShrink() {
        this.checkChanging();
        this.userBits |= 1;
    }

    public void clearCanShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFFFFFE;
    }

    public boolean canShrink() {
        return (this.userBits & 1) != 0;
    }

    public void setArcsWipe() {
        this.checkChanging();
        this.userBits |= 0x200;
    }

    public void clearArcsWipe() {
        this.checkChanging();
        this.userBits &= 0xFFFFFDFF;
    }

    public boolean isArcsWipe() {
        return (this.userBits & 0x200) != 0;
    }

    public void setSquare() {
        this.checkChanging();
        this.userBits |= 0x400;
    }

    public void clearSquare() {
        this.checkChanging();
        this.userBits &= 0xFFFFFBFF;
    }

    public boolean isSquare() {
        return (this.userBits & 0x400) != 0;
    }

    public void setHoldsOutline() {
        this.checkChanging();
        this.userBits |= 0x800;
    }

    public void clearHoldsOutline() {
        this.checkChanging();
        this.userBits &= 0xFFFFF7FF;
    }

    public boolean isHoldsOutline() {
        return (this.userBits & 0x800) != 0;
    }

    public void setCanBeZeroSize() {
        this.checkChanging();
        this.userBits |= 0x1000;
    }

    public void clearCanBeZeroSize() {
        this.checkChanging();
        this.userBits &= 0xFFFFEFFF;
    }

    public boolean isCanBeZeroSize() {
        return (this.userBits & 0x1000) != 0;
    }

    public void setWipeOn1or2() {
        this.checkChanging();
        this.userBits |= 0x2000;
    }

    public void clearWipeOn1or2() {
        this.checkChanging();
        this.userBits &= 0xFFFFDFFF;
    }

    public boolean isWipeOn1or2() {
        return (this.userBits & 0x2000) != 0;
    }

    public void setLockedPrim() {
        this.checkChanging();
        this.userBits |= 0x4000;
    }

    public void clearLockedPrim() {
        this.checkChanging();
        this.userBits &= 0xFFFFBFFF;
    }

    public boolean isLockedPrim() {
        return (this.userBits & 0x4000) != 0;
    }

    public void setEdgeSelect() {
        this.checkChanging();
        this.userBits |= 0x8000;
    }

    public void clearEdgeSelect() {
        this.checkChanging();
        this.userBits &= 0xFFFF7FFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x8000) != 0;
    }

    public void setArcsShrink() {
        this.checkChanging();
        this.userBits |= 0x10000;
    }

    public void clearArcsShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFEFFFF;
    }

    public boolean isArcsShrink() {
        return (this.userBits & 0x10000) != 0;
    }

    public void setNodeInvisible(boolean invisible) {
        this.userBits = invisible ? (this.userBits |= 0x20000) : (this.userBits &= 0xFFFDFFFF);
    }

    public boolean isNodeInvisible() {
        return (this.userBits & 0x20000) != 0;
    }

    public void setNotUsed() {
        this.checkChanging();
        this.userBits |= 0x80000;
    }

    public void clearNotUsed() {
        this.checkChanging();
        this.userBits &= 0xFFF7FFFF;
    }

    public boolean isNotUsed() {
        return (this.userBits & 0x80000) != 0;
    }

    public boolean isPureWellNode() {
        if (this.function != Function.NODE) {
            return false;
        }
        if (this.layers.length != 1) {
            return false;
        }
        Layer layer = this.layers[0].getLayer();
        return layer.getFunction().isWell();
    }

    public boolean isPureSubstrateNode() {
        if (this.function != Function.NODE) {
            return false;
        }
        if (this.layers.length != 1) {
            return false;
        }
        Layer layer = this.layers[0].getLayer();
        return layer.getFunction().isSubstrate();
    }

    public final int getPrimNodeIndexInTech() {
        return this.techPrimNodeIndex;
    }

    public void setPrimNodeIndexInTech(int index) {
        this.techPrimNodeIndex = index;
    }

    public int compareTo(Object obj) {
        int cmp;
        PrimitiveNode that = (PrimitiveNode)obj;
        if (this.tech != that.tech && (cmp = this.tech.compareTo(that.tech)) != 0) {
            return cmp;
        }
        return this.globalPrimNodeIndex - that.globalPrimNodeIndex;
    }

    public String toString() {
        return "node " + this.describe(true);
    }

    public void getZValues(double[] array) {
        for (int j = 0; j < this.layers.length; ++j) {
            Layer layer = this.layers[j].getLayer();
            if (layer.getTechnology() instanceof Generic) continue;
            double distance = layer.getDistance();
            double thickness = layer.getThickness();
            double z = distance + thickness;
            array[0] = array[0] > distance ? distance : array[0];
            array[1] = array[1] < z ? z : array[1];
        }
    }

    private void checkChanging() {
    }

    static {
        $assertionsDisabled = !PrimitiveNode.class.desiredAssertionStatus();
        primNodeNumber = 0;
        defaultWidthPrefs = new HashMap();
        defaultHeightPrefs = new HashMap();
    }

    private static class NodeLayerIterator
    implements Iterator {
        Technology.NodeLayer[] array;
        int pos;

        public NodeLayerIterator(Technology.NodeLayer[] a) {
            this.array = a;
            this.pos = 0;
        }

        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        public Object next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    public static class Function {
        private final String name;
        private final String shortName;
        private final Name basename;
        private final String constantName;
        private static List allFunctions = new ArrayList();
        public static final Function UNKNOWN = new Function("unknown", "node", "UNKNOWN");
        public static final Function PIN = new Function("pin", "pin", "PIN");
        public static final Function CONTACT = new Function("contact", "contact", "CONTACT");
        public static final Function NODE = new Function("pure-layer-node", "plnode", "NODE");
        public static final Function CONNECT = new Function("connection", "conn", "CONNECT");
        public static final Function TRANMOS = new Function("nMOS-transistor", "nmos", "TRANMOS");
        public static final Function TRADMOS = new Function("DMOS-transistor", "dmos", "TRADMOS");
        public static final Function TRAPMOS = new Function("pMOS-transistor", "pmos", "TRAPMOS");
        public static final Function TRANPN = new Function("NPN-transistor", "npn", "TRANPN");
        public static final Function TRAPNP = new Function("PNP-transistor", "pnp", "TRAPNP");
        public static final Function TRANJFET = new Function("n-type-JFET-transistor", "njfet", "TRANJFET");
        public static final Function TRAPJFET = new Function("p-type-JFET-transistor", "pjfet", "TRAPJFET");
        public static final Function TRADMES = new Function("depletion-mesfet", "dmes", "TRADMES");
        public static final Function TRAEMES = new Function("enhancement-mesfet", "emes", "TRAEMES");
        public static final Function TRANSREF = new Function("prototype-defined-transistor", "tref", "TRANSREF");
        public static final Function TRANS = new Function("transistor", "trans", "TRANS");
        public static final Function TRA4NMOS = new Function("4-port-nMOS-transistor", "nmos4p", "TRA4NMOS");
        public static final Function TRA4DMOS = new Function("4-port-DMOS-transistor", "dmos4p", "TRA4DMOS");
        public static final Function TRA4PMOS = new Function("4-port-pMOS-transistor", "pmos4p", "TRA4PMOS");
        public static final Function TRA4NPN = new Function("4-port-NPN-transistor", "npn4p", "TRA4NPN");
        public static final Function TRA4PNP = new Function("4-port-PNP-transistor", "pnp4p", "TRA4PNP");
        public static final Function TRA4NJFET = new Function("4-port-n-type-JFET-transistor", "njfet4p", "TRA4NJFET");
        public static final Function TRA4PJFET = new Function("4-port-p-type-JFET-transistor", "pjfet4p", "TRA4PJFET");
        public static final Function TRA4DMES = new Function("4-port-depletion-mesfet", "dmes4p", "TRA4DMES");
        public static final Function TRA4EMES = new Function("4-port-enhancement-mesfet", "emes4p", "TRA4EMES");
        public static final Function TRANS4 = new Function("4-port-transistor", "trans4p", "TRANS4");
        public static final Function RESIST = new Function("resistor", "res", "RESIST");
        public static final Function PRESIST = new Function("poly-resistor", "pres", "PRESIST");
        public static final Function CAPAC = new Function("capacitor", "cap", "CAPAC");
        public static final Function ECAPAC = new Function("electrolytic-capacitor", "ecap", "ECAPAC");
        public static final Function DIODE = new Function("diode", "diode", "DIODE");
        public static final Function DIODEZ = new Function("zener-diode", "zdiode", "DIODEZ");
        public static final Function INDUCT = new Function("inductor", "ind", "INDUCT");
        public static final Function METER = new Function("meter", "meter", "METER");
        public static final Function BASE = new Function("base", "base", "BASE");
        public static final Function EMIT = new Function("emitter", "emit", "EMIT");
        public static final Function COLLECT = new Function("collector", "coll", "COLLECT");
        public static final Function BUFFER = new Function("buffer", "buf", "BUFFER");
        public static final Function GATEAND = new Function("AND-gate", "and", "GATEAND");
        public static final Function GATEOR = new Function("OR-gate", "or", "GATEOR");
        public static final Function GATEXOR = new Function("XOR-gate", "xor", "GATEXOR");
        public static final Function FLIPFLOPRSMS = new Function("flip-flop-RS-MS", "ffRSms", "FLIPFLOP");
        public static final Function FLIPFLOPRSP = new Function("flip-flop-RS-P", "ffRSp", "FLIPFLOP");
        public static final Function FLIPFLOPRSN = new Function("flip-flop-RS-N", "ffRSn", "FLIPFLOP");
        public static final Function FLIPFLOPJKMS = new Function("flip-flop-JK-MS", "ffJKms", "FLIPFLOP");
        public static final Function FLIPFLOPJKP = new Function("flip-flop-JK-P", "ffJKp", "FLIPFLOP");
        public static final Function FLIPFLOPJKN = new Function("flip-flop-JK-N", "ffJKn", "FLIPFLOP");
        public static final Function FLIPFLOPDMS = new Function("flip-flop-D-MS", "ffDms", "FLIPFLOP");
        public static final Function FLIPFLOPDP = new Function("flip-flop-D-P", "ffDp", "FLIPFLOP");
        public static final Function FLIPFLOPDN = new Function("flip-flop-D-N", "ffDn", "FLIPFLOP");
        public static final Function FLIPFLOPTMS = new Function("flip-flop-T-MS", "ffTms", "FLIPFLOP");
        public static final Function FLIPFLOPTP = new Function("flip-flop-T-P", "ffTp", "FLIPFLOP");
        public static final Function FLIPFLOPTN = new Function("flip-flop-T-N", "ffTn", "FLIPFLOP");
        public static final Function MUX = new Function("multiplexor", "mux", "MUX");
        public static final Function CONPOWER = new Function("power", "pwr", "CONPOWER");
        public static final Function CONGROUND = new Function("ground", "gnd", "CONGROUND");
        public static final Function SOURCE = new Function("source", "source", "SOURCE");
        public static final Function SUBSTRATE = new Function("substrate", "substr", "SUBSTRATE");
        public static final Function WELL = new Function("well", "well", "WELL");
        public static final Function ART = new Function("artwork", "art", "ART");
        public static final Function ARRAY = new Function("array", "array", "ARRAY");
        public static final Function ALIGN = new Function("align", "align", "ALIGN");
        public static final Function CCVS = new Function("ccvs", "ccvs", "CCVS");
        public static final Function CCCS = new Function("cccs", "cccs", "CCCS");
        public static final Function VCVS = new Function("vcvs", "vcvs", "VCVS");
        public static final Function VCCS = new Function("vccs", "vccs", "VCCS");
        public static final Function TLINE = new Function("transmission-line", "transm", "TLINE");

        private Function(String name, String shortName, String constantName) {
            this.name = name;
            this.shortName = shortName;
            this.constantName = constantName;
            this.basename = Name.findName(shortName + '@').getBasename();
            allFunctions.add(this);
        }

        public static List getFunctions() {
            return allFunctions;
        }

        public String getName() {
            return this.name;
        }

        public String getConstantName() {
            return this.constantName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public Name getBasename() {
            return this.basename;
        }

        public boolean isCapacitor() {
            return this == CAPAC || this == ECAPAC;
        }

        public boolean isResistor() {
            return this == RESIST || this == PRESIST;
        }

        public boolean isTransistor() {
            return this == TRANMOS || this == TRAPMOS || this == TRADMOS || this == TRA4NMOS || this == TRA4PMOS || this == TRA4DMOS || this == TRANPN || this == TRAPNP || this == TRANJFET || this == TRAPJFET || this == TRAEMES || this == TRADMES || this == TRA4NPN || this == TRA4PNP || this == TRA4NJFET || this == TRA4PJFET || this == TRA4EMES || this == TRA4DMES || this == TRANSREF || this == TRANS || this == TRANS4;
        }

        public boolean isFlipFlop() {
            return this == FLIPFLOPRSMS || this == FLIPFLOPRSP || this == FLIPFLOPRSN || this == FLIPFLOPJKMS || this == FLIPFLOPJKP || this == FLIPFLOPJKN || this == FLIPFLOPDMS || this == FLIPFLOPDP || this == FLIPFLOPDN || this == FLIPFLOPTMS || this == FLIPFLOPTP || this == FLIPFLOPTN;
        }

        public String toString() {
            return this.name;
        }
    }
}

