/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.trees;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Circuit {
    private EquivRecord myParent;
    private ArrayList netObjs = new ArrayList();

    private Circuit() {
    }

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Circuit please(List netObjs) {
        Circuit ckt = new Circuit();
        Iterator it = netObjs.iterator();
        while (it.hasNext()) {
            ckt.adopt((NetObject)it.next());
        }
        return ckt;
    }

    public void putInFinalForm() {
        HashSet<NetObject> goodObjs = new HashSet<NetObject>();
        Iterator it = this.netObjs.iterator();
        while (it.hasNext()) {
            NetObject n = (NetObject)it.next();
            if (n.isDeleted()) continue;
            Circuit.error(goodObjs.contains(n), "duplicate NetObj in Circuit!???");
            goodObjs.add(n);
            if (!(n instanceof Wire)) continue;
            ((Wire)n).putInFinalForm();
        }
        this.netObjs = new ArrayList();
        this.netObjs.addAll(goodObjs);
        this.netObjs.trimToSize();
    }

    public Iterator getNetObjs() {
        return this.netObjs.iterator();
    }

    public int numNetObjs() {
        return this.netObjs.size();
    }

    public int numUndeletedNetObjs() {
        int count = 0;
        Iterator it = this.getNetObjs();
        while (it.hasNext()) {
            NetObject n = (NetObject)it.next();
            if (n.isDeleted()) continue;
            ++count;
        }
        return count;
    }

    public void adopt(NetObject n) {
        this.netObjs.add(n);
        n.setParent(this);
    }

    public void checkMe(EquivRecord parent) {
        Circuit.error(this.getParent() != parent, "wrong parent");
    }

    public String nameString() {
        return "Circuit code=" + this.getCode() + " size=" + this.numNetObjs();
    }

    public int getCode() {
        return this.myParent != null ? this.myParent.getCode() : 0;
    }

    public EquivRecord getParent() {
        return this.myParent;
    }

    public void setParent(EquivRecord p) {
        this.myParent = p;
    }

    public HashMap apply(Strategy js) {
        HashMap<Integer, ArrayList<NetObject>> codeToNetObjs = new HashMap<Integer, ArrayList<NetObject>>();
        Iterator it = this.getNetObjs();
        while (it.hasNext()) {
            NetObject no = (NetObject)it.next();
            Integer code = js.doFor(no);
            Circuit.error(code == null, "null is no longer a legal code");
            ArrayList<NetObject> ns = (ArrayList<NetObject>)codeToNetObjs.get(code);
            if (ns == null) {
                ns = new ArrayList<NetObject>();
                codeToNetObjs.put(code, ns);
            }
            ns.add(no);
        }
        return codeToNetObjs;
    }
}

